/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.inquiry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.service.CustomerViewService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.krad.bo.BusinessObject;

public class CustomerInquirableImpl
extends KualiInquirableImpl {
    private static volatile CustomerViewService customerViewService;

    public List<Section> getSections(BusinessObject businessObject) {
        List sections = super.getSections(businessObject);
        sections = CustomerInquirableImpl.getCustomerViewService().getSections(sections);
        return sections;
    }

    public void addAdditionalSections(List sections, BusinessObject bo) {
        if (bo instanceof Customer) {
            Customer customer = (Customer)bo;
            ArrayList<Row> rows = new ArrayList<Row>();
            Field f = new Field();
            f.setBusinessObjectClassName(bo.getClass().getName());
            f.setPropertyName("Customer History Report");
            f.setFieldLabel("History Report");
            f.setPropertyValue("Click here to view the history report for this customer.");
            f.setFieldType("text");
            HtmlData.AnchorHtmlData inquiryHref = new HtmlData.AnchorHtmlData("", "", "view open item report");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("methodToCall", "search");
            parameters.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
            parameters.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
            parameters.put("docFormKey", "88888888");
            parameters.put("returnLocation", "");
            parameters.put("hideReturnLink", "true");
            parameters.put("reportName", "Customer History Report");
            parameters.put("customerNumber", customer.getCustomerNumber());
            parameters.put("customerName", customer.getCustomerName());
            inquiryHref.setHref(UrlFactory.parameterizeUrl((String)(this.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/arCustomerOpenItemReportLookup.do"), parameters));
            f.setInquiryURL((HtmlData)inquiryHref);
            rows.add(new Row(f));
            Section section = new Section();
            section.setRows(rows);
            section.setSectionTitle("Customer History Report");
            sections.add(section);
        }
    }

    public static CustomerViewService getCustomerViewService() {
        if (customerViewService == null) {
            customerViewService = (CustomerViewService)SpringContext.getBean(CustomerViewService.class);
        }
        return customerViewService;
    }
}

