/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.lookup.AccountsReceivableLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsInvoiceDocumentErrorLogLookupableHelperServiceImpl
extends AccountsReceivableLookupableHelperServiceImplBase {
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected DateTimeService dateTimeService;
    private PersonService personService;
    protected IdentityService identityService;

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        if ((fieldValues = LookupUtils.mapPrincipalNameToId(fieldValues, (String)"awardPrimaryFundManager.principalName", (String)"primaryFundManagerPrincipalId", (IdentityService)this.identityService)) == null) {
            return Collections.emptyList();
        }
        return super.getSearchResultsHelper(fieldValues, unbounded);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), this.updateFieldValuesForSearchCriteria(fieldValues)), false);
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        return this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), this.updateFieldValuesForSearchCriteria(fieldValues)), true);
    }

    protected Map<String, String> updateFieldValuesForSearchCriteria(Map<String, String> fieldValues) {
        HashMap<String, String> newFieldValues = new HashMap<String, String>(fieldValues);
        Object accounts = (String)newFieldValues.get("accounts");
        if (StringUtils.isNotBlank((CharSequence)accounts)) {
            if (!StringUtils.startsWith((CharSequence)accounts, (CharSequence)"*")) {
                accounts = "*" + (String)accounts;
            }
            if (!StringUtils.endsWith((CharSequence)accounts, (CharSequence)"*")) {
                accounts = (String)accounts + "*";
            }
        }
        newFieldValues.put("accounts", (String)accounts);
        String errorDate = (String)newFieldValues.get("errorDate");
        int index = StringUtils.indexOf((CharSequence)errorDate, (CharSequence)SearchOperator.LESS_THAN_EQUAL.toString());
        if (index == -1) {
            index = StringUtils.indexOf((CharSequence)errorDate, (CharSequence)SearchOperator.BETWEEN.toString());
            if (index != -1) {
                this.incrementErrorDate(newFieldValues, errorDate, index);
            }
        } else {
            this.incrementErrorDate(newFieldValues, errorDate, index);
        }
        return newFieldValues;
    }

    protected void incrementErrorDate(Map<String, String> newFieldValues, String errorDate, int index) {
        String errorDatePrefix = errorDate.substring(0, index + 2);
        String newDateString = this.contractsGrantsReportHelperService.correctEndDateForTime(errorDate.substring(index + 2));
        if (StringUtils.isNotBlank((CharSequence)errorDate.substring(index + 2))) {
            newFieldValues.put("errorDate", errorDatePrefix + newDateString);
        }
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        Person person;
        super.validateSearchParameters(fieldValues);
        String awardBeginningDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_awardBeginningDate");
        String awardBeginningDateToString = fieldValues.get("awardBeginningDate");
        String awardEndingDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_awardEndingDate");
        String awardEndingDateToString = fieldValues.get("awardEndingDate");
        String awardTotalAmount = fieldValues.get("awardTotalAmount");
        String cumulativeExpensesAmount = fieldValues.get("cumulativeExpensesAmount");
        String errorDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_errorDate");
        String errorDateToString = fieldValues.get("errorDate");
        String primaryFundManagerPrincipalName = fieldValues.get("awardPrimaryFundManager.principalName");
        String awardBeginningDateLabel = this.lookupPropertyLabel("awardBeginningDate");
        this.validateDate(awardBeginningDateFromString, "rangeLowerBoundKeyPrefix_awardBeginningDate", awardBeginningDateLabel + " From");
        this.validateDate(awardBeginningDateToString, "awardBeginningDate", awardBeginningDateLabel + " To");
        String awardEndingDateLabel = this.lookupPropertyLabel("awardEndingDate");
        this.validateDate(awardEndingDateFromString, "rangeLowerBoundKeyPrefix_awardEndingDate", awardEndingDateLabel + " From");
        this.validateDate(awardEndingDateToString, "awardEndingDate", awardEndingDateLabel + " To");
        if (StringUtils.isNotBlank((CharSequence)awardTotalAmount) && !KualiDecimal.isNumeric((String)awardTotalAmount)) {
            GlobalVariables.getMessageMap().putError("awardTotalAmount", "error.numeric", new String[]{this.lookupPropertyLabel("awardTotalAmount")});
        }
        if (StringUtils.isNotBlank((CharSequence)cumulativeExpensesAmount) && !KualiDecimal.isNumeric((String)cumulativeExpensesAmount)) {
            GlobalVariables.getMessageMap().putError("cumulativeExpensesAmount", "error.numeric", new String[]{this.lookupPropertyLabel("cumulativeExpensesAmount")});
        }
        String errorDateLabel = this.lookupPropertyLabel("errorDate");
        this.validateDate(errorDateFromString, "rangeLowerBoundKeyPrefix_errorDate", errorDateLabel + " From");
        this.validateDate(errorDateToString, "errorDate", errorDateLabel + " To");
        if (StringUtils.isNotEmpty((CharSequence)primaryFundManagerPrincipalName) && ObjectUtils.isNull((Object)(person = this.personService.getPersonByPrincipalName(primaryFundManagerPrincipalName)))) {
            GlobalVariables.getMessageMap().putError("awardPrimaryFundManager.principalName", "error.no.fund.manager.principal.name.found", new String[]{this.lookupPropertyLabel("awardPrimaryFundManager.principalName")});
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("Error(s) in search criteria");
        }
    }

    protected String lookupPropertyLabel(String propertyName) {
        return this.getDataDictionaryService().getAttributeLabel(ContractsGrantsInvoiceDocumentErrorLog.class, propertyName);
    }

    protected void validateDate(String dateString, String fieldName, String fieldLabel) {
        if (StringUtils.isNotBlank((CharSequence)dateString)) {
            try {
                this.dateTimeService.convertToDate(dateString);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError(fieldName, "error.invalidDateTime", new String[]{fieldLabel});
            }
        }
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

