/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.document.service.CustomerOpenItemReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.bo.BusinessObject;

public class CustomerOpenItemReportLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();
    protected CustomerOpenItemReportService customerOpenItemReportService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List results;
        LOG.debug("\n\n\n\n ***********************    getSearchResults() started\n");
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String reportName = ((String[])this.getParameters().get("reportName"))[0];
        if (StringUtils.equals((CharSequence)reportName, (CharSequence)"Customer History Report")) {
            String customerNumber = ((String[])this.getParameters().get("customerNumber"))[0];
            results = this.getCustomerOpenItemReportService().getPopulatedReportDetails(customerNumber);
        } else if (StringUtils.equals((CharSequence)reportName, (CharSequence)"Unpaid / Unapplied Amount Report")) {
            String customerNumber = ((String[])this.getParameters().get("customerNumber"))[0];
            String documentNumber = ((String[])this.getParameters().get("documentNumber"))[0];
            results = this.getCustomerOpenItemReportService().getPopulatedUnpaidUnappliedAmountReportDetails(customerNumber, documentNumber);
        } else {
            results = this.getCustomerOpenItemReportService().getPopulatedReportDetails(this.getParameters());
        }
        LOG.info("\t\t sending results back... \n\n\n");
        return new CollectionIncomplete((Collection)results, Long.valueOf(results.size()));
    }

    protected Map<String, String> getParameters(BusinessObject bo, Map<String, String> fieldConversions, String lookupImpl, List returnKeys) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "refresh");
        parameters.put("docFormKey", this.getDocFormKey());
        parameters.put("refreshCaller", lookupImpl);
        if (this.getReferencesToRefresh() != null) {
            parameters.put("referencesToRefresh", this.getReferencesToRefresh());
        }
        for (Object entry : this.getReturnKeys()) {
            String fieldNm = (String)entry;
            Object fieldVal = ObjectUtils.getPropertyValue((Object)bo, (String)fieldNm);
            if (fieldVal == null) {
                fieldVal = "";
            }
            if (fieldConversions.containsKey(fieldNm)) {
                fieldNm = fieldConversions.get(fieldNm);
            }
            if (fieldVal instanceof Date) {
                DateFormatter dateFormatter = new DateFormatter();
                fieldVal = dateFormatter.format(fieldVal);
            }
            parameters.put(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        List<? extends BusinessObject> displayList = this.getSearchResults(lookupForm.getFieldsForLookup());
        HashMap propertyTypes = new HashMap();
        boolean hasReturnableRow = false;
        String customerNumber = ((String[])this.getParameters().get("customerNumber"))[0];
        String customerName = ((String[])this.getParameters().get("customerName"))[0];
        Collection<String> refDocumentNumbers = this.getCustomerOpenItemReportService().getDocumentNumbersOfReferenceReports(customerNumber);
        for (BusinessObject businessObject : displayList) {
            String returnUrl = "";
            String actionUrls = "";
            List columns = this.getColumns();
            for (Column col : columns) {
                Formatter formatter = col.getFormatter();
                String propValue = "";
                Object prop = ObjectUtils.getPropertyValue((Object)businessObject, (String)col.getPropertyName());
                if (prop != null) {
                    propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                }
                Class propClass = (Class)propertyTypes.get(col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                col.setPropertyValue(propValue);
                if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                if (StringUtils.equals((CharSequence)"documentNumber", (CharSequence)col.getPropertyName())) {
                    String baseUrl = this.configurationService.getPropertyValueAsString("kew.url") + "/DocHandler.do";
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("docId", propValue);
                    parameters.put("command", "displayDocSearchView");
                    String propertyURL = UrlFactory.parameterizeUrl((String)baseUrl, parameters);
                    col.setPropertyURL(propertyURL);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"unpaidUnappliedAmount", (CharSequence)col.getPropertyName())) {
                    String documentNumber = ObjectUtils.getPropertyValue((Object)businessObject, (String)"documentNumber").toString();
                    if (refDocumentNumbers.contains(documentNumber)) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
                        params.put("returnLocation", "");
                        params.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
                        params.put("methodToCall", "search");
                        params.put("customerNumber", customerNumber);
                        params.put("reportName", "Unpaid / Unapplied Amount Report");
                        params.put("customerName", customerName);
                        params.put("documentNumber", documentNumber);
                        params.put("docFormKey", "88888888");
                        String href = UrlFactory.parameterizeUrl((String)"arCustomerOpenItemReportLookup.do", params);
                        col.setPropertyURL(href);
                        continue;
                    }
                    col.setPropertyURL("");
                    continue;
                }
                col.setPropertyURL("");
            }
            ResultRow row = new ResultRow(columns, returnUrl, actionUrls);
            if (businessObject instanceof PersistableBusinessObject) {
                row.setObjectId(((PersistableBusinessObject)businessObject).getObjectId());
            }
            boolean isRowReturnable = this.isResultReturnable(businessObject);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    public CustomerOpenItemReportService getCustomerOpenItemReportService() {
        return this.customerOpenItemReportService;
    }

    public void setCustomerOpenItemReportService(CustomerOpenItemReportService customerOpenItemReportService) {
        this.customerOpenItemReportService = customerOpenItemReportService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

