/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerCreditMemo;
import org.kuali.kfs.integration.ar.AccountsReceivableDocumentHeader;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.ReceivableCustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.ReceivableCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.SalesTaxCustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.TaxDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocumentBase;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class CustomerCreditMemoDocument
extends GeneralLedgerPostingDocumentBase
implements GeneralLedgerPendingEntrySource,
AmountTotaling,
AccountsReceivableCustomerCreditMemo {
    private static final Logger LOG = LogManager.getLogger();
    protected String statusCode;
    protected String financialDocumentReferenceInvoiceNumber;
    protected KualiDecimal crmTotalItemAmount = KualiDecimal.ZERO;
    protected KualiDecimal crmTotalTaxAmount = KualiDecimal.ZERO;
    protected KualiDecimal crmTotalAmount = KualiDecimal.ZERO;
    protected Integer invOutstandingDays;
    protected CustomerInvoiceDocument invoice;
    protected org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    protected List<CustomerCreditMemoDetail> creditMemoDetails;
    protected transient TaxService taxService;
    protected transient AccountsReceivableTaxService arTaxService;

    public CustomerCreditMemoDocument() {
        this.setPostingYear(((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
        this.creditMemoDetails = new ArrayList<CustomerCreditMemoDetail>();
        this.setGeneralLedgerPendingEntries(new ArrayList());
    }

    public List<CustomerCreditMemoDetail> getCreditMemoDetails() {
        return this.creditMemoDetails;
    }

    public void setCreditMemoDetails(List<CustomerCreditMemoDetail> creditMemoDetails) {
        this.creditMemoDetails = creditMemoDetails;
    }

    public String getFinancialDocumentReferenceInvoiceNumber() {
        return this.financialDocumentReferenceInvoiceNumber;
    }

    public void setFinancialDocumentReferenceInvoiceNumber(String financialDocumentReferenceInvoiceNumber) {
        if (financialDocumentReferenceInvoiceNumber != null) {
            financialDocumentReferenceInvoiceNumber = financialDocumentReferenceInvoiceNumber.toUpperCase(Locale.US);
        }
        this.financialDocumentReferenceInvoiceNumber = financialDocumentReferenceInvoiceNumber;
    }

    public CustomerInvoiceDocument getInvoice() {
        if (ObjectUtils.isNull((Object)this.invoice) && StringUtils.isNotEmpty((CharSequence)this.financialDocumentReferenceInvoiceNumber)) {
            this.refreshReferenceObject("invoice");
        }
        return this.invoice;
    }

    public void setInvoice(CustomerInvoiceDocument invoice) {
        this.invoice = invoice;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void initiateDocument() {
        LOG.debug("initiateDocument() started");
        this.setStatusCode("INIT");
    }

    public void clearInitFields() {
        LOG.debug("clearDocument() started");
        this.setFinancialDocumentReferenceInvoiceNumber(null);
    }

    public KualiDecimal getCrmTotalAmount() {
        return this.crmTotalAmount;
    }

    public String getCurrencyFormattedCrmTotalAmount() {
        return (String)new CurrencyFormatter().format((Object)this.crmTotalAmount);
    }

    public void setCrmTotalAmount(KualiDecimal crmTotalAmount) {
        this.crmTotalAmount = crmTotalAmount;
    }

    public KualiDecimal getCrmTotalItemAmount() {
        return this.crmTotalItemAmount;
    }

    public String getCurrencyFormattedCrmTotalItemAmount() {
        return (String)new CurrencyFormatter().format((Object)this.crmTotalItemAmount);
    }

    public void setCrmTotalItemAmount(KualiDecimal crmTotalItemAmount) {
        this.crmTotalItemAmount = crmTotalItemAmount;
    }

    public KualiDecimal getCrmTotalTaxAmount() {
        return this.crmTotalTaxAmount;
    }

    public String getCurrencyFormattedCrmTotalTaxAmount() {
        return (String)new CurrencyFormatter().format((Object)this.crmTotalTaxAmount);
    }

    public void setCrmTotalTaxAmount(KualiDecimal crmTotalTaxAmount) {
        this.crmTotalTaxAmount = crmTotalTaxAmount;
    }

    public Integer getInvOutstandingDays() {
        Timestamp invBillingDateTimestamp = new Timestamp(this.invoice.getBillingDate().getTime());
        Timestamp todayDateTimestamp = new Timestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate().getTime());
        double diffInDays = KfsDateUtils.getDifferenceInDays((Timestamp)invBillingDateTimestamp, (Timestamp)todayDateTimestamp);
        this.invOutstandingDays = new KualiDecimal(diffInDays).intValue();
        return this.invOutstandingDays;
    }

    public void setInvOutstandingDays(Integer invOutstandingDays) {
        this.invOutstandingDays = invOutstandingDays;
    }

    public void recalculateTotalsBasedOnChangedItemAmount(CustomerCreditMemoDetail customerCreditMemoDetail) {
        KualiDecimal duplicateCreditMemoItemTotalAmount = customerCreditMemoDetail.getDuplicateCreditMemoItemTotalAmount();
        KualiDecimal creditMemoItemTotalAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        if (ObjectUtils.isNotNull((Object)duplicateCreditMemoItemTotalAmount)) {
            this.prepareTotalsForUpdate(duplicateCreditMemoItemTotalAmount, this.getArTaxService().isCustomerInvoiceDetailTaxable(this.getInvoice(), customerCreditMemoDetail.getCustomerInvoiceDetail()));
        }
        this.recalculateTotals(creditMemoItemTotalAmount, this.getArTaxService().isCustomerInvoiceDetailTaxable(this.getInvoice(), customerCreditMemoDetail.getCustomerInvoiceDetail()));
        customerCreditMemoDetail.setDuplicateCreditMemoItemTotalAmount(creditMemoItemTotalAmount);
    }

    public void recalculateTotals(CustomerCreditMemoDetail customerCreditMemoDetail) {
        KualiDecimal duplicateCreditMemoItemTotalAmount = customerCreditMemoDetail.getDuplicateCreditMemoItemTotalAmount();
        if (ObjectUtils.isNotNull((Object)duplicateCreditMemoItemTotalAmount)) {
            this.prepareTotalsForUpdate(duplicateCreditMemoItemTotalAmount, this.getArTaxService().isCustomerInvoiceDetailTaxable(this.getInvoice(), customerCreditMemoDetail.getCustomerInvoiceDetail()));
            customerCreditMemoDetail.setDuplicateCreditMemoItemTotalAmount(null);
        }
    }

    public void recalculateTotals(KualiDecimal itemAmount, boolean isTaxableItemFlag) {
        this.crmTotalItemAmount = (KualiDecimal)this.crmTotalItemAmount.add((AbstractKualiDecimal)itemAmount);
        if (isTaxableItemFlag) {
            this.crmTotalTaxAmount = (KualiDecimal)this.crmTotalTaxAmount.add((AbstractKualiDecimal)this.getTaxService().getTotalSalesTaxAmount(this.invoice.getBillingDate(), this.getPostalCode(), itemAmount));
        }
        this.crmTotalAmount = (KualiDecimal)this.crmTotalItemAmount.add((AbstractKualiDecimal)this.crmTotalTaxAmount);
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(this.crmTotalAmount);
    }

    protected void prepareTotalsForUpdate(KualiDecimal oldItemAmount, boolean isTaxableItemFlag) {
        KualiDecimal oldItemTaxAmount = KualiDecimal.ZERO;
        if (isTaxableItemFlag) {
            oldItemTaxAmount = this.getTaxService().getTotalSalesTaxAmount(this.invoice.getBillingDate(), this.getPostalCode(), oldItemAmount);
        }
        this.crmTotalItemAmount = (KualiDecimal)this.crmTotalItemAmount.subtract((AbstractKualiDecimal)oldItemAmount);
        this.crmTotalTaxAmount = (KualiDecimal)this.crmTotalTaxAmount.subtract((AbstractKualiDecimal)oldItemTaxAmount);
        this.crmTotalAmount = (KualiDecimal)this.crmTotalAmount.subtract((AbstractKualiDecimal)((KualiDecimal)oldItemAmount.add((AbstractKualiDecimal)oldItemTaxAmount)));
    }

    public void resetTotals() {
        this.crmTotalItemAmount = KualiDecimal.ZERO;
        this.crmTotalTaxAmount = KualiDecimal.ZERO;
        this.crmTotalAmount = KualiDecimal.ZERO;
    }

    public void populateCustomerCreditMemoDetails() {
        this.setStatusCode("INPR");
        if (this.getAccountsReceivableDocumentHeader() == null) {
            org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = ((AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class)).getNewAccountsReceivableDocumentHeaderForCurrentUser();
            accountsReceivableDocumentHeader.setDocumentNumber(this.getDocumentNumber());
            accountsReceivableDocumentHeader.setCustomerNumber(this.invoice.getAccountsReceivableDocumentHeader().getCustomerNumber());
            this.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        }
        List<CustomerInvoiceDetail> customerInvoiceDetails = this.invoice.getCustomerInvoiceDetailsWithoutDiscounts();
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetails) {
            CustomerCreditMemoDetail customerCreditMemoDetail = new CustomerCreditMemoDetail();
            if (ObjectUtils.isNull((Object)customerInvoiceDetail.getInvoiceItemTaxAmount())) {
                customerInvoiceDetail.setInvoiceItemTaxAmount(KualiDecimal.ZERO);
            }
            customerCreditMemoDetail.setInvoiceLineTotalAmount(customerInvoiceDetail.getInvoiceItemTaxAmount(), customerInvoiceDetail.getInvoiceItemPreTaxAmount());
            customerCreditMemoDetail.setReferenceInvoiceItemNumber(customerInvoiceDetail.getSequenceNumber());
            KualiDecimal openInvoiceAmount = customerInvoiceDetail.getAmountOpen();
            customerCreditMemoDetail.setInvoiceOpenItemAmount(openInvoiceAmount);
            customerCreditMemoDetail.setInvoiceOpenItemQuantity(this.getInvoiceOpenItemQuantity(customerCreditMemoDetail, customerInvoiceDetail));
            customerCreditMemoDetail.setDocumentNumber(this.documentNumber);
            customerCreditMemoDetail.setFinancialDocumentReferenceInvoiceNumber(this.financialDocumentReferenceInvoiceNumber);
            this.creditMemoDetails.add(customerCreditMemoDetail);
        }
    }

    public void populateCustomerCreditMemoDetailsAfterLoad() {
        for (CustomerCreditMemoDetail creditMemoDetail : this.creditMemoDetails) {
            creditMemoDetail.setFinancialDocumentReferenceInvoiceNumber(this.financialDocumentReferenceInvoiceNumber);
            CustomerInvoiceDetail customerInvoiceDetail = creditMemoDetail.getCustomerInvoiceDetail();
            KualiDecimal openInvoiceAmount = customerInvoiceDetail.getAmountOpen();
            creditMemoDetail.setInvoiceOpenItemAmount(openInvoiceAmount);
            creditMemoDetail.setInvoiceOpenItemQuantity(this.getInvoiceOpenItemQuantity(creditMemoDetail, customerInvoiceDetail));
            if (ObjectUtils.isNull((Object)customerInvoiceDetail.getInvoiceItemTaxAmount())) {
                customerInvoiceDetail.setInvoiceItemTaxAmount(KualiDecimal.ZERO);
            }
            creditMemoDetail.setInvoiceLineTotalAmount(customerInvoiceDetail.getInvoiceItemTaxAmount(), customerInvoiceDetail.getInvoiceItemPreTaxAmount());
            KualiDecimal creditMemoItemAmount = creditMemoDetail.getCreditMemoItemTotalAmount();
            creditMemoDetail.setDuplicateCreditMemoItemTotalAmount(creditMemoItemAmount);
            if (!ObjectUtils.isNotNull((Object)creditMemoItemAmount)) continue;
            KualiDecimal creditMemoTaxAmount = this.getArTaxService().isCustomerInvoiceDetailTaxable(this.invoice, customerInvoiceDetail) ? this.getTaxService().getTotalSalesTaxAmount(this.invoice.getBillingDate(), this.getPostalCode(), creditMemoItemAmount) : KualiDecimal.ZERO;
            creditMemoDetail.setCreditMemoItemTaxAmount(creditMemoTaxAmount);
            creditMemoDetail.setCreditMemoLineTotalAmount((KualiDecimal)creditMemoItemAmount.add((AbstractKualiDecimal)creditMemoTaxAmount));
            this.crmTotalItemAmount = (KualiDecimal)this.crmTotalItemAmount.add((AbstractKualiDecimal)creditMemoItemAmount);
            this.crmTotalTaxAmount = (KualiDecimal)this.crmTotalTaxAmount.add((AbstractKualiDecimal)creditMemoTaxAmount);
            this.crmTotalAmount = (KualiDecimal)this.crmTotalAmount.add((AbstractKualiDecimal)((KualiDecimal)creditMemoItemAmount.add((AbstractKualiDecimal)creditMemoTaxAmount)));
        }
    }

    public BigDecimal getInvoiceOpenItemQuantity(CustomerCreditMemoDetail customerCreditMemoDetail, CustomerInvoiceDetail customerInvoiceDetail) {
        BigDecimal invoiceOpenItemQuantity;
        BigDecimal invoiceItemUnitPrice = customerInvoiceDetail.getInvoiceItemUnitPrice();
        if (ObjectUtils.isNull((Object)invoiceItemUnitPrice) || invoiceItemUnitPrice.equals(BigDecimal.ZERO)) {
            invoiceOpenItemQuantity = BigDecimal.ZERO;
        } else {
            KualiDecimal invoiceOpenItemAmount;
            KualiDecimal invoiceOpenItemPretaxAmount = invoiceOpenItemAmount = customerCreditMemoDetail.getInvoiceOpenItemAmount();
            if (this.getArTaxService().isCustomerInvoiceDetailTaxable(this.getInvoice(), customerInvoiceDetail)) {
                invoiceOpenItemPretaxAmount = this.getCustomerInvoiceDetailOpenPretaxAmount(invoiceOpenItemAmount);
            }
            invoiceOpenItemQuantity = invoiceOpenItemPretaxAmount.bigDecimalValue().divide(invoiceItemUnitPrice, ArConstants.ITEM_QUANTITY_SCALE, 4);
        }
        return invoiceOpenItemQuantity;
    }

    protected KualiDecimal getCustomerInvoiceDetailOpenPretaxAmount(KualiDecimal openAmount) {
        Date dateOfTransaction = this.getInvoice().getBillingDate();
        return ((TaxService)SpringContext.getBean(TaxService.class)).getPretaxAmount(dateOfTransaction, this.getPostalCode(), openAmount);
    }

    public void prepareForSave(KualiDocumentEvent event) {
        CustomerCreditMemoDocument customerCreditMemoDocument = (CustomerCreditMemoDocument)event.getDocument();
        CustomerCreditMemoDocumentService customerCreditMemoDocumentService = (CustomerCreditMemoDocumentService)SpringContext.getBean(CustomerCreditMemoDocumentService.class);
        customerCreditMemoDocumentService.recalculateCustomerCreditMemoDocument(customerCreditMemoDocument, false);
        if (!((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this)) {
            this.logErrors();
            throw new ValidationException("general ledger GLPE generation failed");
        }
        super.prepareForSave(event);
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public void clearAnyGeneralLedgerPendingEntries() {
        this.generalLedgerPendingEntries = new ArrayList();
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> generalLedgerPendingEntrySourceDetails = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        if (this.creditMemoDetails != null) {
            for (CustomerCreditMemoDetail customerCreditMemoDetail : this.creditMemoDetails) {
                KualiDecimal amount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
                if (!ObjectUtils.isNotNull((Object)amount) || !amount.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
                generalLedgerPendingEntrySourceDetails.add(customerCreditMemoDetail);
            }
        }
        return generalLedgerPendingEntrySourceDetails;
    }

    public void addPendingEntry(GeneralLedgerPendingEntry entry) {
        this.generalLedgerPendingEntries.add(entry);
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail postable) {
        return postable.getAmount();
    }

    public String getFinancialDocumentTypeCode() {
        return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(((Object)((Object)this)).getClass());
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        if (StringUtils.isNotBlank((CharSequence)this.getFinancialDocumentReferenceInvoiceNumber())) {
            ArrayList<String> documentIds = new ArrayList<String>();
            documentIds.add(this.getFinancialDocumentReferenceInvoiceNumber());
            return documentIds;
        }
        return null;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.populateCustomerCreditMemoDetailsAfterLoad();
            CustomerCreditMemoDocumentService service = (CustomerCreditMemoDocumentService)SpringContext.getBean(CustomerCreditMemoDocumentService.class);
            service.completeCustomerCreditMemo(this);
        }
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        this.addReceivableGLPEs(sequenceHelper, glpeSourceDetail);
        sequenceHelper.increment();
        this.addIncomeGLPEs(sequenceHelper, glpeSourceDetail);
        CustomerInvoiceDetail invoiceDetail = ((CustomerCreditMemoDetail)glpeSourceDetail).getCustomerInvoiceDetail();
        if (this.getArTaxService().isCustomerInvoiceDetailTaxable(this.getInvoice(), invoiceDetail)) {
            this.addSalesTaxGLPEs(sequenceHelper, glpeSourceDetail);
        }
        return true;
    }

    protected void addReceivableGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        CustomerCreditMemoDetail customerCreditMemoDetail = (CustomerCreditMemoDetail)glpeSourceDetail;
        CustomerInvoiceDetail customerInvoiceDetail = customerCreditMemoDetail.getCustomerInvoiceDetail();
        ReceivableCustomerInvoiceDetail receivableCustomerInvoiceDetail = new ReceivableCustomerInvoiceDetail(customerInvoiceDetail, this.getInvoice());
        boolean isDebit = false;
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        service.createAndAddGenericInvoiceRelatedGLPEs(this, (GeneralLedgerPendingEntrySourceDetail)receivableCustomerInvoiceDetail, sequenceHelper, isDebit, false, customerCreditMemoDetail.getCreditMemoItemTotalAmount());
    }

    protected void addIncomeGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        CustomerCreditMemoDetail customerCreditMemoDetail = (CustomerCreditMemoDetail)glpeSourceDetail;
        boolean isDebit = true;
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        service.createAndAddGenericInvoiceRelatedGLPEs(this, customerCreditMemoDetail, sequenceHelper, isDebit, false, customerCreditMemoDetail.getCreditMemoItemTotalAmount());
    }

    protected void addSalesTaxGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        CustomerCreditMemoDetail customerCreditMemoDetail = (CustomerCreditMemoDetail)glpeSourceDetail;
        boolean isDebit = false;
        String postalCode = this.getPostalCode();
        Date dateOfTransaction = this.getInvoice().getBillingDate();
        List salesTaxDetails = this.getTaxService().getSalesTaxDetails(dateOfTransaction, postalCode, customerCreditMemoDetail.getCreditMemoItemTotalAmount());
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        for (TaxDetail salesTaxDetail : salesTaxDetails) {
            SalesTaxCustomerCreditMemoDetail salesTaxCustomerCreditMemoDetail = new SalesTaxCustomerCreditMemoDetail(salesTaxDetail, customerCreditMemoDetail);
            salesTaxCustomerCreditMemoDetail.setCustomerInvoiceDetail(customerCreditMemoDetail.getCustomerInvoiceDetail());
            ReceivableCustomerCreditMemoDetail receivableCustomerCreditMemoDetail = new ReceivableCustomerCreditMemoDetail(salesTaxCustomerCreditMemoDetail, this);
            receivableCustomerCreditMemoDetail.setCustomerInvoiceDetail(customerCreditMemoDetail.getCustomerInvoiceDetail());
            sequenceHelper.increment();
            service.createAndAddGenericInvoiceRelatedGLPEs(this, receivableCustomerCreditMemoDetail, sequenceHelper, isDebit, false, salesTaxDetail.getTaxAmount());
            sequenceHelper.increment();
            service.createAndAddGenericInvoiceRelatedGLPEs(this, salesTaxCustomerCreditMemoDetail, sequenceHelper, !isDebit, false, salesTaxDetail.getTaxAmount());
        }
    }

    public KualiDecimal getTotalDollarAmount() {
        return this.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount();
    }

    public org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return this.accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(AccountsReceivableDocumentHeader arDocHeader) {
        this.accountsReceivableDocumentHeader = (org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader)arDocHeader;
    }

    public String getPostalCode() {
        return this.getArTaxService().getPostalCodeForTaxation(this.getInvoice());
    }

    public TaxService getTaxService() {
        if (this.taxService == null) {
            this.taxService = (TaxService)SpringContext.getBean(TaxService.class);
        }
        return this.taxService;
    }

    public AccountsReceivableTaxService getArTaxService() {
        if (this.arTaxService == null) {
            this.arTaxService = (AccountsReceivableTaxService)SpringContext.getBean(AccountsReceivableTaxService.class);
        }
        return this.arTaxService;
    }
}

