/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.BlanketApproveDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustableDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class PaymentApplicationAdjustmentDocument
extends AccountingDocumentBase
implements GeneralLedgerPendingEntrySource,
PaymentApplicationAdjustableDocument,
AmountTotaling {
    private static final Logger LOG = LogManager.getLogger();
    private static final String LAUNCHED_FROM_BATCH = "LaunchedBySystemUser";
    private final List<NonAppliedHolding> nonAppliedHoldings = new ArrayList<NonAppliedHolding>();
    private final List<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
    private AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    private String adjusteeDocumentNumber;
    private String adjustmentDocumentNumber;
    private transient DocumentService documentService;
    private transient PaymentApplicationAdjustmentDocumentService paymentApplicationAdjustmentDocumentService;

    public String getAdjusteeDocumentNumber() {
        return this.adjusteeDocumentNumber;
    }

    public void setAdjusteeDocumentNumber(String adjusteeDocumentNumber) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjusteeDocumentNumber), (String)"An APPA doc must know what APP doc it adjusts", (Object[])new Object[0]);
        this.adjusteeDocumentNumber = adjusteeDocumentNumber;
    }

    @Override
    public String getAdjustmentDocumentNumber() {
        return this.adjustmentDocumentNumber;
    }

    public void setAdjustmentDocumentNumber(String adjustmentDocumentNumber) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)adjustmentDocumentNumber), (String)"An APPA doc must know what APPA doc adjusts it", (Object[])new Object[0]);
        this.adjustmentDocumentNumber = adjustmentDocumentNumber;
    }

    @Override
    public boolean isAdjusted() {
        return StringUtils.isNotBlank((CharSequence)this.getAdjustmentDocumentNumber());
    }

    public void clearAdjustmentDocumentNumber() {
        this.adjustmentDocumentNumber = null;
    }

    @Override
    public List<NonAppliedHolding> getNonAppliedHoldings() {
        return this.nonAppliedHoldings;
    }

    public void setNonAppliedHoldings(List<NonAppliedHolding> nonAppliedHoldings) {
        Validate.isTrue((nonAppliedHoldings != null ? 1 : 0) != 0, (String)"nonAppliedHoldings cannot be null", (Object[])new Object[0]);
        this.nonAppliedHoldings.clear();
        this.nonAppliedHoldings.addAll(nonAppliedHoldings);
    }

    public List buildListOfDeletionAwareLists() {
        List deletionAwareLists = super.buildListOfDeletionAwareLists();
        CollectionUtils.addIgnoreNull((Collection)deletionAwareLists, this.invoicePaidApplieds);
        CollectionUtils.addIgnoreNull((Collection)deletionAwareLists, this.nonAppliedHoldings);
        return deletionAwareLists;
    }

    public void fillInFiscalPeriodYear(Collection<GeneralLedgerPendingEntry> glpes) {
        this.getPaymentApplicationAdjustmentDocumentService().fillInFiscalPeriodYear(glpes);
    }

    public KualiDecimal getTotalApplied() {
        return (KualiDecimal)((KualiDecimal)KualiDecimal.ZERO.add((AbstractKualiDecimal)this.getSumOfInvoicePaidApplieds())).add((AbstractKualiDecimal)this.getSumOfNonAppliedHoldings());
    }

    private KualiDecimal getSumOfInvoicePaidApplieds() {
        return this.invoicePaidApplieds.stream().map(InvoicePaidApplied::getInvoiceItemAppliedAmount).reduce(KualiDecimal.ZERO, AbstractKualiDecimal::add);
    }

    private KualiDecimal getSumOfNonAppliedHoldings() {
        return this.nonAppliedHoldings.stream().map(NonAppliedHolding::getFinancialDocumentLineAmount).reduce(KualiDecimal.ZERO, AbstractKualiDecimal::add);
    }

    public KualiDecimal getTotalDollarAmount() {
        PaymentApplicationDocument rootAdjusteeDocument = this.getRootAdjusteeDocument();
        KualiDecimal rootAdjusteeTotalFromControl = rootAdjusteeDocument.getTotalFromControl();
        KualiDecimal rootAdjusteeNonArTotal = rootAdjusteeDocument.getNonArTotal();
        KualiDecimal totalDollarAmount = (KualiDecimal)rootAdjusteeTotalFromControl.subtract((AbstractKualiDecimal)rootAdjusteeNonArTotal);
        LOG.debug("getTotalDollarAmount() - Exit : totalDollarAmount={}", (Object)totalDollarAmount);
        return totalDollarAmount;
    }

    public KualiDecimal getUnallocatedBalance() {
        KualiDecimal amount = this.getTotalDollarAmount();
        amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)this.getTotalApplied());
        return amount;
    }

    public boolean isFinal() {
        return this.getDocumentHeader().getWorkflowDocument().isApproved();
    }

    @Override
    public List<InvoicePaidApplied> getInvoicePaidApplieds() {
        return this.invoicePaidApplieds;
    }

    public void setInvoicePaidApplieds(List<InvoicePaidApplied> invoicePaidApplieds) {
        Validate.isTrue((invoicePaidApplieds != null ? 1 : 0) != 0, (String)"invoicePaidApplieds cannot be null", (Object[])new Object[0]);
        this.invoicePaidApplieds.clear();
        this.invoicePaidApplieds.addAll(invoicePaidApplieds);
    }

    @Override
    public AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return this.accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        try {
            Document adjusteeDocument = this.getDocumentService().getByDocumentHeaderId(this.adjusteeDocumentNumber);
            this.getPaymentApplicationAdjustmentDocumentService().createPendingEntries(adjusteeDocument, (Document)this, this.getPostingYear(), sequenceHelper).forEach(arg_0 -> ((PaymentApplicationAdjustmentDocument)this).addPendingEntry(arg_0));
            return true;
        }
        catch (WorkflowException e) {
            LOG.error("generateDocumentGeneralLedgerPendingEntries(...) - Failed to generate pending entries", (Throwable)e);
            return false;
        }
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        return null;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        return new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        List<String> invoiceNumbers = this.getInvoicePaidApplieds().stream().map(InvoicePaidApplied::getFinancialDocumentReferenceInvoiceNumber).collect(Collectors.toList());
        if (invoiceNumbers.isEmpty()) {
            return null;
        }
        return invoiceNumbers;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange(...) - Enter : statusChangedEvent={}", (Object)statusChangeEvent);
        super.doRouteStatusChange(statusChangeEvent);
        if (this.postProcessingShouldBeDone()) {
            Document adjusteeDocument = this.getAdjusteeDocument();
            this.getPaymentApplicationAdjustmentDocumentService().postProcess(adjusteeDocument, (Document)this);
        }
        LOG.debug("doRouteStatusChange(...) - Exit");
    }

    private boolean postProcessingShouldBeDone() {
        LOG.debug("postProcessingShouldBeDone(...) - Enter");
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        boolean postProcessingShouldBeDone = workflowDocument.isFinal();
        LOG.debug("postProcessingShouldBeDone(...) - Exit : postProcessingShouldBeDone={}", (Object)postProcessingShouldBeDone);
        return postProcessingShouldBeDone;
    }

    private PaymentApplicationDocument getRootAdjusteeDocument() {
        Document adjusteeDocument = this.getAdjusteeDocument();
        while (!(adjusteeDocument instanceof PaymentApplicationDocument)) {
            adjusteeDocument = ((PaymentApplicationAdjustmentDocument)adjusteeDocument).getAdjusteeDocument();
        }
        return (PaymentApplicationDocument)adjusteeDocument;
    }

    private Document getAdjusteeDocument() {
        Document adjusteeDocument = null;
        try {
            adjusteeDocument = this.getDocumentService().getByDocumentHeaderId(this.adjusteeDocumentNumber);
        }
        catch (WorkflowException e) {
            LOG.error("getAdjusteeDocument(...) - This should not happen! : documentNumber={}; adjusteeDocumentNumber={}", (Object)this.getDocumentNumber(), (Object)this.adjusteeDocumentNumber, (Object)e);
        }
        return adjusteeDocument;
    }

    public void prepareForSave(KualiDocumentEvent event) {
        boolean entriesCreated;
        super.prepareForSave(event);
        this.nonAppliedHoldings.stream().filter(ObjectUtils::isNotNull).filter(nah -> ObjectUtils.isNull((Object)nah.getReferenceFinancialDocumentNumber())).forEach(nah -> nah.setReferenceFinancialDocumentNumber(this.documentNumber));
        if (PaymentApplicationAdjustmentDocument.generalLedgerPendingEntriesShouldBeCreated(event) && !(entriesCreated = this.getGeneralLedgerPendingEntryService().generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this))) {
            this.logErrors();
            throw new ValidationException("GLPE generation failed");
        }
    }

    private static boolean generalLedgerPendingEntriesShouldBeCreated(KualiDocumentEvent event) {
        return event instanceof SaveDocumentEvent || event instanceof RouteDocumentEvent || event instanceof ApproveDocumentEvent || event instanceof BlanketApproveDocumentEvent;
    }

    public boolean answerSplitNodeQuestion(String nodeName) {
        if (LAUNCHED_FROM_BATCH.equals(nodeName)) {
            return this.launchedFromBatch();
        }
        throw new UnsupportedOperationException("answerSplitNode('" + nodeName + "') was called but no handler for nodeName specified.");
    }

    private boolean launchedFromBatch() {
        String currentInitiatorPrincipalId = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId();
        String documentInitiatorPrincipalId = this.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        return currentInitiatorPrincipalId.equalsIgnoreCase(documentInitiatorPrincipalId);
    }

    DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.documentService;
    }

    private PaymentApplicationAdjustmentDocumentService getPaymentApplicationAdjustmentDocumentService() {
        if (this.paymentApplicationAdjustmentDocumentService == null) {
            this.paymentApplicationAdjustmentDocumentService = (PaymentApplicationAdjustmentDocumentService)SpringContext.getBean(PaymentApplicationAdjustmentDocumentService.class);
        }
        return this.paymentApplicationAdjustmentDocumentService;
    }
}

