/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.HashMap;
import java.util.Set;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.context.SpringContext;

public class MilestoneScheduleMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    public static final String MILESTONE = "Milestone";

    public Set<String> getSecurePotentiallyReadOnlySectionIds() {
        Set readOnlySectionIds = super.getSecurePotentiallyReadOnlySectionIds();
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        MaintainableCollectionDefinition maintCollDef = this.getMaintainableCollection();
        this.conditionallyHideMilestoneCollectionEditing(principalId, maintCollDef);
        return readOnlySectionIds;
    }

    protected void conditionallyHideMilestoneCollectionEditing(String principalId, MaintainableCollectionDefinition maintCollDef) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("componentName", MILESTONE);
        permissionDetails.put("sectionId", "Milestones");
        HashMap qualificationDetails = new HashMap();
        if (MilestoneScheduleMaintenanceDocumentAuthorizer.getPermissionService().isAuthorizedByTemplate(principalId, "KR-NS", "Add Line", permissionDetails, qualificationDetails)) {
            maintCollDef.setIncludeAddLine(true);
            maintCollDef.setIncludeMultipleLookupLine(true);
        } else {
            maintCollDef.setIncludeAddLine(false);
            maintCollDef.setIncludeMultipleLookupLine(false);
        }
    }

    public MaintainableCollectionDefinition getMaintainableCollection() {
        return ((MaintenanceDocumentDictionaryService)SpringContext.getBean(MaintenanceDocumentDictionaryService.class)).getMaintainableCollection("MILE", "milestones");
    }
}

