/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.BillingFrequency;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ContractsGrantsBillingAwardVerificationServiceImpl
implements ContractsGrantsBillingAwardVerificationService {
    protected AccountingPeriodService accountingPeriodService;
    protected BusinessObjectService businessObjectService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected CustomerService customerService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected KualiModuleService kualiModuleService;
    protected ParameterService parameterService;
    protected VerifyBillingFrequencyService verifyBillingFrequencyService;
    protected UniversityDateService universityDateService;
    protected OptionsService optionsService;
    protected FinancialSystemUserService financialSystemUserService;

    @Override
    public boolean isValueOfBillingFrequencyValid(ContractsAndGrantsBillingAward award) {
        if (!StringUtils.isBlank((CharSequence)award.getBillingFrequencyCode())) {
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("frequency", award.getBillingFrequencyCode());
            criteria.put("active", true);
            int billingFrequencyCount = this.businessObjectService.countMatching(BillingFrequency.class, criteria);
            return billingFrequencyCount > 0;
        }
        return false;
    }

    @Override
    public boolean isAwardFinalInvoiceAlreadyBuilt(ContractsAndGrantsBillingAward award) {
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            if (!awardAccount.isFinalBilledIndicator()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvoiceInProgress(ContractsAndGrantsBillingAward award) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.getFinancialSystemDocumentService().getPendingDocumentStatuses());
        Collection invoiceDocuments = this.businessObjectService.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues);
        for (ContractsGrantsInvoiceDocument invoiceDocument : invoiceDocuments) {
            for (InvoiceAccountDetail accountDetail : invoiceDocument.getAccountDetails()) {
                if (!this.hasMatchingAccount(award, accountDetail)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasMatchingAccount(ContractsAndGrantsBillingAward award, InvoiceAccountDetail accountDetail) {
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            if (!StringUtils.equals((CharSequence)accountDetail.getChartOfAccountsCode(), (CharSequence)awardAccount.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)accountDetail.getAccountNumber(), (CharSequence)awardAccount.getAccountNumber())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAwardAccountValidToInvoiceBasedOnSchedule(ContractsAndGrantsBillingAwardAccount awardAccount) {
        if (ArConstants.BillingFrequencyValues.isMilestone((Billable)awardAccount.getAward())) {
            return this.hasMilestonesToInvoice(awardAccount);
        }
        if (ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)awardAccount.getAward())) {
            return this.hasBillsToInvoice(awardAccount);
        }
        return true;
    }

    @Override
    public boolean hasMilestonesToInvoice(ContractsAndGrantsBillingAward award) {
        if (ArConstants.BillingFrequencyValues.isMilestone((Billable)award)) {
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (!this.hasMilestonesToInvoice(awardAccount)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasMilestonesToInvoice(ContractsAndGrantsBillingAwardAccount awardAccount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", awardAccount.getProposalNumber());
        map.put("chartOfAccountsCode", awardAccount.getChartOfAccountsCode());
        map.put("accountNumber", awardAccount.getAccountNumber());
        map.put("active", true);
        Collection milestones = this.businessObjectService.findMatching(Milestone.class, map);
        List<Milestone> milestonesToInvoice = this.determineMilestonesToInvoice(milestones);
        return CollectionUtils.isNotEmpty(milestonesToInvoice);
    }

    @Override
    public List<Milestone> determineMilestonesToInvoice(Collection<Milestone> milestones) {
        Date today = Date.valueOf(LocalDate.now());
        return milestones.stream().filter(milestone -> this.canBeInvoiced((Milestone)((Object)milestone), today)).collect(Collectors.toList());
    }

    private boolean canBeInvoiced(Milestone milestone, Date today) {
        return milestone.getMilestoneActualCompletionDate() != null && !milestone.getMilestoneActualCompletionDate().after(today) && !milestone.isBilled() && ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount()) && milestone.getMilestoneAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO);
    }

    private boolean canBeInvoiced(Bill bill, Date today) {
        return bill.getBillDate() != null && !bill.getBillDate().after(today) && !bill.isBilled() && bill.getEstimatedAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO);
    }

    @Override
    public boolean hasBillsToInvoice(ContractsAndGrantsBillingAward award) {
        if (ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award)) {
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                if (!this.hasBillsToInvoice(awardAccount)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasBillsToInvoice(ContractsAndGrantsBillingAwardAccount awardAccount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", awardAccount.getProposalNumber());
        map.put("chartOfAccountsCode", awardAccount.getChartOfAccountsCode());
        map.put("accountNumber", awardAccount.getAccountNumber());
        map.put("active", true);
        Collection bills = this.businessObjectService.findMatching(Bill.class, map);
        List<Bill> billsToInvoice = this.determineBillsToInvoice(bills);
        return CollectionUtils.isNotEmpty(billsToInvoice);
    }

    @Override
    public List<Bill> determineBillsToInvoice(Collection<Bill> bills) {
        Date today = Date.valueOf(LocalDate.now());
        return bills.stream().filter(bill -> this.canBeInvoiced((Bill)((Object)bill), today)).collect(Collectors.toList());
    }

    @Override
    public boolean owningAgencyHasCustomerRecord(ContractsAndGrantsBillingAward award) {
        if (ObjectUtils.isNotNull((Object)award.getAgency().getCustomerNumber())) {
            Customer customer = this.customerService.getByPrimaryKey(award.getAgency().getCustomerNumber());
            return !ObjectUtils.isNull((Object)((Object)customer));
        }
        return false;
    }

    @Override
    public boolean isChartAndOrgSetupForInvoicing(ContractsAndGrantsBillingAward award) {
        if (ObjectUtils.isNull((Object)award.getAwardPrimaryFundManager()) || ObjectUtils.isNull((Object)award.getAwardPrimaryFundManager().getFundManager())) {
            return false;
        }
        ChartOrgHolder chartOrgHolder = this.financialSystemUserService.getPrimaryOrganization(award.getAwardPrimaryFundManager().getFundManager().getPrincipalId(), "KFS-AR");
        if (ObjectUtils.isNull((Object)chartOrgHolder)) {
            return false;
        }
        String coaCode = chartOrgHolder.getChartOfAccountsCode();
        String orgCode = chartOrgHolder.getOrganizationCode();
        Integer currentYear = this.universityDateService.getCurrentFiscalYear();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        HashMap<String, Object> sysCriteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentYear);
        sysCriteria.put("universityFiscalYear", currentYear);
        criteria.put("chartOfAccountsCode", coaCode);
        criteria.put("organizationCode", orgCode);
        List<String> procCodes = this.getContractsGrantsInvoiceDocumentService().getProcessingFromBillingCodes(coaCode, orgCode);
        if (!CollectionUtils.isEmpty(procCodes) && procCodes.size() > 1) {
            sysCriteria.put("processingChartOfAccountCode", procCodes.get(0));
            sysCriteria.put("processingOrganizationCode", procCodes.get(1));
            OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault)this.businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
            SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, sysCriteria);
            return ObjectUtils.isNotNull((Object)((Object)organizationAccountingDefault)) && ObjectUtils.isNotNull((Object)((Object)systemInformation));
        }
        return false;
    }

    @Override
    public boolean hasIncomeAndReceivableObjectCodes(ContractsAndGrantsBillingAward award) {
        List activeAwardAccounts = award.getActiveAwardAccounts();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : activeAwardAccounts) {
            String chartOfAccountsCode;
            Account account = awardAccount.getAccount();
            if (!ObjectUtils.isNotNull((Object)account)) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)award.getInvoicingOptionCode(), (CharSequence)"3")) {
                account = account.getContractControlAccount();
            }
            if (!ObjectUtils.isNotNull((Object)account)) continue;
            SubFundGroup subFundGroup = account.getSubFundGroup();
            ContractsGrantsInvoiceObjectCode cgbiObjectCode = this.contractsGrantsInvoiceDocumentService.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, chartOfAccountsCode = account.getChartOfAccountsCode());
            return cgbiObjectCode != null;
        }
        return true;
    }

    public AccountingPeriodService getAccountingPeriodService() {
        return this.accountingPeriodService;
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public VerifyBillingFrequencyService getVerifyBillingFrequencyService() {
        return this.verifyBillingFrequencyService;
    }

    public void setVerifyBillingFrequencyService(VerifyBillingFrequencyService verifyBillingFrequencyService) {
        this.verifyBillingFrequencyService = verifyBillingFrequencyService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }
}

