/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectCodeCurrent;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.ReceivableCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;

public class PaymentApplicationAdjustmentDocumentService {
    private static final Logger LOG = LogManager.getLogger();
    private final BusinessObjectService businessObjectService;
    private final DataDictionaryService dataDictionaryService;
    private final DocumentService documentService;
    private final FinancialSystemUserService financialSystemUserService;
    private final GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private final NoteService noteService;
    private final OffsetDefinitionService offsetDefinitionService;
    private final SystemInformationService systemInformationService;
    private final UniversityDateService universityDateService;
    private final CustomerInvoiceDocumentService customerInvoiceDocumentService;
    private final CustomerInvoiceDetailService customerInvoiceDetailService;

    public PaymentApplicationAdjustmentDocumentService(BusinessObjectService businessObjectService, DataDictionaryService dataDictionaryService, DocumentService documentService, FinancialSystemUserService financialSystemUserService, GeneralLedgerPendingEntryService generalLedgerPendingEntryService, NoteService noteService, OffsetDefinitionService offsetDefinitionService, SystemInformationService systemInformationService, UniversityDateService universityDateService, CustomerInvoiceDocumentService customerInvoiceDocumentService, CustomerInvoiceDetailService customerInvoiceDetailService) {
        Validate.isTrue((businessObjectService != null ? 1 : 0) != 0, (String)"businessObjectService must be provided", (Object[])new Object[0]);
        Validate.isTrue((documentService != null ? 1 : 0) != 0, (String)"documentService must be provided", (Object[])new Object[0]);
        Validate.isTrue((dataDictionaryService != null ? 1 : 0) != 0, (String)"dataDictionaryService must be provided", (Object[])new Object[0]);
        Validate.isTrue((financialSystemUserService != null ? 1 : 0) != 0, (String)"financialSystemUserService must be provided", (Object[])new Object[0]);
        Validate.isTrue((generalLedgerPendingEntryService != null ? 1 : 0) != 0, (String)"generalLedgerPendingEntryService must be provided", (Object[])new Object[0]);
        Validate.isTrue((noteService != null ? 1 : 0) != 0, (String)"noteService must be provided", (Object[])new Object[0]);
        Validate.isTrue((offsetDefinitionService != null ? 1 : 0) != 0, (String)"offsetDefinitionService must be provided", (Object[])new Object[0]);
        Validate.isTrue((systemInformationService != null ? 1 : 0) != 0, (String)"systemInformationService must be provided", (Object[])new Object[0]);
        Validate.isTrue((universityDateService != null ? 1 : 0) != 0, (String)"universityDateService must be provided", (Object[])new Object[0]);
        Validate.isTrue((customerInvoiceDocumentService != null ? 1 : 0) != 0, (String)"customerInvoiceDocumentService must be provided", (Object[])new Object[0]);
        Validate.isTrue((customerInvoiceDetailService != null ? 1 : 0) != 0, (String)"customerInvoiceDetailService must be provided", (Object[])new Object[0]);
        this.businessObjectService = businessObjectService;
        this.dataDictionaryService = dataDictionaryService;
        this.documentService = documentService;
        this.financialSystemUserService = financialSystemUserService;
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
        this.noteService = noteService;
        this.offsetDefinitionService = offsetDefinitionService;
        this.systemInformationService = systemInformationService;
        this.universityDateService = universityDateService;
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }

    public PaymentApplicationAdjustmentDocument createPaymentApplicationAdjustment(PaymentApplicationAdjustmentDocument adjusteeDocument) throws WorkflowException {
        PaymentApplicationAdjustmentDocument adjustmentDocument = (PaymentApplicationAdjustmentDocument)this.documentService.getNewDocument(PaymentApplicationAdjustmentDocument.class);
        DocumentHeader documentHeader = adjustmentDocument.getDocumentHeader();
        documentHeader.setDocumentDescription("Created by Application Adjustment");
        AccountsReceivableDocumentHeader arDocumentHeader = adjusteeDocument.getAccountsReceivableDocumentHeader();
        String processingChartCode = arDocumentHeader.getProcessingChartOfAccountCode();
        String processingOrgCode = arDocumentHeader.getProcessingOrganizationCode();
        String documentNumber = adjustmentDocument.getDocumentNumber();
        AccountsReceivableDocumentHeader arDocHeader = new AccountsReceivableDocumentHeader();
        arDocHeader.setProcessingChartOfAccountCode(processingChartCode);
        arDocHeader.setProcessingOrganizationCode(processingOrgCode);
        arDocHeader.setDocumentNumber(documentNumber);
        arDocHeader.setCustomerNumber(arDocumentHeader.getCustomerNumber());
        adjustmentDocument.setAccountsReceivableDocumentHeader(arDocHeader);
        adjustmentDocument.setAdjusteeDocumentNumber(adjusteeDocument.getDocumentNumber());
        List<InvoicePaidApplied> ipasWhoseInvoiceHasAnOpenAmount = adjusteeDocument.getInvoicePaidApplieds().stream().filter(ipa -> this.customerInvoiceDocumentService.getPaidAppliedTotalForInvoice(ipa.getCustomerInvoiceDocument()).isNonZero()).collect(Collectors.toList());
        adjustmentDocument.setInvoicePaidApplieds(ipasWhoseInvoiceHasAnOpenAmount);
        List<NonAppliedHolding> nahsWithAnOpenAmount = adjusteeDocument.getNonAppliedHoldings().stream().filter(nah -> nah.getFinancialDocumentLineAmount().isPositive()).collect(Collectors.toList());
        nahsWithAnOpenAmount.forEach(nah -> nah.setReferenceFinancialDocumentNumber(documentNumber));
        adjustmentDocument.setNonAppliedHoldings(nahsWithAnOpenAmount);
        this.documentService.saveDocument((Document)adjustmentDocument);
        adjusteeDocument.refreshReferenceObject("nonAppliedHoldings");
        adjusteeDocument.setAdjustmentDocumentNumber(adjustmentDocument.getDocumentNumber());
        this.documentService.updateDocument((Document)adjusteeDocument);
        return adjustmentDocument;
    }

    public void updateNonAppliedHoldings(PaymentApplicationAdjustmentDocument appaDoc, List<PaymentApplicationAdjustmentRequest.NonAppliedHolding> nonAppliedHoldings) {
        ArrayList customerNumbers = new ArrayList();
        nonAppliedHoldings.forEach(nonAppliedHolding -> {
            this.createOrUpdateNonAppliedHolding(appaDoc, (PaymentApplicationAdjustmentRequest.NonAppliedHolding)nonAppliedHolding);
            customerNumbers.add(nonAppliedHolding.getCustomerNumber());
        });
        List nonAppliedHoldingsToRemove = appaDoc.getNonAppliedHoldings().stream().filter(nonAppliedHolding -> !customerNumbers.contains(nonAppliedHolding.getCustomerNumber())).collect(Collectors.toList());
        appaDoc.getNonAppliedHoldings().removeAll(nonAppliedHoldingsToRemove);
    }

    public void updateInvoicePaidApplieds(PaymentApplicationAdjustmentDocument appaDoc, List<PaymentApplicationAdjustmentRequest.InvoiceApplication> invoiceApplications) {
        LOG.debug("updateInvoicePaidApplieds(...) - Enter : appaDoc={}; invoiceApplications={}", (Object)appaDoc, invoiceApplications);
        Integer universityFiscalYear = this.universityDateService.getCurrentFiscalYear();
        String universityFiscalPeriodCode = this.universityDateService.getCurrentUniversityDate().getAccountingPeriod().getUniversityFiscalPeriodCode();
        int nextInvoicePaidAppliedItemNumber = PaymentApplicationAdjustmentDocumentService.determineNextInvoicePaidAppliedItemNumber(appaDoc.getInvoicePaidApplieds());
        this.updateDocumentWithInvoiceApplications(appaDoc, invoiceApplications, universityFiscalYear, universityFiscalPeriodCode, nextInvoicePaidAppliedItemNumber);
        this.removeIpasFromDocumentWhichAreNotInTheRequest(appaDoc, invoiceApplications);
        LOG.debug("updateInvoicePaidApplieds(...) - Exit");
    }

    private static int determineNextInvoicePaidAppliedItemNumber(Collection<InvoicePaidApplied> ipas) {
        return ipas.stream().max(Comparator.comparing(InvoicePaidApplied::getPaidAppliedItemNumber)).map(InvoicePaidApplied::getPaidAppliedItemNumber).orElse(0) + 1;
    }

    private void updateDocumentWithInvoiceApplications(PaymentApplicationAdjustmentDocument appaDoc, List<PaymentApplicationAdjustmentRequest.InvoiceApplication> invoiceApplications, Integer universityFiscalYear, String universityFiscalPeriodCode, int nextInvoicePaidAppliedItemNumber) {
        LOG.debug("updateDocumentWithInvoiceApplications(...) - Enter");
        invoiceApplications.forEach(invoiceApplication -> {
            List<PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail> detailApplications = invoiceApplication.getDetailApplications();
            this.updateDocumentWithInvoiceApplicationDetails(appaDoc, universityFiscalYear, universityFiscalPeriodCode, nextInvoicePaidAppliedItemNumber, (PaymentApplicationAdjustmentRequest.InvoiceApplication)invoiceApplication, detailApplications);
        });
        LOG.debug("updateDocumentWithInvoiceApplications(...) - Exit");
    }

    private void updateDocumentWithInvoiceApplicationDetails(PaymentApplicationAdjustmentDocument appaDoc, Integer universityFiscalYear, String universityFiscalPeriodCode, int nextInvoicePaidAppliedItemNumber, PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication, List<PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail> detailApplications) {
        LOG.debug("updateDocumentWithInvoiceApplicationDetails(...) - Enter");
        IntStream.range(0, detailApplications.size()).forEach(index -> {
            PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail detailApplication = (PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail)detailApplications.get(index);
            int invoicePaidAppliedItemNumber = nextInvoicePaidAppliedItemNumber + index;
            this.updateExistingOrCreateNewInvoicePaidApplied(appaDoc, invoiceApplication.getDocumentNumber(), detailApplication, invoicePaidAppliedItemNumber, universityFiscalYear, universityFiscalPeriodCode);
        });
        LOG.debug("updateDocumentWithInvoiceApplicationDetails(...) - Exit");
    }

    private void updateExistingOrCreateNewInvoicePaidApplied(PaymentApplicationAdjustmentDocument appaDoc, String invoiceNumber, PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail detailApplication, Integer invoicePaidAppliedItemNumber, Integer universityFiscalYear, String universityFiscalPeriodCode) {
        LOG.debug("updateExistingOrCreateNewInvoicePaidApplied(...) - Enter : invoiceNumber={}; detailApplication={}; invoicePaidAppliedItemNumber={}; fiscalYear={}; fiscalPeriod={}", (Object)invoiceNumber, (Object)detailApplication, (Object)invoicePaidAppliedItemNumber, (Object)universityFiscalYear, (Object)universityFiscalPeriodCode);
        Integer invoiceItemNumber = detailApplication.getSequenceNumber();
        KualiDecimal amountApplied = detailApplication.getAmountApplied();
        List<InvoicePaidApplied> ipas = appaDoc.getInvoicePaidApplieds();
        Optional<InvoicePaidApplied> ipaFromDocument = this.findMatchingInvoicePaidApplied(ipas, invoiceNumber, invoiceItemNumber);
        ipaFromDocument.ifPresentOrElse(ipa -> ipa.setInvoiceItemAppliedAmount(amountApplied), () -> {
            Optional<CustomerInvoiceDetail> detailFromInvoice = this.findOnInvoiceWithTheSameAmountApplied(invoiceNumber, invoiceItemNumber, amountApplied);
            detailFromInvoice.ifPresentOrElse(d -> LOG.debug("updateExistingOrCreateNewInvoicePaidApplied(...) - detail exists on the Invoice with same amountApplied; not creating IPA : detail={}", d), () -> {
                InvoicePaidApplied newIpa = new InvoicePaidApplied(appaDoc.getDocumentNumber(), invoiceNumber, invoiceItemNumber, amountApplied, invoicePaidAppliedItemNumber, universityFiscalYear, universityFiscalPeriodCode);
                ipas.add(newIpa);
            });
        });
        LOG.debug("updateExistingOrCreateNewInvoicePaidApplied(...) - Exit : ipas={}", ipas);
    }

    private Optional<CustomerInvoiceDetail> findOnInvoiceWithTheSameAmountApplied(String invoiceNumber, Integer invoiceItemNumber, KualiDecimal amountApplied) {
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)this.businessObjectService.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)invoiceNumber);
        List<CustomerInvoiceDetail> invoiceDetails = invoice.getCustomerInvoiceDetailsWithoutDiscounts();
        return invoiceDetails.stream().filter(this.itemNumberAndAmountAppliedAreTheSame(invoiceItemNumber, amountApplied)).findFirst();
    }

    private Predicate<CustomerInvoiceDetail> itemNumberAndAmountAppliedAreTheSame(Integer invoiceItemNumber, KualiDecimal amountApplied) {
        return invoiceDetail -> invoiceItemNumber.equals(invoiceDetail.getInvoiceItemNumber()) && amountApplied.equals((Object)invoiceDetail.getAmountApplied());
    }

    private Optional<InvoicePaidApplied> findMatchingInvoicePaidApplied(Collection<InvoicePaidApplied> ipas, String invoiceNumber, Integer invoiceItemNumber) {
        return ipas.stream().filter(ipa -> ipa.getFinancialDocumentReferenceInvoiceNumber().equalsIgnoreCase(invoiceNumber)).filter(ipa -> ipa.getInvoiceItemNumber().equals(invoiceItemNumber)).findFirst();
    }

    private void removeIpasFromDocumentWhichAreNotInTheRequest(PaymentApplicationAdjustmentDocument appaDoc, List<PaymentApplicationAdjustmentRequest.InvoiceApplication> invoiceApplications) {
        List invoiceNumbersFromRequest = invoiceApplications.stream().map(PaymentApplicationAdjustmentRequest.InvoiceApplication::getDocumentNumber).collect(Collectors.toList());
        List<InvoicePaidApplied> ipas = appaDoc.getInvoicePaidApplieds();
        List ipasInDocumentButNotInRequest = ipas.stream().filter(ipa -> !invoiceNumbersFromRequest.contains(ipa.getFinancialDocumentReferenceInvoiceNumber())).collect(Collectors.toList());
        ipas.removeAll(ipasInDocumentButNotInRequest);
    }

    private NonAppliedHolding createNonAppliedHolding(PaymentApplicationAdjustmentDocument appaDoc, PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding) {
        NonAppliedHolding documentNonAppliedHolding = new NonAppliedHolding();
        documentNonAppliedHolding.setCustomerNumber(nonAppliedHolding.getCustomerNumber());
        documentNonAppliedHolding.setReferenceFinancialDocumentNumber(appaDoc.getDocumentNumber());
        documentNonAppliedHolding.setFinancialDocumentLineAmount(nonAppliedHolding.getAmount());
        return documentNonAppliedHolding;
    }

    private void createOrUpdateNonAppliedHolding(PaymentApplicationAdjustmentDocument appaDoc, PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding) {
        NonAppliedHolding matchingDocumentNonAppliedHolding = appaDoc.getNonAppliedHoldings().stream().filter(docNonAppliedHolding -> docNonAppliedHolding.getCustomerNumber().equalsIgnoreCase(nonAppliedHolding.getCustomerNumber())).findFirst().orElse(null);
        if (matchingDocumentNonAppliedHolding != null) {
            matchingDocumentNonAppliedHolding.setFinancialDocumentLineAmount(nonAppliedHolding.getAmount());
        } else {
            appaDoc.getNonAppliedHoldings().add(this.createNonAppliedHolding(appaDoc, nonAppliedHolding));
        }
    }

    public List<GeneralLedgerPendingEntry> createPendingEntries(Document adjusteeDocument, Document adjustmentDocument, Integer postingYear, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) throws WorkflowException {
        String documentTypeCode = this.dataDictionaryService.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class);
        List<GeneralLedgerPendingEntry> glpesForNonAppliedHoldings = this.createPendingEntriesForNonAppliedHoldings(adjusteeDocument, adjustmentDocument, sequenceHelper, documentTypeCode, postingYear);
        List<GeneralLedgerPendingEntry> glpesForInvoicePaidApplieds = this.createPendingEntriesForInvoicePaidApplieds(adjusteeDocument, adjustmentDocument, sequenceHelper, documentTypeCode, postingYear);
        List glpes = ListUtils.union(glpesForInvoicePaidApplieds, glpesForNonAppliedHoldings);
        LOG.debug("createPendingEntries(...) - Return : glpes={}", (Object)glpes);
        return glpes;
    }

    private List<GeneralLedgerPendingEntry> createPendingEntriesForNonAppliedHoldings(Document adjusteeDocument, Document adjustmentDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String documentTypeCode, Integer postingYear) {
        Collection<NonAppliedHolding> adjusteeNonAppliedHoldings = PaymentApplicationAdjustmentDocumentService.getNonAppliedHoldings(adjusteeDocument);
        Collection<NonAppliedHolding> adjustmentNonAppliedHoldings = PaymentApplicationAdjustmentDocumentService.getNonAppliedHoldings(adjustmentDocument);
        List newNahs = PaymentApplicationAdjustmentDocumentService.determineNewNonAppliedHoldings(adjusteeNonAppliedHoldings, adjustmentNonAppliedHoldings).stream().map(newNah -> Pair.of((Object)newNah, (Object)((KualiDecimal)newNah.getFinancialDocumentLineAmount().abs()))).collect(Collectors.toList());
        List<Pair<NonAppliedHolding, KualiDecimal>> increasedNahs = PaymentApplicationAdjustmentDocumentService.determineIncreasedNonAppliedHoldings(adjusteeNonAppliedHoldings, adjustmentNonAppliedHoldings);
        List<GeneralLedgerPendingEntry> glpesForNewOrIncreased = this.creditTheAccountsReceivableClearingAccountAndObjectCode(sequenceHelper, ListUtils.union(newNahs, increasedNahs), adjustmentDocument.getDocumentHeader(), documentTypeCode, postingYear);
        List removedNahs = PaymentApplicationAdjustmentDocumentService.determineRemovedNonAppliedHoldings(adjusteeNonAppliedHoldings, adjustmentNonAppliedHoldings).stream().map(removedNah -> Pair.of((Object)removedNah, (Object)((KualiDecimal)removedNah.getFinancialDocumentLineAmount().abs()))).collect(Collectors.toList());
        List<Pair<NonAppliedHolding, KualiDecimal>> decreasedNahs = PaymentApplicationAdjustmentDocumentService.determineDecreasedNonAppliedHoldings(adjusteeNonAppliedHoldings, adjustmentNonAppliedHoldings);
        List<GeneralLedgerPendingEntry> glpesForRemovedOrDecreased = this.debitTheAccountsReceivableClearingAccountAndObjectCode(sequenceHelper, ListUtils.union(removedNahs, decreasedNahs), adjusteeDocument, adjustmentDocument.getDocumentHeader(), documentTypeCode, postingYear);
        return ListUtils.union(glpesForNewOrIncreased, glpesForRemovedOrDecreased);
    }

    private static Collection<NonAppliedHolding> getNonAppliedHoldings(Document adjustee) {
        List<NonAppliedHolding> nonAppliedHoldings = null;
        if (adjustee instanceof PaymentApplicationDocument) {
            nonAppliedHoldings = ((PaymentApplicationDocument)adjustee).getNonAppliedHoldings();
        } else if (adjustee instanceof PaymentApplicationAdjustmentDocument) {
            nonAppliedHoldings = ((PaymentApplicationAdjustmentDocument)adjustee).getNonAppliedHoldings();
        }
        return Objects.requireNonNullElseGet(nonAppliedHoldings, List::of);
    }

    private static List<NonAppliedHolding> determineNewNonAppliedHoldings(Collection<NonAppliedHolding> adjusteeNahs, Collection<NonAppliedHolding> adjustmentNahs) {
        List adjusteeNahCustomerNumbers = adjusteeNahs.stream().map(adjusteeNah -> adjusteeNah.getCustomerNumber()).collect(Collectors.toList());
        List<NonAppliedHolding> newNahs = adjustmentNahs.stream().filter(adjustmentNah -> !adjusteeNahCustomerNumbers.contains(adjustmentNah.getCustomerNumber())).collect(Collectors.toList());
        LOG.debug("determineNewNonAppliedHoldings(...) - Exit : newNahs={}", newNahs);
        return newNahs;
    }

    private static List<NonAppliedHolding> determineRemovedNonAppliedHoldings(Collection<NonAppliedHolding> adjusteeNahs, Collection<NonAppliedHolding> adjustmentNahs) {
        List adjustmentNahCustomerNumbers = adjustmentNahs.stream().map(adjustmentNah -> adjustmentNah.getCustomerNumber()).collect(Collectors.toList());
        List<NonAppliedHolding> removedNahs = adjusteeNahs.stream().filter(adjusteeNah -> !adjustmentNahCustomerNumbers.contains(adjusteeNah.getCustomerNumber())).collect(Collectors.toList());
        LOG.debug("determineRemovedNonAppliedHoldings(...) - Exit : removedNahs={}", removedNahs);
        return removedNahs;
    }

    private static List<Pair<NonAppliedHolding, KualiDecimal>> determineIncreasedNonAppliedHoldings(Collection<NonAppliedHolding> adjusteeNahs, Collection<NonAppliedHolding> adjustmentNahs) {
        BiFunction<KualiDecimal, KualiDecimal, Boolean> increasedNahFunction = (adjustmentAmount, adjusteeAmount) -> adjustmentAmount.isGreaterThan((AbstractKualiDecimal)adjusteeAmount);
        BiFunction<KualiDecimal, KualiDecimal, KualiDecimal> differenceFunction = (adjustmentAmount, adjusteeAmount) -> (KualiDecimal)((KualiDecimal)adjustmentAmount.subtract((AbstractKualiDecimal)adjusteeAmount)).abs();
        List<Pair<NonAppliedHolding, KualiDecimal>> increasedNahs = PaymentApplicationAdjustmentDocumentService.determineNonAppliedHoldingsByFunction(adjusteeNahs, adjustmentNahs, increasedNahFunction, differenceFunction);
        LOG.debug("determineIncreasedNonAppliedHoldings(...) - Exit - increasedNahs={}", increasedNahs);
        return increasedNahs;
    }

    private static List<Pair<NonAppliedHolding, KualiDecimal>> determineDecreasedNonAppliedHoldings(Collection<NonAppliedHolding> adjusteeNahs, Collection<NonAppliedHolding> adjustmentNahs) {
        BiFunction<KualiDecimal, KualiDecimal, Boolean> decreasedNahFunction = (adjustmentAmount, adjusteeAmount) -> adjustmentAmount.isLessThan((AbstractKualiDecimal)adjusteeAmount);
        BiFunction<KualiDecimal, KualiDecimal, KualiDecimal> differenceFunction = (adjustmentAmount, adjusteeAmount) -> (KualiDecimal)((KualiDecimal)adjusteeAmount.subtract((AbstractKualiDecimal)adjustmentAmount)).abs();
        List<Pair<NonAppliedHolding, KualiDecimal>> decreasedNahs = PaymentApplicationAdjustmentDocumentService.determineNonAppliedHoldingsByFunction(adjusteeNahs, adjustmentNahs, decreasedNahFunction, differenceFunction);
        LOG.debug("determineDecreasedNonAppliedHoldings(...) - Exit - decreasedNahs={}", decreasedNahs);
        return decreasedNahs;
    }

    private static List<Pair<NonAppliedHolding, KualiDecimal>> determineNonAppliedHoldingsByFunction(Collection<NonAppliedHolding> adjusteeNahs, Collection<NonAppliedHolding> adjustmentNahs, BiFunction<KualiDecimal, KualiDecimal, Boolean> compareFunction, BiFunction<KualiDecimal, KualiDecimal, KualiDecimal> differenceFunction) {
        LinkedList<Pair<NonAppliedHolding, KualiDecimal>> nahPairs = new LinkedList<Pair<NonAppliedHolding, KualiDecimal>>();
        block0: for (NonAppliedHolding adjustmentNah : adjustmentNahs) {
            for (NonAppliedHolding adjusteeNah : adjusteeNahs) {
                KualiDecimal adjusteeAmount;
                String adjusteeCustomerNumber;
                String adjustmentCustomerNumber = adjustmentNah.getCustomerNumber();
                if (!adjustmentCustomerNumber.equalsIgnoreCase(adjusteeCustomerNumber = adjusteeNah.getCustomerNumber())) continue;
                KualiDecimal adjustmentAmount = adjustmentNah.getFinancialDocumentLineAmount();
                if (!compareFunction.apply(adjustmentAmount, adjusteeAmount = adjusteeNah.getFinancialDocumentLineAmount()).booleanValue()) continue block0;
                Pair pair = Pair.of((Object)((Object)adjustmentNah), (Object)differenceFunction.apply(adjustmentAmount, adjusteeAmount));
                nahPairs.add((Pair<NonAppliedHolding, KualiDecimal>)pair);
                continue block0;
            }
        }
        return nahPairs;
    }

    private List<GeneralLedgerPendingEntry> creditTheAccountsReceivableClearingAccountAndObjectCode(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, List<Pair<NonAppliedHolding, KualiDecimal>> nonAppliedHoldings, DocumentHeader documentHeader, String documentTypeCode, Integer postingYear) {
        if (nonAppliedHoldings.isEmpty()) {
            return List.of();
        }
        SystemInformation unappliedSystemInformation = this.retrieveSystemInformationForCurrentUser();
        unappliedSystemInformation.refreshReferenceObject("universityClearingAccount");
        Account universityClearingAccount = unappliedSystemInformation.getUniversityClearingAccount();
        OffsetDefinition offsetEntryDefinition = this.offsetDefinitionService.getByPrimaryId(postingYear, universityClearingAccount.getChartOfAccountsCode(), documentTypeCode, "AC");
        offsetEntryDefinition.refreshReferenceObject("financialObject");
        String unappliedSubAccountNumber = unappliedSystemInformation.getUniversityClearingSubAccountNumber();
        String unappliedObjectCode = unappliedSystemInformation.getUniversityClearingObjectCode();
        ObjectCode unappliedUniversityClearingObject = unappliedSystemInformation.getUniversityClearingObject();
        String unappliedObjectTypeCode = unappliedUniversityClearingObject.getFinancialObjectTypeCode();
        String unappliedSubObjectCode = unappliedSystemInformation.getUniversityClearingSubObjectCode();
        LinkedList<GeneralLedgerPendingEntry> generatedEntries = new LinkedList<GeneralLedgerPendingEntry>();
        nonAppliedHoldings.stream().filter(pair -> ObjectUtils.isNotNull((Object)pair.getLeft())).map(Pair::getRight).forEach(creditAmount -> {
            String organizationDocumentNumber = documentHeader.getOrganizationDocumentNumber();
            GeneralLedgerPendingEntry actualCredit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("C", documentTypeCode, organizationDocumentNumber);
            actualCredit.setAccountNumber(universityClearingAccount.getAccountNumber());
            actualCredit.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualCredit.setFinancialObjectCode(unappliedObjectCode);
            actualCredit.setFinancialObjectTypeCode(unappliedObjectTypeCode);
            String financialSubObjectCode = StringUtils.isBlank((CharSequence)unappliedSubObjectCode) ? this.getDashFinancialSubObjectCode() : unappliedSubObjectCode;
            actualCredit.setFinancialSubObjectCode(financialSubObjectCode);
            actualCredit.setProjectCode(this.getDashProjectCode());
            String subAccountNumber = StringUtils.isBlank((CharSequence)unappliedSubAccountNumber) ? this.getDashSubAccountNumber() : unappliedSubAccountNumber;
            actualCredit.setSubAccountNumber(subAccountNumber);
            actualCredit.setTransactionLedgerEntryAmount(creditAmount);
            actualCredit.setTransactionLedgerEntryDescription(documentHeader.getDocumentDescription());
            actualCredit.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            sequenceHelper.increment();
            actualCredit.setUniversityFiscalYear(postingYear);
            generatedEntries.add(actualCredit);
            GeneralLedgerPendingEntry offsetDebit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("D", documentTypeCode, organizationDocumentNumber);
            offsetDebit.setAccountNumber(actualCredit.getAccountNumber());
            offsetDebit.setChartOfAccountsCode(actualCredit.getChartOfAccountsCode());
            String financialObjectCode = offsetEntryDefinition.getFinancialObjectCode();
            offsetDebit.setFinancialObjectCode(financialObjectCode);
            ObjectCode financialObject = offsetEntryDefinition.getFinancialObject();
            String financialObjectTypeCode = financialObject.getFinancialObjectTypeCode();
            offsetDebit.setFinancialObjectTypeCode(financialObjectTypeCode);
            offsetDebit.setFinancialSubObjectCode(this.getDashFinancialSubObjectCode());
            offsetDebit.setProjectCode(this.getDashProjectCode());
            offsetDebit.setSubAccountNumber(this.getDashSubAccountNumber());
            offsetDebit.setTransactionLedgerEntryAmount(actualCredit.getTransactionLedgerEntryAmount());
            offsetDebit.setTransactionLedgerEntryDescription("TP Generated Offset");
            offsetDebit.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            sequenceHelper.increment();
            offsetDebit.setUniversityFiscalYear(actualCredit.getUniversityFiscalYear());
            generatedEntries.add(offsetDebit);
        });
        return generatedEntries;
    }

    private SystemInformation retrieveSystemInformationForCurrentUser() {
        Person currentUser = this.getPerson();
        String principalId = currentUser.getPrincipalId();
        ChartOrgHolder userOrg = this.financialSystemUserService.getPrimaryOrganization(principalId, "KFS-AR");
        return this.retrieveSystemInformation(userOrg);
    }

    private SystemInformation retrieveSystemInformation(ChartOrgHolder userOrg) {
        String processingChartCode = userOrg.getChartOfAccountsCode();
        String processingOrganizationCode = userOrg.getOrganizationCode();
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        return this.systemInformationService.getByProcessingChartOrgAndFiscalYear(processingChartCode, processingOrganizationCode, currentFiscalYear);
    }

    private List<GeneralLedgerPendingEntry> debitTheAccountsReceivableClearingAccountAndObjectCode(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, List<Pair<NonAppliedHolding, KualiDecimal>> nonAppliedHoldings, Document adjusteeDocument, DocumentHeader documentHeader, String documentTypeCode, Integer postingYear) {
        if (nonAppliedHoldings.isEmpty()) {
            return List.of();
        }
        SystemInformation unappliedSystemInformation = this.retrieveSystemInformationForAdjusteeInitiator(adjusteeDocument);
        unappliedSystemInformation.refreshReferenceObject("universityClearingAccount");
        Account universityClearingAccount = unappliedSystemInformation.getUniversityClearingAccount();
        OffsetDefinition offsetEntryDefinition = this.offsetDefinitionService.getByPrimaryId(postingYear, universityClearingAccount.getChartOfAccountsCode(), documentTypeCode, "AC");
        offsetEntryDefinition.refreshReferenceObject("financialObject");
        String unappliedSubAccountNumber = unappliedSystemInformation.getUniversityClearingSubAccountNumber();
        String unappliedObjectCode = unappliedSystemInformation.getUniversityClearingObjectCode();
        ObjectCode universityClearingObject = unappliedSystemInformation.getUniversityClearingObject();
        String unappliedObjectTypeCode = universityClearingObject.getFinancialObjectTypeCode();
        LinkedList<GeneralLedgerPendingEntry> generatedEntries = new LinkedList<GeneralLedgerPendingEntry>();
        nonAppliedHoldings.stream().filter(pair -> ObjectUtils.isNotNull((Object)pair.getLeft())).map(Pair::getRight).forEach(debitAmount -> {
            String organizationDocumentNumber = documentHeader.getOrganizationDocumentNumber();
            GeneralLedgerPendingEntry actualDebit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("D", documentTypeCode, organizationDocumentNumber);
            actualDebit.setAccountNumber(universityClearingAccount.getAccountNumber());
            actualDebit.setChartOfAccountsCode(universityClearingAccount.getChartOfAccountsCode());
            actualDebit.setFinancialObjectCode(unappliedObjectCode);
            actualDebit.setFinancialObjectTypeCode(unappliedObjectTypeCode);
            actualDebit.setFinancialSubObjectCode(this.getDashFinancialSubObjectCode());
            actualDebit.setProjectCode(this.getDashProjectCode());
            String subAccountNumber = StringUtils.isBlank((CharSequence)unappliedSubAccountNumber) ? this.getDashSubAccountNumber() : unappliedSubAccountNumber;
            actualDebit.setSubAccountNumber(subAccountNumber);
            actualDebit.setTransactionLedgerEntryAmount(debitAmount);
            actualDebit.setTransactionLedgerEntryDescription(documentHeader.getDocumentDescription());
            actualDebit.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            sequenceHelper.increment();
            actualDebit.setUniversityFiscalYear(postingYear);
            generatedEntries.add(actualDebit);
            GeneralLedgerPendingEntry offsetCredit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("C", documentTypeCode, organizationDocumentNumber);
            offsetCredit.setAccountNumber(actualDebit.getAccountNumber());
            offsetCredit.setChartOfAccountsCode(actualDebit.getChartOfAccountsCode());
            offsetCredit.setFinancialObjectCode(offsetEntryDefinition.getFinancialObjectCode());
            String financialObjectTypeCode = offsetEntryDefinition.getFinancialObject().getFinancialObjectTypeCode();
            offsetCredit.setFinancialObjectTypeCode(financialObjectTypeCode);
            offsetCredit.setFinancialSubObjectCode(this.getDashFinancialSubObjectCode());
            offsetCredit.setProjectCode(this.getDashProjectCode());
            offsetCredit.setSubAccountNumber(this.getDashSubAccountNumber());
            offsetCredit.setTransactionLedgerEntryAmount(actualDebit.getTransactionLedgerEntryAmount());
            offsetCredit.setTransactionLedgerEntryDescription("TP Generated Offset");
            offsetCredit.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            sequenceHelper.increment();
            offsetCredit.setUniversityFiscalYear(actualDebit.getUniversityFiscalYear());
            generatedEntries.add(offsetCredit);
        });
        return generatedEntries;
    }

    private SystemInformation retrieveSystemInformationForAdjusteeInitiator(Document adjusteeDocument) {
        DocumentHeader documentHeader = adjusteeDocument.getDocumentHeader();
        WorkflowDocument workflowDocument = documentHeader.getWorkflowDocument();
        String principalId = workflowDocument.getInitiatorPrincipalId();
        ChartOrgHolder userOrg = this.financialSystemUserService.getPrimaryOrganization(principalId, "KFS-AR");
        return this.retrieveSystemInformation(userOrg);
    }

    private List<GeneralLedgerPendingEntry> createPendingEntriesForInvoicePaidApplieds(Document adjusteeDocument, Document adjustmentDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String documentTypeCode, Integer postingYear) throws WorkflowException {
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = PaymentApplicationAdjustmentDocumentService.getInvoicePaidApplieds(adjusteeDocument);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = PaymentApplicationAdjustmentDocumentService.getInvoicePaidApplieds(adjustmentDocument);
        List newIpas = PaymentApplicationAdjustmentDocumentService.determineNewInvoicePaidApplieds(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds).stream().map(ipa -> Pair.of((Object)ipa, (Object)ipa.getInvoiceItemAppliedAmount())).collect(Collectors.toList());
        List<Pair<InvoicePaidApplied, KualiDecimal>> ipasWhoseAppliedAmountIncreased = PaymentApplicationAdjustmentDocumentService.determineIpasWhoseAppliedAmountIncreased(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        List<GeneralLedgerPendingEntry> glpesForNewAndIncreased = this.creditTheAccountAndObjectCodeFromTheInvoice(sequenceHelper, ListUtils.union(newIpas, ipasWhoseAppliedAmountIncreased), adjustmentDocument.getDocumentHeader(), documentTypeCode, postingYear);
        List removedIpas = PaymentApplicationAdjustmentDocumentService.determineRemovedInvoicePaidApplieds(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds).stream().map(ipa -> Pair.of((Object)ipa, (Object)ipa.getInvoiceItemAppliedAmount())).collect(Collectors.toList());
        List<Pair<InvoicePaidApplied, KualiDecimal>> ipasWhoseAppliedAmountDecreased = PaymentApplicationAdjustmentDocumentService.determineIpasWhoseAppliedAmountDecreased(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        List<GeneralLedgerPendingEntry> glpesForRemovedAndDecreased = this.debitTheAccountAndObjectCodeFromTheInvoice(sequenceHelper, ListUtils.union(removedIpas, ipasWhoseAppliedAmountDecreased), adjustmentDocument.getDocumentHeader(), documentTypeCode, postingYear);
        return ListUtils.union(glpesForNewAndIncreased, glpesForRemovedAndDecreased);
    }

    private static List<InvoicePaidApplied> getInvoicePaidApplieds(Document adjustee) {
        List<InvoicePaidApplied> adjusteeInvoicePainApplieds = null;
        if (adjustee instanceof PaymentApplicationDocument) {
            adjusteeInvoicePainApplieds = ((PaymentApplicationDocument)adjustee).getInvoicePaidApplieds();
        } else if (adjustee instanceof PaymentApplicationAdjustmentDocument) {
            adjusteeInvoicePainApplieds = ((PaymentApplicationAdjustmentDocument)adjustee).getInvoicePaidApplieds();
        }
        return Objects.requireNonNullElseGet(adjusteeInvoicePainApplieds, List::of);
    }

    private static List<InvoicePaidApplied> determineNewInvoicePaidApplieds(Collection<InvoicePaidApplied> adjusteeIpas, Collection<InvoicePaidApplied> adjustmentIpas) {
        List adjusteeIpaInvoiceNumbers = adjusteeIpas.stream().map(adjusteeIpa -> adjusteeIpa.getFinancialDocumentReferenceInvoiceNumber()).collect(Collectors.toList());
        List<InvoicePaidApplied> newIpas = adjustmentIpas.stream().filter(adjustmentIpa -> {
            String adjustmentIpaInvoiceNumber = adjustmentIpa.getFinancialDocumentReferenceInvoiceNumber();
            return !adjusteeIpaInvoiceNumbers.contains(adjustmentIpaInvoiceNumber);
        }).collect(Collectors.toList());
        LOG.debug("determineNewInvoicePaidApplieds(...) - Exit : newIpas={}", newIpas);
        return newIpas;
    }

    private static List<InvoicePaidApplied> determineRemovedInvoicePaidApplieds(Collection<InvoicePaidApplied> adjusteeIpas, Collection<InvoicePaidApplied> adjustmentIpas) {
        List adjustmentIpaInvoiceNumbers = adjustmentIpas.stream().map(InvoicePaidApplied::getFinancialDocumentReferenceInvoiceNumber).collect(Collectors.toList());
        List<InvoicePaidApplied> removedIpas = adjusteeIpas.stream().filter(adjusteeIpa -> {
            String adjusteeIpaInvoiceNumber = adjusteeIpa.getFinancialDocumentReferenceInvoiceNumber();
            return !adjustmentIpaInvoiceNumbers.contains(adjusteeIpaInvoiceNumber);
        }).collect(Collectors.toList());
        LOG.debug("determineRemovedInvoicePaidApplieds(...) - Exit : removedIpas={}", removedIpas);
        return removedIpas;
    }

    private static List<Pair<InvoicePaidApplied, KualiDecimal>> determineIpasWhoseAppliedAmountIncreased(Collection<InvoicePaidApplied> adjusteeIpas, Collection<InvoicePaidApplied> adjustmentIpas) {
        BiFunction<KualiDecimal, KualiDecimal, Boolean> increasedIpaFunction = (adjustmentAmount, adjusteeAmount) -> adjustmentAmount.isGreaterThan((AbstractKualiDecimal)adjusteeAmount);
        BiFunction<KualiDecimal, KualiDecimal, KualiDecimal> differenceFunction = (adjustmentAmount, adjusteeAmount) -> (KualiDecimal)((KualiDecimal)adjusteeAmount.subtract((AbstractKualiDecimal)adjustmentAmount)).abs();
        List<Pair<InvoicePaidApplied, KualiDecimal>> increasedIpas = PaymentApplicationAdjustmentDocumentService.determineInvoicePaidAppliedsByFunction(adjusteeIpas, adjustmentIpas, increasedIpaFunction, differenceFunction);
        LOG.debug("determineIpasWhoseAppliedAmountIncreased(...) - Exit : increasedIpas={}", increasedIpas);
        return increasedIpas;
    }

    private static List<Pair<InvoicePaidApplied, KualiDecimal>> determineIpasWhoseAppliedAmountDecreased(Collection<InvoicePaidApplied> adjusteeIpas, Collection<InvoicePaidApplied> adjustmentIpas) {
        BiFunction<KualiDecimal, KualiDecimal, Boolean> decreasedIpaFunction = (adjustmentAmount, adjusteeAmount) -> adjustmentAmount.isLessThan((AbstractKualiDecimal)adjusteeAmount);
        BiFunction<KualiDecimal, KualiDecimal, KualiDecimal> differenceFunction = (adjustmentAmount, adjusteeAmount) -> (KualiDecimal)((KualiDecimal)adjustmentAmount.subtract((AbstractKualiDecimal)adjusteeAmount)).abs();
        List<Pair<InvoicePaidApplied, KualiDecimal>> decreasedIpas = PaymentApplicationAdjustmentDocumentService.determineInvoicePaidAppliedsByFunction(adjusteeIpas, adjustmentIpas, decreasedIpaFunction, differenceFunction);
        LOG.debug("determineIpasWhoseAppliedAmountDecreased(...) - Exit : decreasedIpas={}", decreasedIpas);
        return decreasedIpas;
    }

    private static List<Pair<InvoicePaidApplied, KualiDecimal>> determineInvoicePaidAppliedsByFunction(Collection<InvoicePaidApplied> adjusteeIpas, Collection<InvoicePaidApplied> adjustmentIpas, BiFunction<KualiDecimal, KualiDecimal, Boolean> compareFunction, BiFunction<KualiDecimal, KualiDecimal, KualiDecimal> differenceFunction) {
        LinkedList<Pair<InvoicePaidApplied, KualiDecimal>> ipas = new LinkedList<Pair<InvoicePaidApplied, KualiDecimal>>();
        block0: for (InvoicePaidApplied adjustmentIpa : adjustmentIpas) {
            for (InvoicePaidApplied adjusteeIpa : adjusteeIpas) {
                KualiDecimal adjusteeAmount;
                if (!InvoicePaidApplied.referToSameInvoiceItem(adjustmentIpa, adjusteeIpa)) continue;
                KualiDecimal adjustmentAmount = adjustmentIpa.getInvoiceItemAppliedAmount();
                if (!compareFunction.apply(adjustmentAmount, adjusteeAmount = adjusteeIpa.getInvoiceItemAppliedAmount()).booleanValue()) continue block0;
                Pair pair = Pair.of((Object)((Object)adjustmentIpa), (Object)differenceFunction.apply(adjustmentAmount, adjusteeAmount));
                ipas.add((Pair<InvoicePaidApplied, KualiDecimal>)pair);
                continue block0;
            }
        }
        return ipas;
    }

    private List<GeneralLedgerPendingEntry> creditTheAccountAndObjectCodeFromTheInvoice(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, List<Pair<InvoicePaidApplied, KualiDecimal>> invoicePaidApplieds, DocumentHeader documentHeader, String documentTypeCode, Integer postingYear) throws WorkflowException {
        if (invoicePaidApplieds.isEmpty()) {
            return List.of();
        }
        LinkedList<GeneralLedgerPendingEntry> generatedEntries = new LinkedList<GeneralLedgerPendingEntry>();
        for (Pair<InvoicePaidApplied, KualiDecimal> pair : invoicePaidApplieds) {
            InvoicePaidApplied ipa = (InvoicePaidApplied)((Object)pair.getLeft());
            KualiDecimal creditAmount = (KualiDecimal)pair.getRight();
            ipa.refreshNonUpdateableReferences();
            CustomerInvoiceDetail invoiceDetail = ipa.getInvoiceDetail();
            Account invoiceAccount = invoiceDetail.getAccount();
            ObjectCode invoiceReceivableObjectCode = this.getInvoiceReceivableObjectCode(ipa);
            String organizationDocumentNumber = documentHeader.getOrganizationDocumentNumber();
            GeneralLedgerPendingEntry actualCredit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("C", documentTypeCode, organizationDocumentNumber);
            actualCredit.setAccountNumber(invoiceAccount.getAccountNumber());
            actualCredit.setChartOfAccountsCode(invoiceAccount.getChartOfAccountsCode());
            String projectCode = StringUtils.isBlank((CharSequence)invoiceDetail.getProjectCode()) ? this.getDashProjectCode() : invoiceDetail.getProjectCode();
            actualCredit.setProjectCode(projectCode);
            String subAccountNumber = StringUtils.isBlank((CharSequence)invoiceDetail.getSubAccountNumber()) ? this.getDashSubAccountNumber() : invoiceDetail.getSubAccountNumber();
            actualCredit.setSubAccountNumber(subAccountNumber);
            actualCredit.setTransactionLedgerEntryAmount(creditAmount);
            actualCredit.setUniversityFiscalYear(postingYear);
            actualCredit.setFinancialObjectCode(invoiceReceivableObjectCode.getFinancialObjectCode());
            actualCredit.setFinancialObjectTypeCode(invoiceReceivableObjectCode.getFinancialObjectTypeCode());
            String financialSubObjectCode = StringUtils.isBlank((CharSequence)invoiceDetail.getFinancialSubObjectCode()) ? this.getDashFinancialSubObjectCode() : invoiceDetail.getFinancialSubObjectCode();
            actualCredit.setFinancialSubObjectCode(financialSubObjectCode);
            actualCredit.setTransactionLedgerEntryDescription(documentHeader.getDocumentDescription());
            actualCredit.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            sequenceHelper.increment();
            generatedEntries.add(actualCredit);
            GeneralLedgerPendingEntry offsetDebit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("D", documentTypeCode, organizationDocumentNumber);
            offsetDebit.setAccountNumber(actualCredit.getAccountNumber());
            offsetDebit.setChartOfAccountsCode(actualCredit.getChartOfAccountsCode());
            offsetDebit.setProjectCode(actualCredit.getProjectCode());
            offsetDebit.setSubAccountNumber(actualCredit.getSubAccountNumber());
            offsetDebit.setTransactionLedgerEntryAmount(actualCredit.getTransactionLedgerEntryAmount());
            offsetDebit.setUniversityFiscalYear(actualCredit.getUniversityFiscalYear());
            this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(actualCredit.getUniversityFiscalYear(), actualCredit, sequenceHelper, offsetDebit);
            sequenceHelper.increment();
            generatedEntries.add(offsetDebit);
        }
        return generatedEntries;
    }

    private List<GeneralLedgerPendingEntry> debitTheAccountAndObjectCodeFromTheInvoice(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, List<Pair<InvoicePaidApplied, KualiDecimal>> invoicePaidApplieds, DocumentHeader documentHeader, String documentTypeCode, Integer postingYear) throws WorkflowException {
        if (invoicePaidApplieds.isEmpty()) {
            return List.of();
        }
        LinkedList<GeneralLedgerPendingEntry> generatedEntries = new LinkedList<GeneralLedgerPendingEntry>();
        for (Pair<InvoicePaidApplied, KualiDecimal> pair : invoicePaidApplieds) {
            InvoicePaidApplied ipa = (InvoicePaidApplied)((Object)pair.getLeft());
            KualiDecimal debitAmount = (KualiDecimal)pair.getRight();
            ipa.refreshNonUpdateableReferences();
            CustomerInvoiceDetail invoiceDetail = ipa.getInvoiceDetail();
            Account invoiceAccount = invoiceDetail.getAccount();
            ObjectCode invoiceReceivableObjectCode = this.getInvoiceReceivableObjectCode(ipa);
            String organizationDocumentNumber = documentHeader.getOrganizationDocumentNumber();
            GeneralLedgerPendingEntry actualDebit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("D", documentTypeCode, organizationDocumentNumber);
            actualDebit.setAccountNumber(invoiceAccount.getAccountNumber());
            actualDebit.setChartOfAccountsCode(invoiceAccount.getChartOfAccountsCode());
            actualDebit.setFinancialObjectCode(invoiceReceivableObjectCode.getFinancialObjectCode());
            actualDebit.setFinancialObjectTypeCode(invoiceReceivableObjectCode.getFinancialObjectTypeCode());
            String financialSubObjectCode = StringUtils.isBlank((CharSequence)invoiceDetail.getFinancialSubObjectCode()) ? this.getDashFinancialSubObjectCode() : invoiceDetail.getFinancialSubObjectCode();
            actualDebit.setFinancialSubObjectCode(financialSubObjectCode);
            String projectCode = StringUtils.isBlank((CharSequence)invoiceDetail.getProjectCode()) ? this.getDashProjectCode() : invoiceDetail.getProjectCode();
            actualDebit.setProjectCode(projectCode);
            String subAccountNumber = StringUtils.isBlank((CharSequence)invoiceDetail.getSubAccountNumber()) ? this.getDashSubAccountNumber() : invoiceDetail.getSubAccountNumber();
            actualDebit.setSubAccountNumber(subAccountNumber);
            actualDebit.setTransactionLedgerEntryAmount(debitAmount);
            actualDebit.setTransactionLedgerEntryDescription(documentHeader.getDocumentDescription());
            actualDebit.setTransactionLedgerEntrySequenceNumber(Integer.valueOf(sequenceHelper.getSequenceCounter()));
            sequenceHelper.increment();
            actualDebit.setUniversityFiscalYear(postingYear);
            generatedEntries.add(actualDebit);
            GeneralLedgerPendingEntry offsetCredit = PaymentApplicationAdjustmentDocumentService.createBasicGeneralLedgerPendingEntry("C", documentTypeCode, organizationDocumentNumber);
            offsetCredit.setAccountNumber(actualDebit.getAccountNumber());
            offsetCredit.setChartOfAccountsCode(actualDebit.getChartOfAccountsCode());
            offsetCredit.setSubAccountNumber(actualDebit.getSubAccountNumber());
            offsetCredit.setProjectCode(actualDebit.getProjectCode());
            offsetCredit.setTransactionLedgerEntryAmount(actualDebit.getTransactionLedgerEntryAmount());
            offsetCredit.setUniversityFiscalYear(actualDebit.getUniversityFiscalYear());
            this.generalLedgerPendingEntryService.populateOffsetGeneralLedgerPendingEntry(actualDebit.getUniversityFiscalYear(), actualDebit, sequenceHelper, offsetCredit);
            sequenceHelper.increment();
            generatedEntries.add(offsetCredit);
        }
        return generatedEntries;
    }

    private static GeneralLedgerPendingEntry createBasicGeneralLedgerPendingEntry(String transactionDebitCreditCode, String documentTypeCode, String organizationDocumentNumber) {
        GeneralLedgerPendingEntry glpe = new GeneralLedgerPendingEntry();
        glpe.setFinancialBalanceTypeCode("AC");
        glpe.setFinancialDocumentTypeCode(documentTypeCode);
        glpe.setFinancialSystemOriginationCode("01");
        glpe.setOrganizationDocumentNumber(organizationDocumentNumber);
        glpe.setTransactionDebitCreditCode(transactionDebitCreditCode);
        return glpe;
    }

    private ObjectCode getInvoiceReceivableObjectCode(InvoicePaidApplied invoicePaidApplied) throws WorkflowException {
        ObjectCode objectCode = null;
        CustomerInvoiceDocument customerInvoiceDocument = invoicePaidApplied.getCustomerInvoiceDocument();
        CustomerInvoiceDetail customerInvoiceDetail = invoicePaidApplied.getInvoiceDetail();
        ReceivableCustomerInvoiceDetail receivableInvoiceDetail = new ReceivableCustomerInvoiceDetail(customerInvoiceDetail, customerInvoiceDocument);
        if (ObjectUtils.isNotNull((Object)receivableInvoiceDetail) && ObjectUtils.isNotNull((Object)receivableInvoiceDetail.getFinancialObjectCode()) && ObjectUtils.isNull((Object)(objectCode = receivableInvoiceDetail.getObjectCode()))) {
            Map fieldKeys = Map.ofEntries(Map.entry("chartOfAccountsCode", receivableInvoiceDetail.getChartOfAccountsCode()), Map.entry("financialObjectCode", receivableInvoiceDetail.getFinancialObjectCode()));
            objectCode = (ObjectCode)this.businessObjectService.findByPrimaryKey(ObjectCodeCurrent.class, fieldKeys);
        }
        return objectCode;
    }

    String getDashFinancialSubObjectCode() {
        return KFSConstants.getDashFinancialSubObjectCode();
    }

    String getDashProjectCode() {
        return KFSConstants.getDashProjectCode();
    }

    String getDashSubAccountNumber() {
        return KFSConstants.getDashSubAccountNumber();
    }

    Person getPerson() {
        return GlobalVariables.getUserSession().getPerson();
    }

    public void postProcess(Document adjusteeDocument, Document adjustmentDocument) {
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = PaymentApplicationAdjustmentDocumentService.getInvoicePaidApplieds(adjusteeDocument);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = PaymentApplicationAdjustmentDocumentService.getInvoicePaidApplieds(adjustmentDocument);
        String documentNumber = adjustmentDocument.getDocumentNumber();
        List<InvoicePaidApplied> removedIpas = PaymentApplicationAdjustmentDocumentService.determineRemovedInvoicePaidApplieds(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        this.markInvoicePaidAppliedsAdjusted(removedIpas);
        List<Pair<InvoicePaidApplied, KualiDecimal>> ipasWhoseAppliedAmountDecreased = PaymentApplicationAdjustmentDocumentService.determineIpasWhoseAppliedAmountDecreased(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        List<InvoicePaidApplied> ipasWhoseAppliedAmountDecreasedToZero = ipasWhoseAppliedAmountDecreased.stream().map(pair -> (InvoicePaidApplied)((Object)((Object)pair.getLeft()))).filter(ipa -> ipa.getInvoiceItemAppliedAmount().isZero()).collect(Collectors.toList());
        List<InvoicePaidApplied> newIpas = PaymentApplicationAdjustmentDocumentService.determineNewInvoicePaidApplieds(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        List<InvoicePaidApplied> newIpasWhoseOpenAmountIsZero = newIpas.stream().filter(ipa -> Objects.requireNonNullElse(ipa.getInvoiceItemOpenAmount(), KualiDecimal.ZERO).isZero()).collect(Collectors.toList());
        List<Pair<InvoicePaidApplied, KualiDecimal>> ipasWhoseAppliedAmountIncreased = PaymentApplicationAdjustmentDocumentService.determineIpasWhoseAppliedAmountIncreased(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        List<InvoicePaidApplied> ipasWhoseAppliedAmountIncreasedAndOpenAmountIsNowZero = ipasWhoseAppliedAmountIncreased.stream().map(pair -> (InvoicePaidApplied)((Object)((Object)pair.getLeft()))).filter(ipa -> Objects.requireNonNullElse(ipa.getInvoiceItemOpenAmount(), KualiDecimal.ZERO).isZero()).collect(Collectors.toList());
        List<InvoicePaidApplied> adjustedInvoicePaidApplieds = this.findAdjustedInvoicePaidApplieds(adjusteeInvoicePaidApplieds, adjustmentInvoicePaidApplieds);
        this.markInvoicePaidAppliedsAdjusted(adjustedInvoicePaidApplieds);
        this.updateInvoicePaidAppliedsWithCurrentInvoiceOpenAmounts(adjustmentInvoicePaidApplieds);
        this.processInvoiceWasRemovedOrItsAppliedAmountDecreasedToZero(documentNumber, removedIpas, ipasWhoseAppliedAmountDecreasedToZero);
        this.processInvoiceAppliedAmountIncreasedAndOpenAmountIsNowZero(documentNumber, newIpasWhoseOpenAmountIsZero, ipasWhoseAppliedAmountIncreasedAndOpenAmountIsNowZero);
    }

    private List<InvoicePaidApplied> findAdjustedInvoicePaidApplieds(Collection<InvoicePaidApplied> adjusteeInvoicePaidApplieds, Collection<InvoicePaidApplied> adjustmentInvoicePaidApplieds) {
        LinkedList<InvoicePaidApplied> adjustedInvoicePaidApplieds = new LinkedList<InvoicePaidApplied>();
        for (InvoicePaidApplied adjustmentInvoicePaidApplied : adjustmentInvoicePaidApplieds) {
            for (InvoicePaidApplied adjusteeInvoicePaidApplied : adjusteeInvoicePaidApplieds) {
                if (!InvoicePaidApplied.referToSameInvoiceItem(adjustmentInvoicePaidApplied, adjusteeInvoicePaidApplied)) continue;
                adjustedInvoicePaidApplieds.add(adjusteeInvoicePaidApplied);
            }
        }
        return adjustedInvoicePaidApplieds;
    }

    private void markInvoicePaidAppliedsAdjusted(List<InvoicePaidApplied> invoicePaidApplieds) {
        invoicePaidApplieds.forEach(invoicePaidApplied -> {
            invoicePaidApplied.setAdjusted(true);
            this.businessObjectService.save((PersistableBusinessObject)invoicePaidApplied);
        });
    }

    private void updateInvoicePaidAppliedsWithCurrentInvoiceOpenAmounts(Collection<InvoicePaidApplied> invoicePaidApplieds) {
        invoicePaidApplieds.forEach(invoicePaidApplied -> {
            CustomerInvoiceDetail invoiceDetail = this.customerInvoiceDetailService.getCustomerInvoiceDetail(invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber(), invoicePaidApplied.getInvoiceItemNumber());
            if (invoiceDetail != null) {
                invoicePaidApplied.setInvoiceItemOpenAmount(invoiceDetail.getAmountOpen());
            }
            this.businessObjectService.save((PersistableBusinessObject)invoicePaidApplied);
        });
    }

    private void processInvoiceWasRemovedOrItsAppliedAmountDecreasedToZero(String documentNumber, Collection<InvoicePaidApplied> removedIpas, Collection<InvoicePaidApplied> decreasedAndAppliedAmountIsNowZero) {
        Stream.of(removedIpas, decreasedAndAppliedAmountIsNowZero).flatMap(Collection::stream).forEach(ipa -> {
            LOG.debug("processInvoiceWasRemovedOrItsAppliedAmountDecreasedToZero(...) - Processing : ipa={}", (Object)ipa);
            CustomerInvoiceDocument invoiceDocument = ipa.getCustomerInvoiceDocument();
            invoiceDocument.setOpenInvoiceIndicator(true);
            invoiceDocument.setClosedDate(null);
            String note = String.format("Reopened by %s with APPA %s", this.getPrincipalName(), documentNumber);
            Note noteObj = this.documentService.createNoteFromDocument((Document)invoiceDocument, note);
            invoiceDocument.addNote(noteObj);
            this.noteService.save(noteObj);
            this.documentService.updateDocument((Document)invoiceDocument);
        });
    }

    private void processInvoiceAppliedAmountIncreasedAndOpenAmountIsNowZero(String documentNumber, Collection<InvoicePaidApplied> newIpasWhoseOpenAmountIsZero, Collection<InvoicePaidApplied> increasedAndOpenAmountIsNowZero) {
        Stream.of(newIpasWhoseOpenAmountIsZero, increasedAndOpenAmountIsNowZero).flatMap(Collection::stream).forEach(ipa -> {
            LOG.debug("processInvoiceAppliedAmountIncreasedAndOpenAmountIsNowZero(...) - Processing : ipa={}", (Object)ipa);
            CustomerInvoiceDocument invoiceDocument = ipa.getCustomerInvoiceDocument();
            invoiceDocument.setOpenInvoiceIndicator(false);
            Date now = this.determineNow();
            invoiceDocument.setClosedDate(now);
            String note = String.format("Closed by %s with APPA %s", this.getPrincipalName(), documentNumber);
            Note noteObj = this.documentService.createNoteFromDocument((Document)invoiceDocument, note);
            invoiceDocument.addNote(noteObj);
            this.noteService.save(noteObj);
            this.documentService.updateDocument((Document)invoiceDocument);
        });
    }

    String getPrincipalName() {
        return GlobalVariables.getUserSession().getPerson().getPrincipalName();
    }

    Date determineNow() {
        DateTimeService dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        return new Date(dateTimeService.getCurrentDate().getTime());
    }

    public void fillInFiscalPeriodYear(Collection<GeneralLedgerPendingEntry> glpes) {
        LOG.debug("fillInFiscalPeriodYear(...) - Enter");
        if (glpes.isEmpty()) {
            LOG.debug("fillInFiscalPeriodYear(...) - Exit; no GLPEs were provided");
            return;
        }
        UniversityDate currentUniversityDate = this.universityDateService.getCurrentUniversityDate();
        String currentFiscalPeriod = currentUniversityDate.getUniversityFiscalAccountingPeriod();
        Integer currentFiscalYear = currentUniversityDate.getUniversityFiscalYear();
        glpes.forEach(glpe -> {
            String glpeFiscalPeriod = glpe.getUniversityFiscalPeriodCode();
            Integer glpeFiscalYear = glpe.getUniversityFiscalYear();
            if (StringUtils.isBlank((CharSequence)glpeFiscalPeriod) || glpeFiscalYear == null) {
                glpe.setUniversityFiscalPeriodCode(currentFiscalPeriod);
                glpe.setUniversityFiscalYear(currentFiscalYear);
            }
        });
        LOG.debug("fillInFiscalPeriodYear(...) - Exit");
    }
}

