/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedSaveDocumentEvent;

public class ContractsGrantsInvoiceDocumentValidation
extends GenericValidation {
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument;

    public boolean validate(AttributedDocumentEvent event) {
        if (this.contractsGrantsInvoiceDocument.isCorrectionDocument()) {
            return true;
        }
        boolean isValid = this.validateTransmissionDetails(event);
        isValid &= this.hasTemplate(event);
        return isValid &= this.hasIncomeAndReceivableObjectCodes(event);
    }

    private boolean validateTransmissionDetails(AttributedDocumentEvent event) {
        if (this.contractsGrantsInvoiceDocument.getInvoiceAddressDetails().stream().noneMatch(detail -> detail.isSendIndicator() || detail.isQueued() || detail.isSent())) {
            if (event instanceof AttributedSaveDocumentEvent) {
                GlobalVariables.getMessageMap().putWarning("document.invoiceAddressDetails[0].sendIndicator", "error.one.transmission.detail.queue.required", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("document.invoiceAddressDetails[0].sendIndicator", "error.one.transmission.detail.queue.required", new String[0]);
                GlobalVariables.getMessageMap().getWarningMessages().remove("document.invoiceAddressDetails[0].sendIndicator");
                return false;
            }
        }
        return true;
    }

    private boolean hasTemplate(AttributedDocumentEvent event) {
        InvoiceGeneralDetail invoiceGeneralDetail = this.contractsGrantsInvoiceDocument.getInvoiceGeneralDetail();
        if (StringUtils.isBlank((CharSequence)invoiceGeneralDetail.getCustomerInvoiceTemplateCode())) {
            if (event instanceof AttributedSaveDocumentEvent) {
                GlobalVariables.getMessageMap().putWarning("document.invoiceGeneralDetail.customerInvoiceTemplateCode", "error.document.contractsGrantsInvoice.template.code.required", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError("document.invoiceGeneralDetail.customerInvoiceTemplateCode", "error.document.contractsGrantsInvoice.template.code.required", new String[0]);
                GlobalVariables.getMessageMap().getWarningMessages().remove("document.invoiceGeneralDetail.customerInvoiceTemplateCode");
                return false;
            }
        }
        return true;
    }

    private boolean hasIncomeAndReceivableObjectCodes(AttributedDocumentEvent event) {
        boolean isValid = true;
        if (event instanceof AttributedRouteDocumentEvent) {
            int lineCount = this.contractsGrantsInvoiceDocument.getSourceAccountingLines().size();
            for (int idx = 0; idx < lineCount; ++idx) {
                CustomerInvoiceDetail cid = (CustomerInvoiceDetail)this.contractsGrantsInvoiceDocument.getSourceAccountingLines().get(idx);
                if (cid.getFinancialObjectCode() != null && cid.getAccountsReceivableObjectCode() != null) continue;
                isValid = false;
                GlobalVariables.getMessageMap().removeAllErrorMessagesForProperty("document.sourceAccountingLines[" + idx + "].financialObjectCode");
            }
            if (!isValid) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.contracts.grants.invoice.submission.missing.cgbi.object.code", new String[0]);
            }
        }
        return isValid;
    }

    public void setContractsGrantsInvoiceDocument(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        this.contractsGrantsInvoiceDocument = contractsGrantsInvoiceDocument;
    }
}

