/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;

public class ContractsGrantsInvoiceObjectCodeRule
extends MaintenanceDocumentRuleBase {
    protected ContractsGrantsInvoiceObjectCode cgiObjectCode;

    public void setupConvenienceObjects() {
        super.setupConvenienceObjects();
        this.cgiObjectCode = (ContractsGrantsInvoiceObjectCode)((Object)super.getNewBo());
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomRouteDocumentBusinessRules(document);
        return result &= this.checkFundFields();
    }

    protected boolean checkFundFields() {
        boolean result = true;
        int fundFieldCount = 0;
        String lastPopulatedFundField = null;
        String chartOfAccountsCode = this.cgiObjectCode.getChartOfAccountsCode();
        if (StringUtils.isNotEmpty((CharSequence)this.cgiObjectCode.getFundGroupCode())) {
            result = this.checkUnique("fundGroupCode", this.cgiObjectCode.getFundGroupCode(), chartOfAccountsCode);
            lastPopulatedFundField = "fundGroupCode";
            ++fundFieldCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cgiObjectCode.getSubFundGroupTypeCode())) {
            result &= this.checkUnique("subFundGroupTypeCode", this.cgiObjectCode.getSubFundGroupTypeCode(), chartOfAccountsCode);
            lastPopulatedFundField = "subFundGroupTypeCode";
            ++fundFieldCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.cgiObjectCode.getSubFundGroupCode())) {
            result &= this.checkUnique("subFundGroupCode", this.cgiObjectCode.getSubFundGroupCode(), chartOfAccountsCode);
            lastPopulatedFundField = "subFundGroupCode";
            ++fundFieldCount;
        }
        if (fundFieldCount == 0) {
            this.putFieldError("fundGroupCode", "error.contracts.grants.invoice.object.one.fund.field.required");
            result = false;
        } else if (fundFieldCount > 1) {
            this.putFieldError(lastPopulatedFundField, "error.contracts.grants.invoice.object.only.one.fund.field.allowed");
            result = false;
        }
        return result;
    }

    private boolean checkUnique(String propertyName, String propertyValue, String chartOfAccountsCode) {
        int existingCount;
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(propertyName, propertyValue);
        criteria.put("chartOfAccountsCode", chartOfAccountsCode);
        criteria.put("active", true);
        HashMap<String, Long> negativeCriteria = new HashMap<String, Long>();
        if (this.cgiObjectCode.getInvoiceObjectCodeIdentifier() != null) {
            negativeCriteria.put("invoiceObjectCodeIdentifier", this.cgiObjectCode.getInvoiceObjectCodeIdentifier());
        }
        if ((existingCount = this.getBoService().countMatching(ContractsGrantsInvoiceObjectCode.class, criteria, negativeCriteria)) > 0) {
            String propertyLabel = this.getDataDictionaryService().getAttributeLabel(ContractsGrantsInvoiceObjectCode.class, propertyName);
            this.putFieldError(propertyName, "error.contracts.grants.invoice.object.code.already.used", new String[]{propertyLabel, propertyValue, chartOfAccountsCode});
            return false;
        }
        return true;
    }
}

