/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class CustomerPreRules
extends PromptBeforeValidationBase {
    public boolean doPrompts(Document document) {
        return this.conditionallyAskQuestion(document);
    }

    protected boolean conditionallyAskQuestion(Document document) {
        String questionText;
        boolean confirm;
        boolean shouldAskQuestion;
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        Customer newCustomer = (Customer)maintenanceDocument.getNewMaintainableObject().getBusinessObject();
        boolean bl = shouldAskQuestion = maintenanceDocument.isNew() && this.checkIfOtherCustomerSameName(newCustomer);
        if (shouldAskQuestion && !(confirm = super.askOrAnalyzeYesNoQuestion("GenerateCustomerQuestionID", questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("message.document.customerMaintenance.customerWithSameNameExists")))) {
            super.abortRulesCheck();
        }
        return true;
    }

    public boolean checkIfOtherCustomerSameName(Customer newCustomer) {
        boolean exists = false;
        Customer customer = ((CustomerService)SpringContext.getBean(CustomerService.class)).getCustomerByName(newCustomer.getCustomerName());
        if (ObjectUtils.isNotNull((Object)((Object)customer))) {
            exists = true;
            KNSGlobalVariables.getMessageList().add("message.document.customerMaintenance.customerWithSameNameExists", new String[0]);
        }
        return exists;
    }
}

