/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report;

import java.math.BigDecimal;
import java.sql.Date;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.TicklersReport;

public class TicklersReportDetailDataHolder {
    private Date followupDate;
    private String activityCode;
    private String proposalNumber;
    private String agencyNumber;
    private String accountNumber;
    private String invoiceNumber;
    private String agencyName;
    private String activityText;
    private String activityDescription;
    private Date activityDate;
    private String user;
    private BigDecimal invoiceAmount;
    private BigDecimal paymentAmount;
    private BigDecimal balanceDue;
    private String completed;

    public TicklersReportDetailDataHolder() {
    }

    public TicklersReportDetailDataHolder(TicklersReport tr) {
        this.followupDate = tr.getFollowupDate();
        this.activityCode = tr.getActivityCode();
        this.proposalNumber = tr.getProposalNumber();
        this.agencyNumber = tr.getAgencyNumber();
        this.invoiceNumber = tr.getInvoiceNumber();
        this.accountNumber = tr.getAccountNumber();
        this.agencyName = tr.getAgencyName();
        this.activityText = ObjectUtils.isNull((Object)tr.getActivityText()) ? "" : tr.getActivityText();
        this.activityDescription = ObjectUtils.isNull((Object)tr.getActivityDescription()) ? "" : tr.getActivityDescription();
        this.activityDate = tr.getActivityDate();
        this.user = tr.getUser();
        this.invoiceAmount = ObjectUtils.isNull((Object)tr.getInvoiceAmount()) ? BigDecimal.ZERO : tr.getInvoiceAmount().bigDecimalValue();
        this.paymentAmount = ObjectUtils.isNull((Object)tr.getPaymentAmount()) ? BigDecimal.ZERO : tr.getPaymentAmount().bigDecimalValue();
        this.balanceDue = ObjectUtils.isNull((Object)tr.getBalanceDue()) ? BigDecimal.ZERO : tr.getBalanceDue().bigDecimalValue();
        this.completed = !tr.isCompleted() ? "No" : "Yes";
    }

    public Date getFollowupDate() {
        return this.followupDate;
    }

    public void setFollowupDate(Date followupDate) {
        this.followupDate = followupDate;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getActivityText() {
        return this.activityText;
    }

    public void setActivityText(String activityText) {
        this.activityText = activityText;
    }

    public String getActivityDescription() {
        return this.activityDescription;
    }

    public void setActivityDescription(String activityDescription) {
        this.activityDescription = activityDescription;
    }

    public BigDecimal getInvoiceAmount() {
        return this.invoiceAmount;
    }

    public void setInvoiceAmount(BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public BigDecimal getBalanceDue() {
        return this.balanceDue;
    }

    public void setBalanceDue(BigDecimal balanceDue) {
        this.balanceDue = balanceDue;
    }

    public String getCompleted() {
        return this.completed;
    }

    public void setCompleted(String completed) {
        this.completed = completed;
    }

    public Date getActivityDate() {
        return this.activityDate;
    }

    public void setActivityDate(Date activityDate) {
        this.activityDate = activityDate;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

