/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.responses;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.rest.presentation.Link;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentApplicationAdjustmentInvoiceResponse {
    private final String paymentApplicationAdjustmentDocumentNumber;
    private final List<InvoiceDetailResponse> detailApplications;
    private final CustomerInvoiceDocument invoice;
    private final String documentUrl;
    private final String customerUrl;

    public PaymentApplicationAdjustmentInvoiceResponse(String paymentApplicationAdjustmentDocumentNumber, CustomerInvoiceDocument invoice, List<InvoicePaidApplied> invoicePaidApplieds, String documentUrl, String customerUrl) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)paymentApplicationAdjustmentDocumentNumber), (String)"Document number must be provided", (Object[])new Object[0]);
        Validate.isTrue((invoice != null ? 1 : 0) != 0, (String)"Invoice cannot be null", (Object[])new Object[0]);
        Validate.isTrue((invoicePaidApplieds != null ? 1 : 0) != 0, (String)"Invoice Paid Applieds cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentUrl), (String)"Document url is required", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerUrl), (String)"Customer url is required", (Object[])new Object[0]);
        this.paymentApplicationAdjustmentDocumentNumber = paymentApplicationAdjustmentDocumentNumber;
        this.invoice = invoice;
        this.detailApplications = this.generateDetailResponses(invoice, invoicePaidApplieds);
        this.customerUrl = customerUrl;
        this.documentUrl = documentUrl;
    }

    public List<InvoiceDetailResponse> getDetailApplications() {
        return this.detailApplications;
    }

    public String getDocumentNumber() {
        return this.invoice.getDocumentNumber();
    }

    public String getCustomerNumber() {
        return this.invoice.getCustomer().getCustomerNumber();
    }

    public Date getInvoiceBillingDate() {
        return this.invoice.getBillingDate();
    }

    public String getHeaderText() {
        return this.invoice.getInvoiceHeaderText();
    }

    public String getCustomerName() {
        return this.invoice.getCustomer().getCustomerName();
    }

    public KualiDecimal getTotalAmount() {
        return this.invoice.getTotalDollarAmount();
    }

    public KualiDecimal getOpenAmount() {
        return (KualiDecimal)this.getTotalAmount().subtract((AbstractKualiDecimal)this.getAmountToApply());
    }

    public KualiDecimal getAmountToApply() {
        return this.detailApplications.stream().map(InvoiceDetailResponse::getAmountApplied).reduce(KualiDecimal.ZERO, (total, nextAmount) -> (KualiDecimal)total.add((AbstractKualiDecimal)nextAmount));
    }

    public Link getCustomerLink() {
        return new Link(this.getCustomerNumber(), this.customerUrl);
    }

    public Link getDocumentLink() {
        return new Link(this.getDocumentNumber(), this.documentUrl);
    }

    private List<InvoiceDetailResponse> generateDetailResponses(CustomerInvoiceDocument invoice, List<InvoicePaidApplied> invoicePaidApplieds) {
        return invoice.getCustomerInvoiceDetailsWithoutDiscounts().stream().map(detail -> {
            Optional<InvoicePaidApplied> matchingInvoicePaidApplied = this.findInvoicePaidAppliedForDetail(invoicePaidApplieds, (CustomerInvoiceDetail)detail);
            return new InvoiceDetailResponse(this.paymentApplicationAdjustmentDocumentNumber, (CustomerInvoiceDetail)detail, matchingInvoicePaidApplied);
        }).collect(Collectors.toList());
    }

    private Optional<InvoicePaidApplied> findInvoicePaidAppliedForDetail(List<InvoicePaidApplied> invoicePaidApplieds, CustomerInvoiceDetail detail) {
        return invoicePaidApplieds.stream().filter(invoicePaidApplied -> invoicePaidApplied.getInvoiceItemNumber().equals(detail.getInvoiceItemNumber())).findFirst();
    }

    private class InvoiceDetailResponse {
        private final String paymentApplicationAdjustmentDocumentNumber;
        private final CustomerInvoiceDetail invoiceDetail;
        private final Optional<InvoicePaidApplied> invoicePaidApplied;

        InvoiceDetailResponse(String paymentApplicationAdjustmentDocumentNumber, CustomerInvoiceDetail invoiceDetail, Optional<InvoicePaidApplied> invoicePaidApplied) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)paymentApplicationAdjustmentDocumentNumber), (String)"Document number must be provided", (Object[])new Object[0]);
            Validate.isTrue((invoiceDetail != null ? 1 : 0) != 0, (String)"Invoice detail cannot be null", (Object[])new Object[0]);
            this.paymentApplicationAdjustmentDocumentNumber = paymentApplicationAdjustmentDocumentNumber;
            this.invoiceDetail = invoiceDetail;
            this.invoicePaidApplied = invoicePaidApplied;
        }

        public String getChartOfAccountsCode() {
            return this.invoiceDetail.getChartOfAccountsCode();
        }

        public String getAccountNumber() {
            return this.invoiceDetail.getAccountNumber();
        }

        public Integer getSequenceNumber() {
            return this.invoiceDetail.getInvoiceItemNumber();
        }

        public String getInvoiceItemDescription() {
            return this.invoiceDetail.getInvoiceItemDescription();
        }

        public KualiDecimal getAmount() {
            return this.invoiceDetail.getAmount();
        }

        public KualiDecimal getAmountApplied() {
            if (this.invoicePaidApplied.isPresent()) {
                return this.invoicePaidApplied.get().getInvoiceItemAppliedAmount();
            }
            return KualiDecimal.ZERO;
        }

        public KualiDecimal getAmountOpen() {
            if (this.invoicePaidApplied.isPresent() && this.invoicePaidApplied.get().getInvoiceItemOpenAmount() != null) {
                return this.invoicePaidApplied.get().getInvoiceItemOpenAmount();
            }
            return (KualiDecimal)this.getAmount().subtract((AbstractKualiDecimal)this.getAmountApplied());
        }
    }
}

