/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;

import java.sql.Date;
import java.sql.Timestamp;

/**
 * Collection Event class.
 */
public class CollectionEvent extends PersistableBusinessObjectBase {

    private Long id;
    private String collectionEventCode;
    private String invoiceNumber;
    private String activityCode;
    private Date activityDate;
    private String activityText;
    private Date followupDate;
    private Date completedDate;
    private Timestamp postedDate;
    private String userPrincipalId;

    private transient Person user;
    private ContractsGrantsInvoiceDocument invoiceDocument;
    private CollectionActivityType collectionActivityType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCollectionEventCode() {
        return collectionEventCode;
    }

    public void setCollectionEventCode(String collectionEventCode) {
        this.collectionEventCode = collectionEventCode;
    }

    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public Date getActivityDate() {
        return activityDate;
    }

    public void setActivityDate(Date activityDate) {
        this.activityDate = activityDate;
    }

    public String getActivityText() {
        return activityText;
    }

    public void setActivityText(String activityText) {
        this.activityText = activityText;
    }

    public Date getFollowupDate() {
        return followupDate;
    }

    public void setFollowupDate(Date followupDate) {
        this.followupDate = followupDate;
    }

    public Date getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public java.util.Date getPostedDate() {
        return postedDate;
    }

    public void setPostedDate(Timestamp postedDate) {
        this.postedDate = postedDate;
    }

    public String getUserPrincipalId() {
        return userPrincipalId;
    }

    public void setUserPrincipalId(String userPrincipalId) {
        this.userPrincipalId = userPrincipalId;
    }

    public Person getUser() {
        if (ObjectUtils.isNotNull(userPrincipalId)) {
            this.user = SpringContext.getBean(PersonService.class).updatePersonIfNecessary(userPrincipalId, user);
        }
        return user;
    }

    public void setUser(Person user) {
        this.user = user;
    }

    public ContractsGrantsInvoiceDocument getInvoiceDocument() {
        if (ObjectUtils.isNull(invoiceDocument)) {
            DocumentService documentService = SpringContext.getBean(DocumentService.class);
            try {
                invoiceDocument = (ContractsGrantsInvoiceDocument) documentService.getByDocumentHeaderId(this.invoiceNumber);
            } catch (WorkflowException e) {
                throw new RuntimeException("A WorkflowException was thrown when trying to open the details parent document.", e);
            }
        }
        return invoiceDocument;
    }

    public void setInvoiceDocument(ContractsGrantsInvoiceDocument invoiceDocument) {
        this.invoiceDocument = invoiceDocument;
    }

    public CollectionActivityType getCollectionActivityType() {
        return collectionActivityType;
    }

    public void setCollectionActivityType(CollectionActivityType collectionActivityType) {
        this.collectionActivityType = collectionActivityType;
    }

    public boolean isCompleted() {
        boolean retVal = false;
        if (ObjectUtils.isNotNull(getCompletedDate())) {
            retVal = SpringContext.getBean(DateTimeService.class).getCurrentSqlDate().after(getCompletedDate());
        }
        return retVal;
    }

}
