/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.context.SpringContext;

import java.sql.Date;
import java.time.LocalDate;

public class InvoiceAddressDetail extends PersistableBusinessObjectBase {

    private String documentNumber;
    private String customerNumber;
    private Integer customerAddressIdentifier;
    private int detailNumber;
    private String customerAddressTypeCode;
    private String customerAddressName;
    private String customerInvoiceTemplateCode;
    private String invoiceTransmissionMethodCode;
    private String customerEmailAddress;
    private long noteId;
    private Date initialTransmissionDate;
    private String customerLine1StreetAddress;
    private String customerLine2StreetAddress;
    private String customerCityName;
    private String customerStateCode;
    private String customerZipCode;
    private String customerCountryCode;
    private String customerAddressInternationalProvinceName;
    private String customerInternationalMailCode;
    private boolean sendIndicator;
    private int transmissionCount;
    private String transmissionStatusCode;
    private Date transmissionDate;
    private String transmittedByPrincipalId;
    private Person transmittedBy;

    private CustomerAddress customerAddress;

    public String getInvoiceTransmissionMethodCode() {
        return invoiceTransmissionMethodCode;
    }

    public long getNoteId() {
        return noteId;
    }

    public void setNoteId(long noteId) {
        this.noteId = noteId;
    }

    public void setInvoiceTransmissionMethodCode(String invoiceTransmissionMethodCode) {
        this.invoiceTransmissionMethodCode = invoiceTransmissionMethodCode;
    }

    public String getDocumentNumber() {
        return documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public CustomerAddress getCustomerAddress() {
        return customerAddress;
    }

    public void setCustomerAddress(CustomerAddress customerAddress) {
        this.customerAddress = customerAddress;
    }

    public Integer getCustomerAddressIdentifier() {
        return customerAddressIdentifier;
    }

    public void setCustomerAddressIdentifier(Integer customerAddressIdentifier) {
        this.customerAddressIdentifier = customerAddressIdentifier;
    }

    public int getDetailNumber() {
        return detailNumber;
    }

    public void setDetailNumber(int detailNumber) {
        this.detailNumber = detailNumber;
    }

    public String getCustomerAddressTypeCode() {
        return customerAddressTypeCode;
    }

    public void setCustomerAddressTypeCode(String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    public String getCustomerAddressName() {
        return customerAddressName;
    }

    public void setCustomerAddressName(String customerAddressName) {
        this.customerAddressName = customerAddressName;
    }

    public String getCustomerInvoiceTemplateCode() {

        return customerInvoiceTemplateCode;
    }

    public String getCustomerEmailAddress() {
        return customerEmailAddress;
    }

    public void setCustomerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    public void setCustomerInvoiceTemplateCode(String customerInvoiceTemplateCode) {
        this.customerInvoiceTemplateCode = customerInvoiceTemplateCode;
    }

    public Date getInitialTransmissionDate() {
        return initialTransmissionDate;
    }

    public void setInitialTransmissionDate(Date initialTransmissionDate) {
        this.initialTransmissionDate = initialTransmissionDate;
    }

    public String getCustomerLine1StreetAddress() {
        return customerLine1StreetAddress;
    }

    public void setCustomerLine1StreetAddress(String customerLine1StreetAddress) {
        this.customerLine1StreetAddress = customerLine1StreetAddress;
    }

    public String getCustomerLine2StreetAddress() {
        return customerLine2StreetAddress;
    }

    public void setCustomerLine2StreetAddress(String customerLine2StreetAddress) {
        this.customerLine2StreetAddress = customerLine2StreetAddress;
    }

    public String getCustomerCityName() {
        return customerCityName;
    }

    public void setCustomerCityName(String customerCityName) {
        this.customerCityName = customerCityName;
    }

    public String getCustomerStateCode() {
        return customerStateCode;
    }

    public void setCustomerStateCode(String customerStateCode) {
        this.customerStateCode = customerStateCode;
    }

    public String getCustomerZipCode() {
        return customerZipCode;
    }

    public void setCustomerZipCode(String customerZipCode) {
        this.customerZipCode = customerZipCode;
    }

    public String getCustomerCountryCode() {
        return customerCountryCode;
    }

    public void setCustomerCountryCode(String customerCountryCode) {
        this.customerCountryCode = customerCountryCode;
    }

    public String getCustomerAddressInternationalProvinceName() {
        return customerAddressInternationalProvinceName;
    }

    public void setCustomerAddressInternationalProvinceName(String customerAddressInternationalProvinceName) {
        this.customerAddressInternationalProvinceName = customerAddressInternationalProvinceName;
    }

    public String getCustomerInternationalMailCode() {
        return customerInternationalMailCode;
    }

    public void setCustomerInternationalMailCode(String customerInternationalMailCode) {
        this.customerInternationalMailCode = customerInternationalMailCode;
    }

    public boolean isSendIndicator() {
        return sendIndicator;
    }

    public void setSendIndicator(boolean sendIndicator) {
        this.sendIndicator = sendIndicator;
    }

    public boolean isQueued() {
        return TransmissionDetailStatus.Queued.getCode().equals(transmissionStatusCode);
    }

    public boolean isSent() {
        return TransmissionDetailStatus.Sent.getCode().equals(transmissionStatusCode);
    }

    public String getTransmissionStatusCode() {
        return transmissionStatusCode;
    }

    public void setTransmissionStatusCode(String transmissionStatusCode) {
        this.transmissionStatusCode = transmissionStatusCode;
    }

    public Date getTransmissionDate() {
        return transmissionDate;
    }

    public void setTransmissionDate(Date transmissionDate) {
        this.transmissionDate = transmissionDate;
    }

    public String getTransmittedByPrincipalId() {
        return transmittedByPrincipalId;
    }

    public void setTransmittedByPrincipalId(String transmittedByPrincipalId) {
        this.transmittedByPrincipalId = transmittedByPrincipalId;
    }

    public int getTransmissionCount() {
        return transmissionCount;
    }

    public void setTransmissionCount(int transmissionCount) {
        this.transmissionCount = transmissionCount;
    }

    public void markSent() {
        if (initialTransmissionDate == null) {
            setInitialTransmissionDate(Date.valueOf(LocalDate.now()));
        }
        setTransmittedByPrincipalId(getUserSession().getPerson().getPrincipalId());
        setTransmissionDate(Date.valueOf(LocalDate.now()));
        setTransmissionStatusCode(TransmissionDetailStatus.Sent.getCode());
        transmissionCount++;
    }

    public Person getTransmittedBy() {
        transmittedBy = SpringContext.getBean(PersonService.class).updatePersonIfNecessary(transmittedByPrincipalId,
                transmittedBy);
        return transmittedBy;
    }

    public void setTransmittedBy(Person transmittedBy) {
        this.transmittedBy = transmittedBy;
    }

    /*
     * Wrapping static utility class in a method so tests can use a spy to mock this call; this way,
     * static mocking is not necessary.
     */
    UserSession getUserSession() {
        return GlobalVariables.getUserSession();
    }

}
