/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.sys.businessobject.admin.DefaultBoAdminService;
import org.kuali.kfs.sys.identity.KfsKimAttributes;

import java.util.Map;

public class OrganizationAccountingDefaultAdminService extends DefaultBoAdminService {

    @Override
    protected final Map<String, String> buildRoleQualifications(Object businessObject, String principalId) {
        Map<String, String> roleQualifications = super.buildRoleQualifications(businessObject, principalId);
        roleQualifications.putAll(KRADUtils.getNamespaceAndComponentSimpleName(businessObject.getClass()));
        OrganizationAccountingDefault organizationAccountingDefault = (OrganizationAccountingDefault) businessObject;
        roleQualifications.put(KfsKimAttributes.CHART_OF_ACCOUNTS_CODE, organizationAccountingDefault.getChartOfAccountsCode());
        roleQualifications.put(KfsKimAttributes.ORGANIZATION_CODE, organizationAccountingDefault.getOrganizationCode());
        return roleQualifications;
    }
}
