/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.options;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.valuefinder.DefaultValueFinder;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.core.api.util.ConcreteKeyValue;
import org.kuali.kfs.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

public class StatementFormatOptionFinder extends KeyValuesBase implements DefaultValueFinder {

    @Override
    public String getDefaultValue() {
        return ArConstants.STATEMENT_FORMAT_SUMMARY;
    }

    @Override
    public List<KeyValue> getKeyValues() {
        List<KeyValue> labels = new ArrayList<>();
        labels.add(new ConcreteKeyValue(ArConstants.STATEMENT_FORMAT_SUMMARY, ArConstants.STATEMENT_FORMAT_SUMMARY));
        labels.add(new ConcreteKeyValue(ArConstants.STATEMENT_FORMAT_DETAIL, ArConstants.STATEMENT_FORMAT_DETAIL));
        return labels;
    }
}
