/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.dataaccess;

import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;

import java.util.Collection;
import java.util.Map;

/**
 * Implementations of this interface provide access to persisted ContractsGrantsInvoiceDocument.
 */
public interface ContractsGrantsInvoiceDocumentDao {

    /**
     * Retrieve CG Invoices which are open, with param customer number.
     *
     * @return CG Invoices.
     */
    Collection<ContractsGrantsInvoiceDocument> getOpenInvoicesByCustomerNumber(String customerNumber);

    /**
     * This method retrieves all Invoice Documents (distinct list) that match the given field values.
     *
     * @param fieldValues for search criteria.
     * @return Returns the invoices which matches the given field values.
     */
    Collection<ContractsGrantsInvoiceDocument> getMatchingInvoicesByCollection(Map fieldValues);

    /**
     * This method retrieves all contracts & grants invoices associated with the given proposal number which meet the
     * following criteria
     * <ul>
     * <li>Must not error correct another CINV</li>
     * <li>Must not be error corrected by another CINV</li>
     * <li>Must be final or processed</li>
     * </ul>
     *
     * @param proposalNumber
     * @return Returns the invoices which matches the given field values.
     */
    Collection<ContractsGrantsInvoiceDocument> getCollectionEligibleContractsGrantsInvoicesByProposalNumber(String proposalNumber);
}
