/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.report.util;

import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CustomerStatementResultHolder {

    private String customerNumber;
    private File file;
    private KualiDecimal currentBilledAmount;
    private List<String> invoiceNumbers;

    public CustomerStatementResultHolder() {
        customerNumber = null;
        file = null;
        currentBilledAmount = KualiDecimal.ZERO;
        invoiceNumbers = new ArrayList<>();
    }

    public KualiDecimal getCurrentBilledAmount() {
        return currentBilledAmount;
    }

    public void setCurrentBilledAmount(KualiDecimal currentBilledAmount) {
        this.currentBilledAmount = currentBilledAmount;
    }

    public List<String> getInvoiceNumbers() {
        return invoiceNumbers;
    }

    public void setInvoiceNumbers(List<String> invoiceNumbers) {
        this.invoiceNumbers = invoiceNumbers;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

}
