/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.impl.ContractsGrantsInvoiceBatchCreateDocumentServiceImpl;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateIntegTestBase;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.mockito.Mockito;

@ConfigureContext(session=UserNameFixture.kfs)
public class ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest
extends ContractsGrantsInvoiceCreateIntegTestBase {
    private ContractsGrantsInvoiceBatchCreateDocumentServiceImpl contractsGrantsInvoiceBatchCreateDocumentService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.contractsGrantsInvoiceBatchCreateDocumentService = new ContractsGrantsInvoiceBatchCreateDocumentServiceImpl();
        this.contractsGrantsInvoiceBatchCreateDocumentService.setConfigurationService(this.configurationService);
        this.contractsGrantsInvoiceBatchCreateDocumentService.setContractsGrantsInvoiceCreateDocumentService((ContractsGrantsInvoiceCreateDocumentService)this.contractsGrantsInvoiceCreateDocumentService);
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsOneValid() {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwardMocks();
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertFalse((String)"errors should not be written", (boolean)errors.exists());
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"no errors should be persisted", (int)0, (int)persistedErrors.size());
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsEmptyAwardsList() throws IOException {
        ArrayList awards = new ArrayList();
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsNullAwardsList() throws IOException {
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(null, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.award");
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardsNoOrg() throws IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getPrimaryAwardOrganization()).thenReturn(null);
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.no.organization.on.award");
        errorMessage = MessageFormat.format(errorMessage, award.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAccountNonBillable() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"2");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccountNumber(), award.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByScheduleNonBillable() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"4");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccountNumber(), award.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAccountOneBillableOneNonBillable() throws Exception {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getInvoicingOptionCode()).thenReturn((Object)"2");
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        Mockito.when((Object)awardAccountMock.getCurrentLastBilledDate()).thenReturn((Object)new Date(System.currentTimeMillis()));
        Mockito.when((Object)awardAccountMock.getAward()).thenReturn((Object)award);
        List awardAccountMocks = award.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)award.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, awardAccountMock.getAccountNumber(), award.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testBatchCreateCGInvoiceDocumentsByAccountOneBillable() {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getInvoicingOptionCode()).thenReturn((Object)"4");
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_5.createAwardAccountMock();
        Mockito.when((Object)awardAccountMock.getCurrentLastBilledDate()).thenReturn((Object)new Date(System.currentTimeMillis()));
        SubFundGroup subFundGroupMock = (SubFundGroup)Mockito.mock(SubFundGroup.class);
        Mockito.when((Object)subFundGroupMock.getSubFundGroupCode()).thenReturn((Object)"AUXAMB");
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroupMock);
        String chartOfAccountsCode = awardAccountMock.getChartOfAccountsCode();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        String accountNumber = awardAccountMock.getAccountNumber();
        Mockito.when((Object)accountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)awardAccountMock.getAward()).thenReturn((Object)award);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)award.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertFalse((String)"errors should not be written", (boolean)errors.exists());
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"no errors should be persisted", (int)0, (int)persistedErrors.size());
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testBatchCreateCGInvoiceDocumentsByAccountOneBillableOneWithoutSchedule() throws IOException {
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.buildMockUniversityDateService());
        List<ContractsAndGrantsBillingAward> awards = this.setupBillableAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getProposalNumber()).thenReturn((Object)"80078");
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getInvoicingOptionCode()).thenReturn((Object)"4");
        ContractsAndGrantsBillingAwardAccount awardAccountMock1 = ARAwardAccountMockFixture.AWD_ACCT_6.createAwardAccountMock();
        Mockito.when((Object)awardAccountMock1.getCurrentLastBilledDate()).thenReturn((Object)new Date(System.currentTimeMillis()));
        SubFundGroup subFundGroupMock = (SubFundGroup)Mockito.mock(SubFundGroup.class);
        Mockito.when((Object)subFundGroupMock.getSubFundGroupCode()).thenReturn((Object)"AUXAMB");
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroupMock);
        String chartOfAccountsCode = awardAccountMock1.getChartOfAccountsCode();
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        String accountNumber = awardAccountMock1.getAccountNumber();
        Mockito.when((Object)accountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)awardAccountMock1.getAccount()).thenReturn((Object)accountMock);
        Mockito.when((Object)awardAccountMock1.getAward()).thenReturn((Object)award);
        ContractsAndGrantsBillingAwardAccount awardAccountMock2 = ARAwardAccountMockFixture.AWD_ACCT_5.createAwardAccountMock();
        Mockito.when((Object)awardAccountMock2.getCurrentLastBilledDate()).thenReturn((Object)new Date(System.currentTimeMillis()));
        Account account2Mock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account2Mock.getSubFundGroup()).thenReturn((Object)subFundGroupMock);
        chartOfAccountsCode = awardAccountMock2.getChartOfAccountsCode();
        Mockito.when((Object)account2Mock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        accountNumber = awardAccountMock2.getAccountNumber();
        Mockito.when((Object)accountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)awardAccountMock2.getAccount()).thenReturn((Object)account2Mock);
        Mockito.when((Object)awardAccountMock2.getAward()).thenReturn((Object)award);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock1);
        awardAccountMocks.add(awardAccountMock2);
        Mockito.when((Object)award.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.non.billable");
        errorMessage = MessageFormat.format(errorMessage, awardAccountMock1.getAccountNumber(), award.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
        this.contractsGrantsInvoiceCreateDocumentService.setUniversityDateService(this.originalUniversityDateService);
    }

    public void testBatchCreateCGInvoiceDocumentsByCCAContractAccountNotBillable() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"3");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.control.account.non.billable");
        errorMessage = MessageFormat.format(errorMessage, ((ContractsAndGrantsBillingAwardAccount)award2.getActiveAwardAccounts().get(0)).getAccount().getContractControlAccount().getAccountNumber(), award.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }

    public void testBatchCreateCGInvoiceDocumentsByAwardNotAllBillableAccounts() throws WorkflowException, IOException {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        ArrayList errorMessages = new ArrayList();
        ContractsGrantsInvoiceDocument cgInvoice = this.contractsGrantsInvoiceCreateDocumentService.createCGInvoiceDocumentByAwardInfo(award, award.getActiveAwardAccounts(), "BL", "PSY", errorMessages, null, null);
        this.documentService.saveDocument((Document)cgInvoice);
        this.setupBills(cgInvoice);
        this.documentService.saveDocument((Document)cgInvoice);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks();
        ContractsAndGrantsBillingAward award2 = awards2.get(0);
        Mockito.when((Object)award2.getInvoicingOptionCode()).thenReturn((Object)"1");
        this.contractsGrantsInvoiceBatchCreateDocumentService.createCGInvoiceDocumentsByAwards(awards2, this.errorOutputFile);
        String errorMessage = this.configurationService.getPropertyValueAsString("error.invoice.create.document.not.all.billable.accounts");
        errorMessage = MessageFormat.format(errorMessage, award2.getProposalNumber());
        File errors = new File(this.errorOutputFile);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errors should be written", (boolean)errors.exists());
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"errorOutputFile should not be empty", (errors.length() > 0L ? 1 : 0) != 0);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertTrue((String)"error file should contain expected error", (boolean)FileUtils.readFileToString((File)errors, (Charset)Charset.defaultCharset()).contains(errorMessage));
        Collection persistedErrors = this.businessObjectService.findAll(ContractsGrantsInvoiceDocumentErrorLog.class);
        ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"one error should be persisted", (int)1, (int)persistedErrors.size());
        for (ContractsGrantsInvoiceDocumentErrorLog persistedError : persistedErrors) {
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"process type should be batch", (String)persistedError.getCreationProcessTypeCode(), (String)ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
            ContractsGrantsInvoiceBatchCreateDocumentServiceIntegTest.assertEquals((String)"error message text should match", (String)((ContractsGrantsInvoiceDocumentErrorMessage)persistedError.getErrorMessages().get(0)).getErrorMessageText(), (String)errorMessage);
        }
    }
}

