/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.LetterOfCreditBillingPeriod;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LetterOfCreditBillingPeriodTest {
    @Mock
    private AccountingPeriodService accountingPeriodSvcMock;

    LetterOfCreditBillingPeriodTest() {
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_nullLastBilled_1() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-07-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-19");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_nullLastBilled_2() {
        Date awardStartDate = Date.valueOf("2014-08-01");
        Date currentDate = Date.valueOf("2015-04-20");
        Date expectedBillingPeriodStart = Date.valueOf("2014-08-01");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-19");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, null, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_BillSingleDay() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-19");
        Date expectedBillingPeriodStart = Date.valueOf("2015-04-19");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_BillSeveralMonths() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-11-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-11-15");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_BillAcrossFiscalYears() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2014-06-15");
        Date expectedBillingPeriodStart = Date.valueOf("2014-06-15");
        Date expectedBillingPeriodEnd = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assertions.assertEquals((Object)expectedBillingPeriodStart, (Object)priorBillingPeriod.getStartDate());
        Assertions.assertEquals((Object)expectedBillingPeriodEnd, (Object)priorBillingPeriod.getEndDate());
        Assertions.assertTrue((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void determineBillingPeriodPriorTo_LOC_MayNotBillNow() {
        Date awardStartDate = Date.valueOf("2014-07-01");
        Date currentDate = Date.valueOf("2015-04-21");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        BillingPeriod priorBillingPeriod = BillingPeriod.determineBillingPeriodPriorTo((Date)awardStartDate, (Date)currentDate, (Date)lastBilledDate, (ArConstants.BillingFrequencyValues)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, (AccountingPeriodService)this.accountingPeriodSvcMock);
        Assertions.assertNull((Object)priorBillingPeriod.getStartDate());
        Assertions.assertNull((Object)priorBillingPeriod.getEndDate());
        Assertions.assertFalse((boolean)priorBillingPeriod.isBillable());
    }

    @Test
    void canThisBeBilledLastBilledDateIsNull() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, null, this.accountingPeriodSvcMock);
        Assertions.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    void canThisBeBilledLastBilledDateIsToday() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf("2015-04-21");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, this.accountingPeriodSvcMock);
        Assertions.assertFalse((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    void canThisBeBilledLastBilledDateIsYesterday() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf("2015-04-20");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, this.accountingPeriodSvcMock);
        Assertions.assertFalse((boolean)billingPeriod.canThisBeBilled());
    }

    @Test
    void canThisBeBilledLastBilledDateIsBeforeYesterday() {
        Date awardStartDate = Date.valueOf("2015-01-01");
        Date lastBilledDate = Date.valueOf("2015-04-19");
        Date currentDate = Date.valueOf("2015-04-21");
        LetterOfCreditBillingPeriod billingPeriod = new LetterOfCreditBillingPeriod(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT, awardStartDate, currentDate, lastBilledDate, this.accountingPeriodSvcMock);
        Assertions.assertTrue((boolean)billingPeriod.canThisBeBilled());
    }
}

