/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.admin.OrganizationOptionsAdminService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class OrganizationOptionsAdminServiceTest {
    private final OrganizationOptionsAdminService cut = new OrganizationOptionsAdminService();
    private OrganizationOptions organizationOptions;
    @Mock
    private DocumentDictionaryService documentDictionaryServiceMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person personMock;

    OrganizationOptionsAdminServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut.setDocumentDictionaryService(this.documentDictionaryServiceMock);
        this.cut.setPermissionService(this.permissionServiceMock);
        Mockito.when((Object)this.documentDictionaryServiceMock.getMaintenanceDocumentTypeName(OrganizationOptions.class)).thenReturn((Object)"OOPT");
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        this.setupOrganizationOptions();
    }

    private void setupOrganizationOptions() {
        this.organizationOptions = new OrganizationOptions();
        this.organizationOptions.setChartOfAccountsCode("BL");
        this.organizationOptions.setOrganizationCode("PSY");
        this.organizationOptions.setProcessingChartOfAccountCode("UA");
        this.organizationOptions.setProcessingOrganizationCode("VPIT");
    }

    @Test
    void allowsEdit_createMaintainPermissionTrue_returnsTrue() {
        try (MockedStatic theStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            KualiModuleService kualiModuleServiceMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
            theStaticMock.when(KRADServiceLocatorWeb::getKualiModuleService).thenReturn((Object)kualiModuleServiceMock);
            Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)false);
            Map roleQualifications = this.cut.buildRoleQualifications((Object)this.organizationOptions, this.personMock.getPrincipalId());
            Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq((Object)roleQualifications))).thenReturn((Object)true);
            Assertions.assertTrue((boolean)this.cut.allowsEdit((BusinessObjectBase)this.organizationOptions, this.personMock));
        }
    }

    @Test
    void allowsEdit_createMaintainPermissionFalse_returnsFalse() {
        try (MockedStatic theStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            KualiModuleService kualiModuleServiceMock = (KualiModuleService)Mockito.mock(KualiModuleService.class);
            theStaticMock.when(KRADServiceLocatorWeb::getKualiModuleService).thenReturn((Object)kualiModuleServiceMock);
            Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
            Map roleQualifications = this.cut.buildRoleQualifications((Object)this.organizationOptions, this.personMock.getPrincipalId());
            Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq((Object)roleQualifications))).thenReturn((Object)false);
            Assertions.assertFalse((boolean)this.cut.allowsEdit((BusinessObjectBase)this.organizationOptions, this.personMock));
        }
    }
}

