/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.service.SecurityLoggingService;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsInvoiceLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class ContractsGrantsInvoiceLookupableHelperServiceImplTest {
    private static final String PROPOSAL_NUMBER = "1";
    private static final String CHART_OF_ACCOUNTS_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1234567";
    private static final String ANOTHER_PROPOSAL_NUMBER = "2";
    private static final String ANOTHER_CHART_OF_ACCOUNTS_CODE = "BA";
    private static final String ANOTHER_ACCOUNT_NUMBER = "2345678";
    private static final String CHART_AND_ACCOUNT_FOR_NON_SCHEDULED = "-*-*";
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private PermissionService permissionServiceSvcMock;
    @Mock
    private SecurityLoggingService securityLoggingSvcMock;
    private BusinessObjectRestrictions businessObjectRestrictions;
    @Spy
    private ContractsGrantsInvoiceLookupableHelperServiceImpl cutSpy;

    ContractsGrantsInvoiceLookupableHelperServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel((Class)ArgumentMatchers.eq(ContractsGrantsInvoiceLookupResult.class), ArgumentMatchers.anyString())).thenReturn((Object)"Attribute Label");
        ((ContractsGrantsInvoiceLookupableHelperServiceImpl)Mockito.doReturn((Object)this.securityLoggingSvcMock).when((Object)this.cutSpy)).getSecurityLoggingService();
        ((ContractsGrantsInvoiceLookupableHelperServiceImpl)Mockito.doReturn((Object)"khuntley").when((Object)this.cutSpy)).getPrincipalId();
        ((ContractsGrantsInvoiceLookupableHelperServiceImpl)Mockito.doReturn(null).when((Object)this.cutSpy)).getPerson();
        this.cutSpy.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        this.cutSpy.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)new ContractsGrantsReportHelperServiceImpl());
        this.cutSpy.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cutSpy.setPermissionService(this.permissionServiceSvcMock);
        this.cutSpy.setKualiInquirable((Inquirable)new KualiInquirableImpl());
        this.businessObjectRestrictions = null;
    }

    @Test
    void buildSubResultRows_MilestoneSchedule_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertEquals((Object)"2-BL-1234567", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    private Collection<ContractsGrantsInvoiceLookupResultAward> setupLookupResultAwards(String billingFrequencyCode, String secondAwardProposalNumber, String secondAwardChartOfAccountsCode, String secondAwardAccountNumber) {
        ArrayList<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = new ArrayList<ContractsGrantsInvoiceLookupResultAward>();
        ContractsGrantsInvoiceLookupResultAward lookupResultAward = this.setupLookupResultAward(billingFrequencyCode, PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        ContractsGrantsInvoiceLookupResultAward lookupResultAward2 = this.setupLookupResultAward(billingFrequencyCode, secondAwardProposalNumber, secondAwardChartOfAccountsCode, secondAwardAccountNumber);
        lookupResultAwards.add(lookupResultAward);
        lookupResultAwards.add(lookupResultAward2);
        return lookupResultAwards;
    }

    private ContractsGrantsInvoiceLookupResultAward setupLookupResultAward(String billingFrequencyCode, String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        ContractsGrantsInvoiceLookupResultAward lookupResultAward = new ContractsGrantsInvoiceLookupResultAward();
        lookupResultAward.setProposalNumber(proposalNumber);
        lookupResultAward.setChartOfAccountsCode(chartOfAccountsCode);
        lookupResultAward.setAccountNumber(accountNumber);
        lookupResultAward.setBillingFrequencyCode(billingFrequencyCode);
        return lookupResultAward;
    }

    @Test
    void buildSubResultRows_MilestoneSchedule_sameAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MILESTONE.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertEquals((Object)"1-BA-2345678", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void buildSubResultRows_PredeterminedBillingSchedule_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertEquals((Object)"2-BL-1234567", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void buildSubResultRows_PredeterminedBillingSchedule_sameAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-BL-1234567", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertEquals((Object)"1-BA-2345678", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void buildSubResultRows_Monthly_sameAward_onlyFirstShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertNull((Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void buildSubResultRows_Monthly_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertEquals((Object)"2-*-*", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void buildSubResultRows_Quarterly_sameAward_onlyFirstShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.QUARTERLY.getCode(), PROPOSAL_NUMBER, ANOTHER_CHART_OF_ACCOUNTS_CODE, ANOTHER_ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertNull((Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void buildSubResultRows_Quarterly_differentAward_allShouldHaveObjectId() {
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.QUARTERLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        List resultRows = this.cutSpy.buildSubResultRows(result, this.businessObjectRestrictions);
        Assertions.assertEquals((int)2, (int)resultRows.size());
        Assertions.assertEquals((Object)"1-*-*", (Object)((ResultRow)resultRows.get(0)).getObjectId());
        Assertions.assertEquals((Object)"2-*-*", (Object)((ResultRow)resultRows.get(1)).getObjectId());
    }

    @Test
    void filterSearchResults_NullAwards() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)0, (int)searchResultsCollection.size());
    }

    @Test
    void filterSearchResults_NoAwards() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        result.setLookupResultAwards((Collection)Collections.EMPTY_SET);
        searchResultsCollection.add(result);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)0, (int)searchResultsCollection.size());
    }

    @Test
    void filterSearchResults_TwoAwards_NoPermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, false);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, false);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)0, (int)searchResultsCollection.size());
    }

    private void setupInitiateDocumentPermission(String proposalNumber, boolean hasPermission) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "CINV");
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("proposalNumber", proposalNumber);
        Mockito.when((Object)this.permissionServiceSvcMock.isAuthorizedByTemplate("khuntley", "KFS-SYS", "Initiate Document", permissionDetails, qualificationDetails)).thenReturn((Object)hasPermission);
    }

    @Test
    void filterSearchResults_TwoAwards_BothHavePermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, true);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)1, (int)searchResultsCollection.size());
        Assertions.assertEquals((int)2, (int)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
    }

    @Test
    void filterSearchResults_TwoAwardAccounts_OnlyOneHasPermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, false);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)1, (int)searchResultsCollection.size());
        Assertions.assertEquals((int)1, (int)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
        Assertions.assertEquals((Object)ANOTHER_PROPOSAL_NUMBER, (Object)((ContractsGrantsInvoiceLookupResultAward)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().iterator().next()).getProposalNumber());
    }

    @Test
    void filterSearchResults_TwoResultsWithTwoAwardAccountsEach_OnlyOneHasPermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        ContractsGrantsInvoiceLookupResult anotherResult = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> moreLookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        anotherResult.setLookupResultAwards(moreLookupResultAwards);
        searchResultsCollection.add(anotherResult);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, false);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)2, (int)searchResultsCollection.size());
        Assertions.assertEquals((int)1, (int)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
        Assertions.assertEquals((Object)ANOTHER_PROPOSAL_NUMBER, (Object)((ContractsGrantsInvoiceLookupResultAward)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().iterator().next()).getProposalNumber());
        Assertions.assertEquals((int)1, (int)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(1)).getLookupResultAwards().size());
        Assertions.assertEquals((Object)ANOTHER_PROPOSAL_NUMBER, (Object)((ContractsGrantsInvoiceLookupResultAward)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(1)).getLookupResultAwards().iterator().next()).getProposalNumber());
    }

    @Test
    void filterSearchResults_TwoResultsWithTwoAwardAccountsEach_BothHavePermission() {
        ArrayList<ContractsGrantsInvoiceLookupResult> searchResultsCollection = new ArrayList<ContractsGrantsInvoiceLookupResult>();
        ContractsGrantsInvoiceLookupResult result = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> lookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        result.setLookupResultAwards(lookupResultAwards);
        searchResultsCollection.add(result);
        ContractsGrantsInvoiceLookupResult anotherResult = new ContractsGrantsInvoiceLookupResult();
        Collection<ContractsGrantsInvoiceLookupResultAward> moreLookupResultAwards = this.setupLookupResultAwards(ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ANOTHER_PROPOSAL_NUMBER, CHART_OF_ACCOUNTS_CODE, ACCOUNT_NUMBER);
        anotherResult.setLookupResultAwards(moreLookupResultAwards);
        searchResultsCollection.add(anotherResult);
        this.setupInitiateDocumentPermission(PROPOSAL_NUMBER, true);
        this.setupInitiateDocumentPermission(ANOTHER_PROPOSAL_NUMBER, true);
        this.cutSpy.filterSearchResults(searchResultsCollection);
        Assertions.assertEquals((int)2, (int)searchResultsCollection.size());
        Assertions.assertEquals((int)2, (int)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(0)).getLookupResultAwards().size());
        Assertions.assertEquals((int)2, (int)((ContractsGrantsInvoiceLookupResult)searchResultsCollection.get(1)).getLookupResultAwards().size());
    }
}

