/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.core;

import java.util.List;
import junit.framework.Assert;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.fp.businessobject.SalesTax;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.core.InvoiceDetailExpecteds;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;

public class ArCoreTestUtils
extends Assert {
    private static DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
    private static CustomerInvoiceDetailService invoiceDetailService = (CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class);

    protected static void confirmCustomerInvoiceValid(CustomerInvoiceDocument invoice, KualiDecimal expectedOpenAmount, KualiDecimal expectedTotalAmount, int numDiscounts, boolean isReversal, boolean isOpen, List<InvoiceDetailExpecteds> expecteds) {
        invoice.updateDiscountAndParentLineReferences();
        ArCoreTestUtils.assertTrue((String)"Document should be Final", (boolean)invoice.getDocumentHeader().getWorkflowDocument().isFinal());
        ArCoreTestUtils.assertEquals((String)"OpenAmount wrong.", (Object)expectedOpenAmount, (Object)invoice.getOpenAmount());
        ArCoreTestUtils.assertEquals((String)"TotalAmount wrong.", (Object)expectedTotalAmount, (Object)invoice.getTotalDollarAmount());
        ArCoreTestUtils.assertEquals((String)"Discounts wrong size.", (int)numDiscounts, (int)invoice.getDiscounts().size());
        ArCoreTestUtils.assertEquals((String)"IsReversal wrong.", (boolean)isReversal, (boolean)invoice.isInvoiceReversal());
        ArCoreTestUtils.assertEquals((String)"IsOpen wrong.", (boolean)isOpen, (boolean)invoice.isOpenInvoiceIndicator());
        int x = 0;
        for (CustomerInvoiceDetail detail : invoice.getCustomerInvoiceDetailsWithoutDiscounts()) {
            ArCoreTestUtils.assertEquals((String)"Amount wrong.", (Object)expecteds.get(x).getAmount(), (Object)detail.getAmount());
            ArCoreTestUtils.assertEquals((String)"AmountDiscounted wrong.", (Object)expecteds.get(x).getAmountDiscounted(), (Object)detail.getAmountDiscounted());
            ArCoreTestUtils.assertEquals((String)"AmountOpen wrong.", (Object)expecteds.get(x).getAmountOpen(), (Object)detail.getAmountOpen());
            ArCoreTestUtils.assertEquals((String)"WriteoffAmount wrong.", (Object)expecteds.get(x).getAmountOpen(), (Object)detail.getWriteoffAmount());
            ArCoreTestUtils.assertFalse((String)"Details tested here should never be discount lines.", (boolean)detail.isDiscountLine());
            ArCoreTestUtils.assertEquals((String)"Details tested here should never be discount lines.", (boolean)expecteds.get(x).isDiscounted(), (boolean)detail.isDiscountLineParent());
            ArCoreTestUtils.assertEquals((String)"Should be non-null when discounted lines.", (boolean)expecteds.get(x).isDiscounted(), (detail.getDiscountCustomerInvoiceDetail() != null ? 1 : 0) != 0);
            ArCoreTestUtils.assertNull((String)"Should always be null since we only have non-discount lines.", (Object)detail.getParentDiscountCustomerInvoiceDetail());
            ArCoreTestUtils.assertEquals((String)"", (boolean)expecteds.get(x).isDiscounted(), (detail.getInvoiceItemDiscountLineNumber() != null ? 1 : 0) != 0);
            List paidApplieds = detail.getMatchingInvoicePaidAppliedsMatchingAnyDocumentFromDatabase();
            List<KualiDecimal> expectedApplieds = expecteds.get(x).getPaidAppliedAmounts();
            ArCoreTestUtils.assertEquals((String)"PaidApplieds should be the right size.", (int)expectedApplieds.size(), (int)paidApplieds.size());
            int y = 0;
            for (KualiDecimal expectedAmount : expectedApplieds) {
                ArCoreTestUtils.assertEquals((String)"", (Object)expectedAmount, (Object)((InvoicePaidApplied)paidApplieds.get(y)).getInvoiceItemAppliedAmount());
                ++y;
            }
            ++x;
        }
    }

    protected static CustomerInvoiceDocument createFinalizedInvoiceOneLine() throws Exception {
        CustomerInvoiceDocument document = ArCoreTestUtils.newInvoiceDocumentOneLine();
        documentService.routeDocument((Document)document, "Unit test routing document.", null);
        WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
        String docNumber = document.getDocumentNumber();
        document = (CustomerInvoiceDocument)documentService.getByDocumentHeaderId(docNumber);
        return document;
    }

    protected static CustomerInvoiceDocument createFinalizedInvoiceTwoLines() throws Exception {
        CustomerInvoiceDocument document = ArCoreTestUtils.newInvoiceDocumentTwoLines();
        documentService.routeDocument((Document)document, "Unit test routing document.", null);
        WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
        String docNumber = document.getDocumentNumber();
        document = (CustomerInvoiceDocument)documentService.getByDocumentHeaderId(docNumber);
        return document;
    }

    protected static CustomerInvoiceDocument createFinalizedInvoiceOneLineDiscounted() throws Exception {
        CustomerInvoiceDocument document = ArCoreTestUtils.newInvoiceDocumentOneLineDiscounted();
        documentService.routeDocument((Document)document, "Unit test routing document.", null);
        WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
        String docNumber = document.getDocumentNumber();
        document = (CustomerInvoiceDocument)documentService.getByDocumentHeaderId(docNumber);
        return document;
    }

    protected static CustomerInvoiceDocument createFinalizedInvoiceTwoLinesOneIsDiscounted() throws Exception {
        CustomerInvoiceDocument document = ArCoreTestUtils.newInvoiceDocumentTwoLinesOneIsDiscounted();
        documentService.routeDocument((Document)document, "Unit test routing document.", null);
        WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
        String docNumber = document.getDocumentNumber();
        document = (CustomerInvoiceDocument)documentService.getByDocumentHeaderId(docNumber);
        return document;
    }

    protected static CustomerInvoiceDocument createFinalizedInvoiceTwoLinesDiscounted() throws Exception {
        CustomerInvoiceDocument document = ArCoreTestUtils.newInvoiceDocumentTwoLinesDiscounted();
        documentService.routeDocument((Document)document, "Unit test routing document.", null);
        WorkflowTestUtils.waitForDocumentApproval((String)document.getDocumentNumber());
        String docNumber = document.getDocumentNumber();
        document = (CustomerInvoiceDocument)documentService.getByDocumentHeaderId(docNumber);
        return document;
    }

    protected static CustomerInvoiceDocument newInvoiceDocumentOneLine() throws WorkflowException {
        CustomerInvoiceDetailFixture[] details = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_THOUSAND_DOLLAR_INVOICE_DETAIL};
        return CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(details);
    }

    protected static CustomerInvoiceDocument newInvoiceDocumentTwoLines() throws WorkflowException {
        CustomerInvoiceDetailFixture[] details = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_THOUSAND_DOLLAR_INVOICE_DETAIL, CustomerInvoiceDetailFixture.FIVE_HUNDRED_DOLLAR_INVOICE_DETAIL};
        return CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(details);
    }

    protected static CustomerInvoiceDocument newInvoiceDocumentOneLineDiscounted() throws WorkflowException {
        CustomerInvoiceDetailFixture[] details = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_THOUSAND_DOLLAR_INVOICE_DETAIL};
        CustomerInvoiceDocument invoice = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(details);
        invoice = ArCoreTestUtils.addDiscountLine(invoice, 0, new KualiDecimal("-250.00"));
        invoice.updateDiscountAndParentLineReferences();
        return invoice;
    }

    protected static CustomerInvoiceDocument newInvoiceDocumentTwoLinesOneIsDiscounted() throws WorkflowException {
        CustomerInvoiceDetailFixture[] details = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_THOUSAND_DOLLAR_INVOICE_DETAIL, CustomerInvoiceDetailFixture.FIVE_HUNDRED_DOLLAR_INVOICE_DETAIL};
        CustomerInvoiceDocument invoice = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(details);
        invoice = ArCoreTestUtils.addDiscountLine(invoice, 0, new KualiDecimal("-250.00"));
        invoice.updateDiscountAndParentLineReferences();
        return invoice;
    }

    protected static CustomerInvoiceDocument newInvoiceDocumentTwoLinesDiscounted() throws WorkflowException {
        CustomerInvoiceDetailFixture[] details = new CustomerInvoiceDetailFixture[]{CustomerInvoiceDetailFixture.ONE_THOUSAND_DOLLAR_INVOICE_DETAIL, CustomerInvoiceDetailFixture.FIVE_HUNDRED_DOLLAR_INVOICE_DETAIL};
        CustomerInvoiceDocument invoice = CustomerInvoiceDocumentFixture.BASE_CIDOC_WITH_CUSTOMER.createCustomerInvoiceDocument(details);
        invoice = ArCoreTestUtils.addDiscountLine(invoice, 0, new KualiDecimal("-250.00"));
        invoice = ArCoreTestUtils.addDiscountLine(invoice, 1, new KualiDecimal("-250.00"));
        invoice.updateDiscountAndParentLineReferences();
        return invoice;
    }

    private static CustomerInvoiceDocument addDiscountLine(CustomerInvoiceDocument invoice, int seqNumberBeingDiscounted, KualiDecimal amount) {
        SalesTax salesTax;
        CustomerInvoiceDetail lineBeingDiscounted = (CustomerInvoiceDetail)invoice.getSourceAccountingLine(seqNumberBeingDiscounted);
        CustomerInvoiceDetail discountingLine = invoiceDetailService.getDiscountCustomerInvoiceDetailForCurrentYear(lineBeingDiscounted, invoice);
        discountingLine.setAmount(amount);
        discountingLine.setInvoiceItemUnitPrice(amount.bigDecimalValue());
        discountingLine.refreshNonUpdateableReferences();
        invoice.addSourceAccountingLine((SourceAccountingLine)discountingLine);
        if (discountingLine.isSalesTaxRequired() && ObjectUtils.isNotNull((Object)(salesTax = discountingLine.getSalesTax()))) {
            salesTax.setDocumentNumber(discountingLine.getDocumentNumber());
            salesTax.setFinancialDocumentLineTypeCode(discountingLine.getFinancialDocumentLineTypeCode());
            salesTax.setFinancialDocumentLineNumber(discountingLine.getSequenceNumber());
        }
        ((FinancialSystemDocumentHeader)invoice.getDocumentHeader()).setFinancialDocumentTotalAmount(invoice.getTotalDollarAmount());
        lineBeingDiscounted.setInvoiceItemDiscountLineNumber(discountingLine.getSequenceNumber());
        return invoice;
    }

    protected static KualiDecimal fifteenHundred() {
        return new KualiDecimal("1500.00");
    }

    protected static KualiDecimal twelveFifty() {
        return new KualiDecimal("1250.00");
    }

    protected static KualiDecimal oneThousand() {
        return new KualiDecimal("1000.00");
    }

    protected static KualiDecimal sevenFifty() {
        return new KualiDecimal("750.00");
    }

    protected static KualiDecimal fiveHundred() {
        return new KualiDecimal("500.00");
    }

    protected static KualiDecimal twoFifty() {
        return new KualiDecimal("250.00");
    }
}

