/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PaymentApplicationDocumentTest {
    private PaymentApplicationDocument cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private FinancialSystemDocumentHeader financialSystemDocumentHeaderMock;
    @Mock
    private WorkflowDocument workflowDocMock;

    PaymentApplicationDocumentTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cut = new PaymentApplicationDocument();
        }
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setDocumentHeader((DocumentHeader)this.financialSystemDocumentHeaderMock);
        Mockito.when((Object)this.financialSystemDocumentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocMock);
        this.cut.setGlpeService((GeneralLedgerPendingEntryService)Mockito.mock(GeneralLedgerPendingEntryService.class));
    }

    @Test
    void doRouteStatusChange_Disapproved_CashControlUpdatedAndSaved() {
        Mockito.when((Object)this.workflowDocMock.isDisapproved()).thenReturn((Object)true);
        Mockito.when((Object)this.workflowDocMock.getStatus()).thenReturn((Object)DocumentStatus.DISAPPROVED);
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(new KualiDecimal(1000.0));
        this.cut.setCashControlDetail(cashControlDetail);
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(null, null, DocumentStatus.ENROUTE.getCode(), DocumentStatus.DISAPPROVED.getCode());
        this.cut.doRouteStatusChange(statusChangeEvent);
        Assertions.assertEquals((Object)KualiDecimal.ZERO, (Object)cashControlDetail.getFinancialDocumentLineAmount());
        ((BusinessObjectService)Mockito.verify((Object)this.businessObjectSvcMock)).save((PersistableBusinessObject)cashControlDetail);
    }

    @Test
    void doRouteStatusChange_Enroute_CashControlUnchanged() {
        Mockito.when((Object)this.workflowDocMock.isEnroute()).thenReturn((Object)true);
        Mockito.when((Object)this.workflowDocMock.getStatus()).thenReturn((Object)DocumentStatus.ENROUTE);
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(new KualiDecimal(1000.0));
        this.cut.setCashControlDetail(cashControlDetail);
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(null, null, DocumentStatus.SAVED.getCode(), DocumentStatus.ENROUTE.getCode());
        this.cut.doRouteStatusChange(statusChangeEvent);
        Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)cashControlDetail.getFinancialDocumentLineAmount());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.businessObjectSvcMock});
    }
}

