/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kim.api.permission.PermissionService;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.krad.bo.DataObjectAuthorizerBase;
import org.kuali.kfs.module.ar.document.authorization.MilestoneScheduleMaintenanceDocumentAuthorizer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class MilestoneScheduleMaintenanceDocumentAuthorizerTest {
    private MilestoneScheduleMaintenanceDocumentAuthorizer cut;
    @Mock
    private PermissionService permissionSvcMock;

    MilestoneScheduleMaintenanceDocumentAuthorizerTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.cut = new MilestoneScheduleMaintenanceDocumentAuthorizer();
        DataObjectAuthorizerBase.setPermissionService((PermissionService)this.permissionSvcMock);
    }

    @AfterEach
    void tearDown() {
        DataObjectAuthorizerBase.setPermissionService(null);
    }

    @Test
    void conditionallyHideMilestoneCollectionEditing_DoHide() {
        MaintainableCollectionDefinition maintainableCollectionDefinition = new MaintainableCollectionDefinition();
        String wklykinsPrincipalId = "2191506168";
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)wklykinsPrincipalId), (String)ArgumentMatchers.eq((Object)"KFS-SYS"), (String)ArgumentMatchers.eq((Object)"Add Line"), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)false);
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
        this.cut.conditionallyHideMilestoneCollectionEditing(wklykinsPrincipalId, maintainableCollectionDefinition);
        Assertions.assertFalse((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertFalse((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
    }

    @Test
    void conditionallyHideMilestoneCollectionEditing_DoNotHide() {
        MaintainableCollectionDefinition maintainableCollectionDefinition = new MaintainableCollectionDefinition();
        String khuntleyPrincipalId = "6162502038";
        Mockito.when((Object)this.permissionSvcMock.isAuthorizedByTemplate((String)ArgumentMatchers.eq((Object)khuntleyPrincipalId), (String)ArgumentMatchers.eq((Object)"KFS-SYS"), (String)ArgumentMatchers.eq((Object)"Add Line"), (Map)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
        this.cut.conditionallyHideMilestoneCollectionEditing(khuntleyPrincipalId, maintainableCollectionDefinition);
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.getIncludeAddLine());
        Assertions.assertTrue((boolean)maintainableCollectionDefinition.isIncludeMultipleLookupLine());
    }
}

