/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsAgingOpenInvoicesReportServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsAgingReportServiceImpl;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class ContractsGrantsAgingOpenInvoicesReportServiceTest {
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final String CUSTOMER_NAME = "WOODS CORPORATION";
    private ContractsGrantsAgingOpenInvoicesReportServiceImpl cut;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private ContractsGrantsReportHelperService contractsGrantsReportHelperSvcMock;
    @Mock
    private CustomerInvoiceDocumentService customerInvoiceDocumentSvcMock;
    @Mock
    private KualiModuleService kualiModuleSvcMock;
    @Mock
    private LookupService lookupSvcMock;
    @Mock
    private ModuleService moduleSvcMock;
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    private ContractsAndGrantsBillingAgency agencyMock;

    ContractsGrantsAgingOpenInvoicesReportServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        this.agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)this.agencyMock);
        String agencyNumber = this.agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        this.contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setFinancialDocumentStatusCode("A");
        documentHeader.setWorkflowDocument(workflowDocumentMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getFinancialSystemDocumentHeader()).thenReturn((Object)documentHeader);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setCustomerNumber(CUSTOMER_NUMBER);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeader);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeader);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getBillingDate()).thenReturn((Object)new Date(new java.util.Date().getTime()));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.isOpenInvoiceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        ArrayList<CustomerInvoiceDetail> details = new ArrayList<CustomerInvoiceDetail>();
        CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetailMock.getAccountNumber()).thenReturn((Object)"1234567");
        details.add(customerInvoiceDetailMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getSourceAccountingLines()).thenReturn(details);
        Customer customerMock = (Customer)Mockito.mock(Customer.class);
        Mockito.when((Object)customerMock.getCustomerNumber()).thenReturn((Object)CUSTOMER_NUMBER);
        Mockito.when((Object)customerMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getCustomer()).thenReturn((Object)customerMock);
        InvoiceGeneralDetail invoiceGeneralDetailMock = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        Mockito.when((Object)invoiceGeneralDetailMock.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetailMock);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        HashMap<String, String> formProps = new HashMap<String, String>();
        formProps.put("accountsReceivableDocumentHeader.customerNumber", CUSTOMER_NUMBER);
        formProps.put("accountsReceivableDocumentHeader.customer.customerName", CUSTOMER_NAME);
        formProps.put("documentHeader.workflowDocumentTypeName", "CINV");
        formProps.put("openInvoiceIndicator", "true");
        ArrayList<ContractsGrantsInvoiceDocument> invoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        invoices.add(this.contractsGrantsInvoiceDocumentMock);
        Mockito.when((Object)this.lookupSvcMock.findCollectionBySearch(ContractsGrantsInvoiceDocument.class, formProps)).thenReturn(invoices);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(this.contractsGrantsInvoiceDocumentMock, null)).thenReturn((Object)true);
        ContractsGrantsAgingReportServiceImpl contractsGrantsAgingReportService = new ContractsGrantsAgingReportServiceImpl();
        contractsGrantsAgingReportService.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
        contractsGrantsAgingReportService.setContractsGrantsReportHelperService(this.contractsGrantsReportHelperSvcMock);
        contractsGrantsAgingReportService.setLookupService(this.lookupSvcMock);
        Mockito.when((Object)this.customerInvoiceDocumentSvcMock.getOpenAmountForCustomerInvoiceDocument((CustomerInvoiceDocument)this.contractsGrantsInvoiceDocumentMock)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class)).thenReturn((Object)this.moduleSvcMock);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", CUSTOMER_NUMBER);
        Mockito.when((Object)((ContractsAndGrantsBillingAgency)this.moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args))).thenReturn((Object)this.agencyMock);
        this.cut = new ContractsGrantsAgingOpenInvoicesReportServiceImpl();
        this.cut.setContractsGrantsAgingReportService((ContractsGrantsAgingReportService)contractsGrantsAgingReportService);
        this.cut.setCustomerInvoiceDocumentService(this.customerInvoiceDocumentSvcMock);
        this.cut.setKualiModuleService(this.kualiModuleSvcMock);
    }

    @Test
    void getPopulatedReportDetails() {
        try (MockedStatic globalVariablesStaticMock = Mockito.mockStatic(GlobalVariables.class);){
            UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)((Person)Mockito.mock(Person.class)));
            globalVariablesStaticMock.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            HashMap<String, String[]> urlParameters = new HashMap<String, String[]>();
            urlParameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
            urlParameters.put("customerName", new String[]{CUSTOMER_NAME});
            List populatedReportDetails = this.cut.getPopulatedReportDetails(urlParameters);
            Assertions.assertNotNull((Object)populatedReportDetails);
            Assertions.assertEquals((int)1, (int)populatedReportDetails.size());
            ContractsGrantsAgingOpenInvoicesReport reportDetails = (ContractsGrantsAgingOpenInvoicesReport)populatedReportDetails.get(0);
            Assertions.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), (Object)reportDetails.getDocumentType());
            Assertions.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getDocumentNumber(), (Object)reportDetails.getDocumentNumber());
            Assertions.assertEquals((Object)"", (Object)reportDetails.getDocumentDescription());
            Assertions.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getBillingDate(), (Object)reportDetails.getBillingDate());
            Assertions.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDueDate(), (Object)reportDetails.getDueApprovedDate());
            Assertions.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount(), (Object)reportDetails.getDocumentPaymentAmount());
            Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)reportDetails.getUnpaidUnappliedAmount());
            Assertions.assertEquals((Object)"No", (Object)reportDetails.getFinalInvoice());
            Assertions.assertEquals((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber(), (Object)reportDetails.getProposalNumber());
            Assertions.assertEquals((Object)this.agencyMock.getAgencyNumber(), (Object)reportDetails.getAgencyNumber());
            Assertions.assertEquals((Object)"1234567", (Object)reportDetails.getAccountNumber());
        }
    }

    @Test
    void getPopulatedReportDetails_NoMatchingCustomers() {
        try (MockedStatic globalVariablesStaticMock = Mockito.mockStatic(GlobalVariables.class);){
            UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
            Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)((Person)Mockito.mock(Person.class)));
            globalVariablesStaticMock.when(GlobalVariables::getUserSession).thenReturn((Object)userSessionMock);
            HashMap<String, String[]> urlParameters = new HashMap<String, String[]>();
            urlParameters.put("customerNumber", new String[]{CUSTOMER_NUMBER});
            urlParameters.put("customerName", new String[]{"NO NAME"});
            List populatedReportDetails = this.cut.getPopulatedReportDetails(urlParameters);
            Assertions.assertNotNull((Object)populatedReportDetails);
            Assertions.assertEquals((int)0, (int)populatedReportDetails.size());
        }
    }
}

