/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.exception.WorkflowException;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDocumentFixture;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.SpringContext;

@Execution(value=ExecutionMode.SAME_THREAD)
public final class CustomerInvoiceDocumentIntegTestUtil {
    private static final Logger LOG = LogManager.getLogger();

    private CustomerInvoiceDocumentIntegTestUtil() {
    }

    public static String submitNewCustomerInvoiceDocument(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures) throws WorkflowException {
        CustomerInvoiceDocument document = customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        document.getDocumentHeader().setDocumentDescription("CREATING TEST CUSTOMER INVOICE DOCUMENT");
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)document, "TESTING", new ArrayList());
        }
        catch (Exception e) {
            LOG.fatal("The Customer Invoice Document was not routed, and is not available for testing.", (Throwable)e);
            Assert.fail((String)("The Customer Invoice Document was not routed, and is not available for testing." + e.getClass().getName() + " : " + e.getMessage()));
        }
        Document routedDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(document.getDocumentNumber());
        return ObjectUtils.isNotNull((Object)routedDocument) ? routedDocument.getDocumentNumber() : null;
    }

    public static CustomerInvoiceDocument submitNewCustomerInvoiceDocumentAndReturnIt(CustomerInvoiceDocumentFixture customerInvoiceDocumentFixture, CustomerInvoiceDetailFixture[] customerInvoiceDetailFixtures) throws WorkflowException {
        CustomerInvoiceDocument document = customerInvoiceDocumentFixture.createCustomerInvoiceDocument(customerInvoiceDetailFixtures);
        document.getDocumentHeader().setDocumentDescription("CREATING TEST CUSTOMER INVOICE DOCUMENT");
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)document, "TESTING", new ArrayList());
        }
        catch (Exception e) {
            LOG.fatal("The Customer Invoice Document was not routed, and is not available for testing.", (Throwable)e);
            Assert.fail((String)("The Customer Invoice Document was not routed, and is not available for testing." + e.getClass().getName() + " : " + e.getMessage() + "\n" + IntegTestUtils.dumpMessageMapErrors() + "\n" + document));
        }
        Document routedDocument = ((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(document.getDocumentNumber());
        return (CustomerInvoiceDocument)routedDocument;
    }
}

