/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationDocumentServiceImpl;

class PaymentApplicationDocumentServiceImplTest {
    private final PaymentApplicationDocumentServiceImpl cut = new PaymentApplicationDocumentServiceImpl();

    PaymentApplicationDocumentServiceImplTest() {
    }

    @Test
    void getCashControlDocumentForPaymentApplicationDocument_invalidArgs() {
        PaymentApplicationDocument document = null;
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.cut.getCashControlDocumentForPaymentApplicationDocument(document));
        Assertions.assertEquals((Object)"paymentApplicationDocument cannot be null", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"getCashControlDocumentForPayAppDocNumberInvalidArgs"})
    void getCashControlDocumentForPayAppDocNumber_invalidArgs(String documentNumber) {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.cut.getCashControlDocumentForPayAppDocNumber(documentNumber));
        Assertions.assertEquals((Object)"paymentApplicationDocumentNumber cannot be blank", (Object)exception.getMessage());
    }

    private static Stream<Arguments> getCashControlDocumentForPayAppDocNumberInvalidArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null}), Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{" "}));
    }

    @Test
    void getCashControlDetailForPaymentApplicationDocument_invalidArgs() {
        PaymentApplicationDocument document = null;
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.cut.getCashControlDetailForPaymentApplicationDocument(document));
        Assertions.assertEquals((Object)"document cannot be null", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"getCashControlDetailForPayAppDocNumberInvalidArgs"})
    void getCashControlDetailForPayAppDocNumber_invalidArgs(String documentNumber) {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.cut.getCashControlDetailForPayAppDocNumber(documentNumber));
        Assertions.assertEquals((Object)"payAppDocNumber cannot be blank", (Object)exception.getMessage());
    }

    private static Stream<Arguments> getCashControlDetailForPayAppDocNumberInvalidArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null}), Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{" "}));
    }
}

