/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.document.validation.CostCategoryRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class CostCategoryRuleTest {
    private static final Integer NON_UNIQUE_SORT_CODE = 2;
    private static final String NON_UNIQUE_CATEGORY_CODE = "TRVD";
    private CostCategoryRule cut;
    @Mock
    private BusinessObjectService boServiceMock;

    CostCategoryRuleTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut = new CostCategoryRule();
        this.cut.setBusinessObjectService(this.boServiceMock);
        HashMap<String, Constable> matcher = new HashMap<String, Constable>();
        matcher.put("categorySortCode", NON_UNIQUE_SORT_CODE);
        matcher.put("active", Boolean.valueOf(true));
        HashMap<String, String> negate = new HashMap<String, String>();
        negate.put("categoryCode", NON_UNIQUE_CATEGORY_CODE);
        Mockito.when((Object)this.boServiceMock.countMatching(CostCategory.class, matcher, negate)).thenReturn((Object)1);
    }

    @Test
    void checkCostCategoryUniqueSortCode_Null() {
        this.cut.newCategories = this.createCostCategory("IDC", "Indirect Costs", null);
        Assertions.assertTrue((boolean)this.cut.checkCostCategoryUniqueSortCode(), (String)"validation should not fail with null sort code");
    }

    @Test
    void checkCostCategoryUniqueSortCode_UpdateExistCostCategory() {
        this.cut.newCategories = this.createCostCategory("EQIP", "Equipment", 1);
        Assertions.assertTrue((boolean)this.cut.checkCostCategoryUniqueSortCode(), (String)"validation should not fail with updating existing cost category");
    }

    @Test
    void checkCostCategoryUniqueSortCode_Unique() {
        this.cut.newCategories = this.createCostCategory("EMPB", "Employee Benefits", 3);
        Assertions.assertTrue((boolean)this.cut.checkCostCategoryUniqueSortCode(), (String)"validation should not fail with unique sort code");
    }

    @Test
    void checkCostCategoryUniqueSortCode_NotUnique() {
        this.cut.newCategories = this.createCostCategory(NON_UNIQUE_CATEGORY_CODE, "Travel-Domestic", NON_UNIQUE_SORT_CODE);
        Assertions.assertFalse((boolean)this.cut.checkCostCategoryUniqueSortCode(), (String)"validation should fail with nonunique sort code");
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List nonUniqueSortCodeErrorMessages = (List)errorMessages.get("document.newMaintainableObject.categorySortCode");
        Assertions.assertEquals((int)1, (int)nonUniqueSortCodeErrorMessages.size());
        Assertions.assertEquals((Object)"error.document.cost.category.sort.code.not.unique", (Object)((ErrorMessage)nonUniqueSortCodeErrorMessages.get(0)).getErrorKey());
    }

    private CostCategory createCostCategory(String categoryCode, String categoryName, Integer categorySortCode) {
        CostCategory costCategory = new CostCategory();
        costCategory.setCategoryCode(categoryCode);
        costCategory.setCategoryName(categoryName);
        costCategory.setCategorySortCode(categorySortCode);
        costCategory.setActive(true);
        return costCategory;
    }
}

