/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceCustomerAddressValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class CustomerInvoiceCustomerAddressValidationTest {
    private static final String VALID_CUSTOMER_NUMBER = "ABB2";
    private static final Integer VALID_ACTIVE_ADDRESS_IDENTIFIER = 1;
    private static final Integer VALID_INACTIVE_ADDRESS_IDENTIFIER = 10;
    private static final Integer INVALID_ADDRESS_IDENTIFIER = 99;
    private CustomerInvoiceCustomerAddressValidation cut;
    @Mock
    private CustomerAddressService customerAddressSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock;

    CustomerInvoiceCustomerAddressValidationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.accountsReceivableDocumentHeaderMock.getCustomerNumber()).thenReturn((Object)VALID_CUSTOMER_NUMBER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)this.accountsReceivableDocumentHeaderMock);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressExists(VALID_CUSTOMER_NUMBER, VALID_ACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressExists(VALID_CUSTOMER_NUMBER, VALID_INACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressExists(VALID_CUSTOMER_NUMBER, INVALID_ADDRESS_IDENTIFIER)).thenReturn((Object)false);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressActive(VALID_CUSTOMER_NUMBER, VALID_ACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)true);
        Mockito.when((Object)this.customerAddressSvcMock.customerAddressActive(VALID_CUSTOMER_NUMBER, VALID_INACTIVE_ADDRESS_IDENTIFIER)).thenReturn((Object)false);
        this.cut = new CustomerInvoiceCustomerAddressValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        this.cut.setCustomerAddressService(this.customerAddressSvcMock);
    }

    @Test
    void validate_ValidActiveBillToAddress_ValidActiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_ValidInactiveBillToAddress_ValidActiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_InvalidBillToAddress_ValidActiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_ValidActiveBillToAddress_ValidInactiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_ValidActiveBillToAddress_InvalidShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_ACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_ValidInactiveBillToAddress_ValidInactiveShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_ValidInactiveBillToAddress_InvalidShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)VALID_INACTIVE_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_InvalidBillToAddress_InvalidShipToAddress() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerBillToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Mockito.when((Object)this.customerInvoiceDocumentMock.getCustomerShipToAddressIdentifier()).thenReturn((Object)INVALID_ADDRESS_IDENTIFIER);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }
}

