/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerAddressEmail;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class CustomerRuleTest {
    private static final String ERROR_PATH_PREFIX_ROOT = "document.newMaintainableObject.customerAddresses";
    private static final String CUSTOMER_ADDRESS_NAME = "Address Name";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_US = "US";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_RO = "RO";
    private static final String CUSTOMER_ADDRESS_STATE_CODE = "NY";
    private static final String CUSTOMER_ADDRESS_ZIP_CODE = "14850";
    private CustomerRule cut;
    private Customer customer;
    private CustomerAddress customerAddress;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;

    CustomerRuleTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new CustomerRule();
        this.cut.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.customer = new Customer();
        this.customerAddress = new CustomerAddress();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut.setDictionaryValidationService(null);
    }

    @Test
    void checkCustomerHasAddress_HasAddress() {
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkCustomerHasAddress(this.customer);
        Assertions.assertTrue((boolean)result, (String)"When customer has an address checkCustomerHasAddress should return true.");
    }

    @Test
    void checkCustomerHasAddress_NoAddress() {
        this.customer.getCustomerAddresses().clear();
        boolean result = this.cut.checkCustomerHasAddress(this.customer);
        Assertions.assertFalse((boolean)result, (String)"When customer does not have an address checkCustomerHasAddress should return false.");
    }

    @Test
    void checkAddressIsValid_CountryUS_StateAndZipCodeSet() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode(CUSTOMER_ADDRESS_STATE_CODE);
        this.customerAddress.setCustomerZipCode(CUSTOMER_ADDRESS_ZIP_CODE);
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assertions.assertTrue((boolean)result, (String)"When customer address has country code US and state code and zip code are not empty checkAddressIsValid should return true.");
    }

    @Test
    void checkAddressIsValid_CountryUS_StateAndZipCodeEmpty() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode("");
        this.customerAddress.setCustomerZipCode("");
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assertions.assertFalse((boolean)result, (String)"When customer address has country code US and state code and zip code are empty checkAddressIsValid should return false.");
    }

    @Test
    void checkAddressIsValid_CountryNonUS_InternationalProvinceNameAndMailCodeEmpty() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_RO);
        this.customerAddress.setCustomerAddressInternationalProvinceName("");
        this.customerAddress.setCustomerZipCode("");
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assertions.assertTrue((boolean)result, (String)"When customer address has country code RO and province and International Mail Code are empty checkAddressIsValid should return true; province and international mail code are never required.");
    }

    @Test
    void checkAddresses_OnePrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assertions.assertTrue((boolean)result, (String)"When customer has one primary address checkAddresses should return true.");
    }

    @Test
    void checkAddresses_HasMore_MoreThanOnePrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assertions.assertFalse((boolean)result, (String)"When customer has more than one primary address checkAddresses should return false.");
    }

    @Test
    void checkAddresses_HasNone_NoPrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("A");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assertions.assertFalse((boolean)result, (String)"When customer has no primary address checkAddresses should return false.");
    }

    @Test
    void checkEndDateIsValid_Today_Invalid() {
        Date endDate = Date.valueOf(LocalDate.now());
        Assertions.assertFalse((boolean)this.cut.checkEndDateIsValid(endDate, false));
    }

    @Test
    void checkEndDateIsValid_Today_Valid() {
        Date endDate = Date.valueOf(LocalDate.now());
        Assertions.assertTrue((boolean)this.cut.checkEndDateIsValid(endDate, true));
    }

    @Test
    void checkEndDateIsValid_Tomorrow_Valid() {
        Date endDate = Date.valueOf(LocalDate.now().plusDays(1L));
        Assertions.assertTrue((boolean)this.cut.checkEndDateIsValid(endDate, false));
    }

    @Test
    void checkEmailAddress_TransmissionCodeNotEmail_NoEmailAddress() {
        Assertions.assertTrue((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
    }

    @Test
    void checkEmailAddress_TransmissionCodeNotEmail_ValidEmailAddress() {
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 0);
        Assertions.assertTrue((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
    }

    @Test
    void checkEmailAddress_TransmissionCodeNotEmail_InvalidEmailAddress() {
        this.setupEmailAddress("hedgehog@kuali.co", true, false, 0);
        Assertions.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkEmailAddress_TransmissionCodeNotEmail_DuplicateEmailAddresses() {
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 0);
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 1);
        Assertions.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.customerAddresses[0].customerAddressEmails[1].customerEmailAddress");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customer.duplicateEmailForAddress", (Object)errorMessage.getErrorKey());
    }

    @Test
    void checkEmailAddress_TransmissionCodeEmail_NoEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        Assertions.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get(ERROR_PATH_PREFIX_ROOT);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customer.atLeastOneEmailRequired", (Object)errorMessage.getErrorKey());
    }

    @Test
    void checkEmailAddress_TransmissionCodeEmail_OneInactiveEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("hedgehog@kuali.co", false, true, 0);
        Assertions.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get(ERROR_PATH_PREFIX_ROOT);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customer.atLeastOneEmailRequired", (Object)errorMessage.getErrorKey());
    }

    @Test
    void checkEmailAddress_TransmissionCodeEmail_OneInactiveEmailAddress_OneActiveEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("active@kuali.co", true, true, 0);
        this.setupEmailAddress("inactive@kuali.co", false, true, 1);
        Assertions.assertTrue((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
    }

    @Test
    void checkEmailAddress_TransmissionCodeEmail_InvalidEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("hedgehog@kuali.co", true, false, 0);
        Assertions.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkEmailAddress_TransmissionCodeEmail_DuplicateEmailAddresses() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 0);
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 1);
        Assertions.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.customerAddresses[0].customerAddressEmails[1].customerEmailAddress");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.document.customer.duplicateEmailForAddress", (Object)errorMessage.getErrorKey());
    }

    private void setupEmailAddress(String customerEmailAddress, boolean active, boolean valid, int index) {
        CustomerAddressEmail customerAddressEmail = new CustomerAddressEmail();
        customerAddressEmail.setCustomerEmailAddress(customerEmailAddress);
        customerAddressEmail.setActive(active);
        this.customerAddress.getCustomerAddressEmails().add(customerAddressEmail);
        String errorPathPrefix = "document.newMaintainableObject.customerAddresses[0].customerAddressEmails[" + index + "]";
        Mockito.when((Object)this.dictionaryValidationSvcMock.isBusinessObjectValid((BusinessObject)customerAddressEmail, errorPathPrefix)).thenReturn((Object)valid);
    }
}

