/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.validation.impl.PaymentApplicationAdjustmentDocumentRule;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PaymentApplicationAdjustmentDocumentRuleTest {
    @Mock
    PaymentApplicationAdjustmentDocument paymentApplicationAdjustmentDocumentMock;
    PaymentApplicationAdjustmentDocumentRule cut = new PaymentApplicationAdjustmentDocumentRule();

    PaymentApplicationAdjustmentDocumentRuleTest() {
    }

    @BeforeEach
    void setup() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().clearWarningMessages();
    }

    @AfterAll
    static void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().clearWarningMessages();
    }

    @ParameterizedTest(name="With a previously applied amount of {0}, open amount {1} newly applied amount {2}, error message will be present: {3}")
    @MethodSource(value={"invoiceDetailAmounts"})
    void processCustomRouteDocumentBusinessRules_invoiceAmounts(double previouslyAppliedAmount, double openAmount, double newlyAppliedAmount, boolean invalid) {
        InvoicePaidApplied invoicePaidApplied = this.createInvoicePaidApplied(previouslyAppliedAmount, openAmount, newlyAppliedAmount);
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(List.of(invoicePaidApplied));
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getUnallocatedBalance()).thenReturn((Object)KualiDecimal.ZERO);
        Assertions.assertEquals((Object)(!invalid ? 1 : 0), (Object)this.cut.processCustomRouteDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock));
        if (invalid) {
            String invoiceErrorKey = this.errorKeyForInvoice(invoicePaidApplied);
            Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getErrorMessagesForProperty("modal.title"));
            Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getErrorMessagesForProperty("modal.message"));
            Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getErrorMessagesForProperty(invoiceErrorKey));
        } else {
            Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
        }
    }

    @ParameterizedTest(name="With a previously applied amount of {0}, open amount {1} newly applied amount {2}, error message will be present: {3}")
    @MethodSource(value={"invoiceDetailAmounts"})
    void processCustomSaveDocumentBusinessRules_invoiceAmounts(double previouslyAppliedAmount, double openAmount, double newlyAppliedAmount, boolean invalid) {
        InvoicePaidApplied invoicePaidApplied = this.createInvoicePaidApplied(previouslyAppliedAmount, openAmount, newlyAppliedAmount);
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(List.of(invoicePaidApplied));
        Assertions.assertTrue((boolean)this.cut.processCustomSaveDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock));
        if (invalid) {
            String invoiceErrorKey = this.errorKeyForInvoice(invoicePaidApplied);
            Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getWarningCount());
            Assertions.assertNotNull((Object)GlobalVariables.getMessageMap().getWarningMessagesForProperty(invoiceErrorKey));
        } else {
            Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getWarningCount());
        }
    }

    private static Stream<Arguments> invoiceDetailAmounts() {
        return Stream.of(Arguments.of((Object[])new Object[]{50, 50, 150, true}), Arguments.of((Object[])new Object[]{50, 50, 100, false}), Arguments.of((Object[])new Object[]{50, 50, 0, false}), Arguments.of((Object[])new Object[]{50, 50, 0, false}), Arguments.of((Object[])new Object[]{100, 50, 50, false}));
    }

    private String errorKeyForInvoice(InvoicePaidApplied invoicePaidApplied) {
        return String.format("invoiceApplications.%s.detailApplications.%d.amountApplied", invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber(), invoicePaidApplied.getInvoiceItemNumber() - 1);
    }

    @ParameterizedTest(name="With an document open amount of {0} validation should return {1}")
    @MethodSource(value={"openAmounts"})
    void processCustomRouteDocumentBusinessRules_openAmount(KualiDecimal openAmount, boolean valid) {
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.paymentApplicationAdjustmentDocumentMock.getUnallocatedBalance()).thenReturn((Object)openAmount);
        Assertions.assertEquals((Object)valid, (Object)this.cut.processCustomRouteDocumentBusinessRules((Document)this.paymentApplicationAdjustmentDocumentMock));
        if (!valid) {
            Assertions.assertEquals((Object)"error.modal.paymentApplicationAdjustment.openAmountIsNonZero.title", (Object)((ErrorMessage)GlobalVariables.getMessageMap().getErrorMessagesForProperty("modal.title").get(0)).getErrorKey());
            Assertions.assertEquals((Object)"error.modal.paymentApplicationAdjustment.openAmountIsNonZero.message", (Object)((ErrorMessage)GlobalVariables.getMessageMap().getErrorMessagesForProperty("modal.message").get(0)).getErrorKey());
        } else {
            Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
        }
    }

    private static Stream<Arguments> openAmounts() {
        return Stream.of(Arguments.of((Object[])new Object[]{KualiDecimal.ZERO, true}), Arguments.of((Object[])new Object[]{new KualiDecimal(100), false}));
    }

    private InvoicePaidApplied createInvoicePaidApplied(double previouslyAppliedAmount, double openAmount, double newlyAppliedAmount) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetail.getAmountOpen()).thenReturn((Object)new KualiDecimal(openAmount));
        Mockito.when((Object)customerInvoiceDetail.getAmountApplied()).thenReturn((Object)new KualiDecimal(previouslyAppliedAmount));
        InvoicePaidApplied invoicePaidApplied = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)invoicePaidApplied.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(newlyAppliedAmount));
        Mockito.when((Object)invoicePaidApplied.getInvoiceDetail()).thenReturn((Object)customerInvoiceDetail);
        Mockito.when((Object)invoicePaidApplied.getInvoiceItemNumber()).thenReturn((Object)1);
        Mockito.when((Object)invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1234");
        return invoicePaidApplied;
    }
}

