/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.validation.impl.PredeterminedBillingScheduleRuleUtil;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PredeterminedBillingScheduleRuleUtilTest {
    private static final String PROPOSAL_NUMBER = "39928";
    private static final String CHART_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1031400";
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    PredeterminedBillingScheduleRuleUtilTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(PROPOSAL_NUMBER);
        predeterminedBillingSchedule.setChartOfAccountsCode(CHART_CODE);
        predeterminedBillingSchedule.setAccountNumber(ACCOUNT_NUMBER);
        predeterminedBillingSchedule.setObjectId("a different objectId");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", PROPOSAL_NUMBER);
        primaryKeys.put("chartOfAccountsCode", CHART_CODE);
        primaryKeys.put("accountNumber", ACCOUNT_NUMBER);
        Mockito.when((Object)((PredeterminedBillingSchedule)this.businessObjectSvcMock.findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys))).thenReturn((Object)predeterminedBillingSchedule);
        PredeterminedBillingScheduleRuleUtil.setBusinessObjectService((BusinessObjectService)this.businessObjectSvcMock);
    }

    @Test
    void checkIfBillsExist_NullPredeterminedBillingSchedule() {
        Assertions.assertFalse((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist(null));
    }

    @Test
    void checkIfBillsExist_MissingPredeterminedBillingSchedule() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        Assertions.assertFalse((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist((PredeterminedBillingSchedule)predeterminedBillingSchedule));
    }

    @Test
    void checkIfBillsExist_ValidPredeterminedBillingSchedule() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = new PredeterminedBillingSchedule();
        predeterminedBillingSchedule.setProposalNumber(PROPOSAL_NUMBER);
        predeterminedBillingSchedule.setChartOfAccountsCode(CHART_CODE);
        predeterminedBillingSchedule.setAccountNumber(ACCOUNT_NUMBER);
        predeterminedBillingSchedule.setObjectId("objectId");
        Assertions.assertTrue((boolean)PredeterminedBillingScheduleRuleUtil.checkIfBillsExist((PredeterminedBillingSchedule)predeterminedBillingSchedule));
    }
}

