/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentNonAppliedHolding;
import org.kuali.kfs.sys.rest.presentation.Link;

class PaymentApplicationAdjustmentNonAppliedHoldingTest {
    private static final String CUSTOMER_NAME = "CNAME";
    private static final String CUSTOMER_NUMBER = "CNUMBER";
    private static final String CUSTOMER_URL = "CURL";
    private static final KualiDecimal AMOUNT = KualiDecimal.ZERO;
    private final PaymentApplicationAdjustmentNonAppliedHolding cut = new PaymentApplicationAdjustmentNonAppliedHolding("CNAME", "CNUMBER", "CURL", AMOUNT);

    PaymentApplicationAdjustmentNonAppliedHoldingTest() {
    }

    @Test
    void construction_valid() {
        Assertions.assertEquals((Object)CUSTOMER_NAME, (Object)this.cut.getCustomerName());
        Assertions.assertEquals((Object)CUSTOMER_NUMBER, (Object)this.cut.getCustomerNumber());
        Assertions.assertEquals((Object)CUSTOMER_URL, (Object)this.cut.getCustomerUrl());
        Assertions.assertEquals((Object)AMOUNT, (Object)this.cut.getAmount());
        Link expectedLink = new Link(CUSTOMER_NUMBER, CUSTOMER_URL);
        Assertions.assertEquals((Object)expectedLink, (Object)this.cut.getCustomerLink());
    }

    @DisplayName(value="Given invalid arguments, construction should throw an IllegalArgumentException")
    @ParameterizedTest(name="name={0}; number={1}; url={2}; amount={3}")
    @MethodSource(value={"invalidArgs"})
    void construction_invalid(String name, String number, String url, KualiDecimal amount) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PaymentApplicationAdjustmentNonAppliedHolding(name, number, url, amount));
    }

    private static Stream<Arguments> invalidArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT}), Arguments.of((Object[])new Object[]{"", CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT}), Arguments.of((Object[])new Object[]{" ", CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT}), Arguments.of((Object[])new Object[]{CUSTOMER_NAME, null, CUSTOMER_URL, AMOUNT}), Arguments.of((Object[])new Object[]{CUSTOMER_NAME, "", CUSTOMER_URL, AMOUNT}), Arguments.of((Object[])new Object[]{CUSTOMER_NAME, " ", CUSTOMER_URL, AMOUNT}), Arguments.of((Object[])new Object[]{CUSTOMER_NAME, CUSTOMER_NUMBER, null, AMOUNT}), Arguments.of((Object[])new Object[]{CUSTOMER_NAME, CUSTOMER_NUMBER, "", AMOUNT}), Arguments.of((Object[])new Object[]{CUSTOMER_NAME, CUSTOMER_NUMBER, " ", AMOUNT}), Arguments.of((Object[])new Object[]{" ", CUSTOMER_NUMBER, CUSTOMER_URL, null}));
    }

    @ParameterizedTest(name="Given {0} and {1}, they should be equal and have the same hashCode -- {2}")
    @MethodSource(value={"equalsTrueArgs"})
    void equals_true(PaymentApplicationAdjustmentNonAppliedHolding a, Object b, String description) {
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
    }

    private static Stream<Arguments> equalsTrueArgs() {
        PaymentApplicationAdjustmentNonAppliedHolding localCut = new PaymentApplicationAdjustmentNonAppliedHolding(CUSTOMER_NAME, CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT);
        return Stream.of(Arguments.of((Object[])new Object[]{localCut, localCut, "Self"}), Arguments.of((Object[])new Object[]{localCut, new PaymentApplicationAdjustmentNonAppliedHolding(CUSTOMER_NAME, CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT), "Same"}));
    }

    @ParameterizedTest(name="Given {0} and {1}, they should NOT be equal nor have the same hashCode -- {2}")
    @MethodSource(value={"equalsFalseArgs"})
    void equals_false(PaymentApplicationAdjustmentNonAppliedHolding a, Object b, String description) {
        Assertions.assertNotEquals((Object)a, (Object)b);
        if (b != null) {
            Assertions.assertNotEquals((int)a.hashCode(), (int)b.hashCode());
        }
    }

    private static Stream<Arguments> equalsFalseArgs() {
        PaymentApplicationAdjustmentNonAppliedHolding localCut = new PaymentApplicationAdjustmentNonAppliedHolding(CUSTOMER_NAME, CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT);
        return Stream.of(Arguments.of((Object[])new Object[]{localCut, null, "NULL"}), Arguments.of((Object[])new Object[]{localCut, "", "Different class"}), Arguments.of((Object[])new Object[]{localCut, new PaymentApplicationAdjustmentNonAppliedHolding("foo", CUSTOMER_NUMBER, CUSTOMER_URL, AMOUNT), "Different 'name'"}), Arguments.of((Object[])new Object[]{localCut, new PaymentApplicationAdjustmentNonAppliedHolding(CUSTOMER_NAME, "foo", CUSTOMER_URL, AMOUNT), "Different 'number'"}), Arguments.of((Object[])new Object[]{localCut, new PaymentApplicationAdjustmentNonAppliedHolding(CUSTOMER_NAME, CUSTOMER_NUMBER, "foo", AMOUNT), "Different 'url'"}), Arguments.of((Object[])new Object[]{localCut, new PaymentApplicationAdjustmentNonAppliedHolding(CUSTOMER_NAME, CUSTOMER_NUMBER, CUSTOMER_URL, new KualiDecimal(1)), "Different 'amount'"}));
    }
}

