/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;

class AccountingLineTest {
    static final Integer SEQUENCE_NUMBER = 7;
    static final String CHART_CODE = "CHART_CODE";
    static final String ACCOUNT_NUMBER = "ACCOUNT_NUMBER";
    static final String SUB_ACCOUNT_NUMBER = "SUB_ACCOUNT_NUMBER";
    static final String OBJECT = "OBJECT";
    static final String SUB_OBJECT = "SUB_OBJECT";
    static final String PROJECT_CODE = "PROJECT_CODE";
    static final String ORG_REF_ID = "ORG_REF_ID";
    static final String DESCRIPTION = "DESCRIPTION";
    static final KualiDecimal AMOUNT = new KualiDecimal(42);
    static final String CUT_AS_JSON = "{    \"sequenceNumber\": " + SEQUENCE_NUMBER + ",    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"subAccountNumber\": \"SUB_ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"financialSubObjectCode\": \"SUB_OBJECT\",    \"projectCode\": \"PROJECT_CODE\",    \"organizationReferenceId\": \"ORG_REF_ID\",    \"description\": \"DESCRIPTION\",    \"amount\": " + AMOUNT + "}";
    static final String CUT_AS_JSON_MINIMAL = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
    private static final JsonMapper MAPPER = new JsonMapper();
    private static final PaymentApplicationAdjustmentRequest.AccountingLine CUT = new PaymentApplicationAdjustmentRequest.AccountingLine(SEQUENCE_NUMBER, "CHART_CODE", "ACCOUNT_NUMBER", "SUB_ACCOUNT_NUMBER", "OBJECT", "SUB_OBJECT", "PROJECT_CODE", "ORG_REF_ID", "DESCRIPTION", AMOUNT);
    private static final PaymentApplicationAdjustmentRequest.AccountingLine CUT_MINIMAL = new PaymentApplicationAdjustmentRequest.AccountingLine(null, "CHART_CODE", "ACCOUNT_NUMBER", null, "OBJECT", null, null, null, null, AMOUNT);

    AccountingLineTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(PaymentApplicationAdjustmentRequest.AccountingLine expected, String requestJson) throws Exception {
        PaymentApplicationAdjustmentRequest.AccountingLine actual = (PaymentApplicationAdjustmentRequest.AccountingLine)MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.AccountingLine.class);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        String minimalWithUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON_MINIMAL.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT, CUT_AS_JSON}), Arguments.of((Object[])new Object[]{CUT, withUnknown}), Arguments.of((Object[])new Object[]{CUT_MINIMAL, CUT_AS_JSON_MINIMAL}), Arguments.of((Object[])new Object[]{CUT_MINIMAL, minimalWithUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson, String expectedErrorMessage) {
        Exception e = (Exception)Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.AccountingLine.class));
        Assertions.assertTrue((boolean)e.getMessage().contains(expectedErrorMessage));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String minimalJsonWithEmptyChartCode = "{    \"chartOfAccountsCode\": \"\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithBlankChartCode = "{    \"chartOfAccountsCode\": \" \",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithNullChartCode = "{    \"chartOfAccountsCode\": null,    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithMissingChartCode = "{    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithEmptyAccountNumber = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithBlankAccountNumber = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \" \",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithNullAccountNumber = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": null,    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithMissingAccountNumber = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithEmptyObject = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithBlankObject = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \" \",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithNullObject = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": null,    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithMissingObject = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithEmptyAmount = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": }";
        String minimalJsonWithNullAmount = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": null}";
        String minimalJsonWithMissingAmount = "{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\"}";
        return Stream.of(Arguments.of((Object[])new Object[]{minimalJsonWithEmptyChartCode, "chartOfAccountsCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithBlankChartCode, "chartOfAccountsCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithNullChartCode, "chartOfAccountsCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithMissingChartCode, "chartOfAccountsCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithEmptyAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithBlankAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithNullAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithMissingAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithEmptyObject, "financialObjectCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithBlankObject, "financialObjectCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithNullObject, "financialObjectCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithMissingObject, "financialObjectCode must be supplied"}), Arguments.of((Object[])new Object[]{"{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": }", "expected a value"}), Arguments.of((Object[])new Object[]{"{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\",    \"amount\": null}", "amount must be supplied"}), Arguments.of((Object[])new Object[]{"{    \"chartOfAccountsCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"financialObjectCode\": \"OBJECT\"}", "amount must be supplied"}));
    }
}

