/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentService;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.integration.cg.ContractsAndGrantsOrganization;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardFundManagerMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardOrganizationMockFixture;
import org.kuali.kfs.module.ar.fixture.BillingFrequencyFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.OptionsService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PerformValidationTest {
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;
    @Mock
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    @Mock
    private VerifyBillingFrequencyService verifyBillingFrequencyService;
    @Mock
    private FinancialSystemDocumentService financialSystemDocumentService;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private ConfigurationService configSvcMock;
    @Mock
    private OptionsService optionsSvcMock;
    @Mock
    private DateTimeService dateTimeSvcMock;
    @Mock
    private AccountService accountSvcMock;
    private final Set<String> pendingDocumentStatuses = new HashSet<String>(Arrays.asList("I", "S", "R", "E"));
    private Set<ContractsAndGrantsBillingAward> awardsInError;
    private boolean validBillingFrequency;
    private boolean alreadyBuilt;
    private boolean hasMilestonesToInvoice;
    private boolean hasBillsToInvoice;
    private boolean customerRecord;
    private boolean chartOrgSetUp;
    private boolean invoiceInProgress;
    private List<String> ccaErrors;
    private List<ContractsGrantsInvoiceDocument> pendingDocuments;

    PerformValidationTest() {
    }

    @BeforeEach
    void setup() {
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationService);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentService);
        this.cut.setVerifyBillingFrequencyService(this.verifyBillingFrequencyService);
        this.cut.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setConfigurationService(this.configSvcMock);
        this.cut.setOptionsService(this.optionsSvcMock);
        this.cut.setDateTimeService(this.dateTimeSvcMock);
        this.cut.setAccountService(this.accountSvcMock);
        this.validBillingFrequency = true;
        this.alreadyBuilt = false;
        this.hasMilestonesToInvoice = false;
        this.hasBillsToInvoice = false;
        this.customerRecord = true;
        this.chartOrgSetUp = true;
        this.invoiceInProgress = false;
        this.ccaErrors = new ArrayList<String>();
        this.pendingDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        this.awardsInError = new HashSet<ContractsAndGrantsBillingAward>();
    }

    @Test
    void validateAwards_StartDateMissing() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD1.createAwardMock();
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn(null);
        awards.add(awardMock);
        this.prepareOtherMocks();
        this.expectError(awardMock, "error.cginvoice.award.startDate.missing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvalidBillingFrequency() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD1.createAwardMock();
        awards.add(awardMock);
        this.prepareOtherMocks();
        this.expectError(awardMock, "error.cginvoice.billing.missing.frequency");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvalidBillingPeriod() {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_INVALID_DATES.createAwardMock();
        Mockito.when((Object)awardMock.getAwardBeginningDate()).thenReturn((Object)new Date(DateTimeUtils.currentTimeMillis()));
        awards.add(awardMock);
        this.hasBillsToInvoice = true;
        this.validBillingFrequency = false;
        this.prepareMocks(awardMock);
        this.prepareOtherMocks();
        this.expectError(awardMock, "error.cginvoice.award.not.eligible.invoice");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_ValidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should contain one award.");
        Assertions.assertEquals(((List)qualifiedAwards).get(0), (Object)awards.get(0), (String)"qualifiedAwards should contain our initial award.");
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_AwardInvoicingSuspended() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_AwardWithLetterOfCreditBillingFrequency_batchCreation() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.locb.billing.frequency");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_AwardWithLetterOfCreditBillingFrequency_letterOfCreditCreation() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.locb.billing.frequency");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.LOC);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should not be empty.");
        Assertions.assertEquals(((List)qualifiedAwards).get(0), (Object)awards.get(0), (String)"qualifiedAwards should contain our initial award.");
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_InactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).isActive()).thenReturn((Object)false);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.inactive");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_SuspendedAndInactiveAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).isActive()).thenReturn((Object)false);
        Mockito.when((Object)awards.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_TwoInvalidAwards() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        Mockito.when((Object)awards.get(0).isActive()).thenReturn((Object)false);
        Mockito.when((Object)awards2.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        awards.addAll(awards2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.excluded.from.invoicing");
        this.expectError(awards.get(1), "error.cginvoice.award.inactive");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)2, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
        errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(1)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_OneValidOneInvalidAward() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        List<ContractsAndGrantsBillingAward> awards2 = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2);
        Mockito.when((Object)awards2.get(0).isExcludedFromInvoicing()).thenReturn((Object)true);
        awards.addAll(awards2);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(1), "error.cginvoice.award.excluded.from.invoicing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should contain one award.");
        Assertions.assertEquals(((List)qualifiedAwards).get(0), (Object)awards.get(0), (String)"qualifiedAwards should contain our initial award.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_MissingAwardInvoicingOption() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).getInvoicingOptionCode()).thenReturn(null);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.missing");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_PredeterminedBilling_MultipleAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        List awardAccountMocks = award.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)award.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        this.hasBillsToInvoice = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size());
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_MilestoneBilling_MultipleAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        List awardAccountMocks = award.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)award.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        this.hasMilestonesToInvoice = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size());
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_NoActiveAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).getActiveAwardAccounts()).thenReturn(Collections.emptyList());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.no.active.accounts.assigned");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_AwardFinalInvoiceAlreadyBilled() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.alreadyBuilt = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.already.billed");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoValidMilestonesToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.milestones");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoValidBillsToInvoice() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        Mockito.when((Object)awards.get(0).getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)awards.get(0).getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.bills");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_OneValidOneInvalidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_2.createAwardAccountMock();
        Mockito.when((Object)awardAccountMock.getCurrentLastBilledDate()).thenReturn((Object)new Date(System.currentTimeMillis()));
        List awardAccountMocks = awards.get(0).getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awards.get(0).getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)1, (int)qualifiedAwards.size(), (String)"qualifiedAwards should contain one award.");
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
    }

    @Test
    void validateAwards_AgencyHasNoMatchingCustomer() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.customerRecord = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.award.not.valid.customer");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoValidAwardAccounts() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        ContractsGrantsInvoiceDocument document = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        InvoiceAccountDetail detail = new InvoiceAccountDetail();
        ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)awards.get(0).getActiveAwardAccounts().get(0);
        detail.setAccountNumber(awardAccount.getAccountNumber());
        detail.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        Mockito.when((Object)document.getAccountDetails()).thenReturn(Collections.singletonList(detail));
        Account account = awardAccount.getAccount();
        Mockito.when((Object)this.accountSvcMock.getByPrimaryId(awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber())).thenReturn((Object)account);
        this.pendingDocuments.add(document);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoContractControlAccountsByCCA() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.ccaErrors.add("error.cg.no.control.account");
        this.ccaErrors.add("");
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cg.no.control.account");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_NoSysInfo() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.chartOrgSetUp = false;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cginvoice.sys.info.not.setup");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvoicesInProgressMilestone() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.hasMilestonesToInvoice = true;
        this.invoiceInProgress = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_InvoicesInProgressPredeterminedBilling() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        ContractsAndGrantsBillingAward award = awards.get(0);
        Mockito.when((Object)award.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)award.getBillingFrequency()).thenReturn((Object)BillingFrequencyFixture.BILL_FREQ_PDBS.createBillingFrequency());
        this.hasBillsToInvoice = true;
        this.invoiceInProgress = true;
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        this.expectError(awards.get(0), "error.cgivoice.award.not.valid.accounts");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    @Test
    void validateAwards_MissingIncomeAndReceivableObjectCodes_Invalid() {
        List<ContractsAndGrantsBillingAward> awards = this.setupAwardMocks(ARAwardAccountMockFixture.AWD_ACCT_WITH_CCA_1);
        this.prepareMocks(awards);
        this.prepareOtherMocks();
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(awards.get(0))).thenReturn((Object)false);
        this.expectError(awards.get(0), "error.contracts.grants.invoice.missing.cgbi.object.code");
        ArrayList contractsGrantsInvoiceDocumentErrorLogs = new ArrayList();
        Collection qualifiedAwards = this.cut.validateAwards(awards, contractsGrantsInvoiceDocumentErrorLogs, null, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.MANUAL);
        Assertions.assertEquals((int)0, (int)qualifiedAwards.size(), (String)"qualifiedAwards should be empty.");
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceDocumentErrorLogs.size());
        List errorMessages = ((ContractsGrantsInvoiceDocumentErrorLog)contractsGrantsInvoiceDocumentErrorLogs.get(0)).getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        Assertions.assertEquals((Object)"Error", (Object)((ContractsGrantsInvoiceDocumentErrorMessage)errorMessages.get(0)).getErrorMessageText());
    }

    private void expectError(ContractsAndGrantsBillingAward award, String errorKey) {
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsString(errorKey)).thenReturn((Object)"Error");
        if (!this.awardsInError.contains(award)) {
            this.awardsInError.add(award);
            for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, null)).thenReturn((Object)KualiDecimal.ZERO);
            }
            Mockito.when((Object)this.dateTimeSvcMock.getCurrentTimestamp()).thenReturn(null);
            Mockito.when((Object)((ContractsGrantsInvoiceDocumentErrorLog)this.boServiceMock.save((PersistableBusinessObject)((ContractsGrantsInvoiceDocumentErrorLog)ArgumentMatchers.isA(ContractsGrantsInvoiceDocumentErrorLog.class))))).thenReturn(null);
        }
    }

    private List<ContractsAndGrantsBillingAward> setupAwardMocks(ARAwardAccountMockFixture awardAccountFixture) {
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_VALID.createAwardMock();
        ContractsAndGrantsBillingAgency agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        ContractsAndGrantsBillingAwardAccount awardAccountMock = awardAccountFixture.createAwardAccountMock();
        Account account = new Account();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)account);
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        ContractsAndGrantsOrganization awardOrganizationMock = ARAwardOrganizationMockFixture.AWD_ORG1.createAwardOrganizationMock();
        Mockito.when((Object)awardMock.getPrimaryAwardOrganization()).thenReturn((Object)awardOrganizationMock);
        ContractsAndGrantsFundManager awardFundManagerMock = ARAwardFundManagerMockFixture.AWD_FND_MGR1.createAwardFundManagerMock();
        Mockito.when((Object)awardMock.getAwardPrimaryFundManager()).thenReturn((Object)awardFundManagerMock);
        awards.add(awardMock);
        return awards;
    }

    private void prepareMocks(List<ContractsAndGrantsBillingAward> awards) {
        for (ContractsAndGrantsBillingAward award : awards) {
            this.prepareMocks(award);
        }
    }

    private void prepareMocks(ContractsAndGrantsBillingAward award) {
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isValueOfBillingFrequencyValid(award)).thenReturn((Object)true);
        Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)award), ArgumentMatchers.anyBoolean())).thenReturn((Object)this.validBillingFrequency);
        if (!this.validBillingFrequency) {
            return;
        }
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isAwardFinalInvoiceAlreadyBuilt(award)).thenReturn((Object)this.alreadyBuilt);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasMilestonesToInvoice(award)).thenReturn((Object)this.hasMilestonesToInvoice);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasBillsToInvoice(award)).thenReturn((Object)this.hasBillsToInvoice);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.owningAgencyHasCustomerRecord(award)).thenReturn((Object)this.customerRecord);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(award)).thenReturn(this.ccaErrors);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isChartAndOrgSetupForInvoicing(award)).thenReturn((Object)this.chartOrgSetUp);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.hasIncomeAndReceivableObjectCodes(award)).thenReturn((Object)true);
        if (ArConstants.BillingFrequencyValues.isMilestone((Billable)award) || ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award)) {
            Mockito.when((Object)this.contractsGrantsBillingAwardVerificationService.isInvoiceInProgress(award)).thenReturn((Object)this.invoiceInProgress);
        } else if (award.getActiveAwardAccounts().size() > 0) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
            fieldValues.put("documentHeader.workflowDocumentStatusCode", this.pendingDocumentStatuses);
            Mockito.when((Object)this.boServiceMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(this.pendingDocuments);
            if (this.pendingDocuments.isEmpty()) {
                for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                    Mockito.when((Object)this.verifyBillingFrequencyService.validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.eq((Object)award), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.eq((Object)awardAccount), ArgumentMatchers.anyBoolean())).thenReturn((Object)true);
                }
            }
        }
    }

    private void prepareOtherMocks() {
        Mockito.when((Object)this.optionsSvcMock.getCurrentYearOptions()).thenReturn((Object)new SystemOptions());
        Mockito.when((Object)this.financialSystemDocumentService.getPendingDocumentStatuses()).thenReturn(this.pendingDocumentStatuses);
        Mockito.when((Object)this.configSvcMock.getPropertyValueAsBoolean("module.external.kuali.coeus.enabled")).thenReturn((Object)false);
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts")).thenReturn((Object)2000);
    }
}

