/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.batch;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;
import org.kuali.kfs.core.api.datetime.DateTimeService;

import java.io.File;

public class CustomerInvoiceWriteoffBatchInputFileType extends XmlBatchInputFileTypeBase {

    private static final String FILE_NAME_PREFIX = "customer_invoice_writeoff";
    private static final String FILE_NAME_DELIM = "_";

    private DateTimeService dateTimeService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        //  start with the batch-job-prefix
        StringBuilder fileName = new StringBuilder(FILE_NAME_PREFIX);

        //  add the logged-in user name if there is one, otherwise use a sensible default
        fileName.append(FILE_NAME_DELIM).append(principalName);

        //  if the user specified an identifying label, then use it
        if (StringUtils.isNotBlank(fileUserIdentifier)) {
            fileName.append(FILE_NAME_DELIM).append(fileUserIdentifier);
        }

        //  stick a time stamp on the end
        fileName.append(FILE_NAME_DELIM)
                .append(dateTimeService.toString(dateTimeService.getCurrentTimestamp(), "yyyyMMdd_HHmmss"));

        //  stupid spaces, begone!
        return StringUtils.remove(fileName.toString(), " ");
    }

    public String getFileTypeIdentifier() {
        return ArConstants.CustomerInvoiceWriteoff.CUSTOMER_INVOICE_WRITEOFF_FILE_TYPE_IDENTIFIER;
    }

    public boolean validate(Object parsedFileContents) {
        return true;
    }

    public void process(String fileName, Object parsedFileContents) {
        super.process(fileName, parsedFileContents);
    }

    public String getTitleKey() {
        // this is never uploaded via the GUI
        return "";
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getAuthorPrincipalName(File file) {
        // this should never allow uploads or downloads via the GUI
        return null;
    }
}

