/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.integration.ar.AccountsReceivableCustomerType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

public class CustomerType extends PersistableBusinessObjectBase implements MutableInactivatable,
        AccountsReceivableCustomerType {

    private String customerTypeCode;
    private String customerTypeDescription;
    private boolean invoiceTransmissionMethodRequired;
    private boolean active;

    @Override
    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    @Override
    public String getCustomerTypeDescription() {
        return customerTypeDescription;
    }

    @Override
    public void setCustomerTypeDescription(String customerTypeDescription) {
        this.customerTypeDescription = customerTypeDescription;
    }

    @Override
    public boolean isInvoiceTransmissionMethodRequired() {
        return invoiceTransmissionMethodRequired;
    }

    public void setInvoiceTransmissionMethodRequired(boolean invoiceTransmissionMethodRequired) {
        this.invoiceTransmissionMethodRequired = invoiceTransmissionMethodRequired;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

}
