/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.io.Serializable;
import java.util.Objects;

public class PaymentApplicationInvoiceDetailApply implements Serializable {

    private static final int DEFAULT_PAID_APPLIED_ITEM_NUMBER = 0;

    private CustomerInvoiceDetail invoiceDetail;
    private InvoicePaidApplied paidApplied;

    private KualiDecimal amountApplied;
    private KualiDecimal amountAppliedOldValue;
    private boolean fullApply;
    private boolean fullApplyOldValue;
    private boolean invoiceQuickApplied;
    private String payAppDocNumber;

    public PaymentApplicationInvoiceDetailApply(String payAppDocNumber, CustomerInvoiceDetail invoiceDetail) {
        this.invoiceDetail = invoiceDetail;
        this.amountApplied = KualiDecimal.ZERO;
        this.amountAppliedOldValue = KualiDecimal.ZERO;
        this.fullApply = false;
        this.fullApplyOldValue = false;
        this.paidApplied = new InvoicePaidApplied();
        this.payAppDocNumber = payAppDocNumber;
        this.invoiceQuickApplied = false;
    }

    public InvoicePaidApplied generatePaidApplied() {
        return new InvoicePaidApplied(payAppDocNumber, invoiceDetail.getDocumentNumber(),
            invoiceDetail.getSequenceNumber(), amountApplied, DEFAULT_PAID_APPLIED_ITEM_NUMBER);
    }

    public KualiDecimal getAmountOpen() {
        return invoiceDetail.getAmountOpen();
    }

    public KualiDecimal getAmountApplied() {
        return amountApplied;
    }

    public void setAmountApplied(KualiDecimal amountApplied) {
        amountAppliedOldValue = this.amountApplied;
        this.amountApplied = Objects.requireNonNullElse(amountApplied, KualiDecimal.ZERO);
    }

    @JsonIgnore
    public boolean isAmountAppliedChanged() {
        return !amountApplied.equals(amountAppliedOldValue);
    }

    @JsonIgnore
    public boolean isFullApply() {
        return fullApply;
    }

    public void setFullApply(boolean fullApply) {
        this.fullApplyOldValue = this.fullApply;
        this.fullApply = fullApply;
    }

    @JsonIgnore
    public boolean isFullApplyChanged() {
        return fullApply != fullApplyOldValue;
    }

    @JsonIgnore
    public CustomerInvoiceDetail getInvoiceDetail() {
        return invoiceDetail;
    }

    public String getInvoiceDocumentNumber() {
        return invoiceDetail.getDocumentNumber();
    }

    public Integer getSequenceNumber() {
        return invoiceDetail.getSequenceNumber();
    }

    public String getChartOfAccountsCode() {
        return invoiceDetail.getChartOfAccountsCode();
    }

    public String getAccountNumber() {
        return invoiceDetail.getAccountNumber();
    }

    public String getInvoiceItemDescription() {
        return invoiceDetail.getInvoiceItemDescription();
    }

    public KualiDecimal getAmount() {
        return invoiceDetail.getAmount();
    }

    @JsonIgnore
    public boolean isInvoiceQuickApplied() {
        return invoiceQuickApplied;
    }

    public void setInvoiceQuickApplied(boolean invoiceQuickApplied) {
        this.invoiceQuickApplied = invoiceQuickApplied;
    }
}
