/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.BillingFrequency;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class VerifyBillingFrequencyServiceImpl
implements VerifyBillingFrequencyService {
    protected BusinessObjectService businessObjectService;
    protected AccountingPeriodService accountingPeriodService;
    protected UniversityDateService universityDateService;
    protected DateTimeService dateTimeService;
    protected static final Set<String> invalidPeriodCodes = new TreeSet<String>();

    @Override
    public boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, boolean checkBillingPeriodEnd) {
        return this.validateBillingFrequency(award, award.getLastBilledDate(), checkBillingPeriodEnd);
    }

    @Override
    public boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, ContractsAndGrantsBillingAwardAccount awardAccount, boolean checkBillingPeriodEnd) {
        return this.validateBillingFrequency(award, awardAccount.getCurrentLastBilledDate(), checkBillingPeriodEnd);
    }

    private boolean validateBillingFrequency(ContractsAndGrantsBillingAward award, Date lastBilledDate, boolean checkBillingPeriodEnd) {
        Date today = this.getDateTimeService().getCurrentSqlDate();
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        BillingPeriod billingPeriod = this.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
        if (!billingPeriod.isBillable()) {
            return false;
        }
        if (billingPeriod.getStartDate().after(billingPeriod.getEndDate()) && !ArConstants.BillingFrequencyValues.isMilestone((Billable)award) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award)) {
            return false;
        }
        if (this.beforeBillingPeriodStart(billingPeriod)) {
            return false;
        }
        return this.validateBillingFrequencyWithGracePeriod(today, billingPeriod, lastBilledDate, (BillingFrequency)award.getBillingFrequency(), checkBillingPeriodEnd);
    }

    protected boolean beforeBillingPeriodStart(BillingPeriod billingPeriod) {
        Date today = this.getDateTimeService().getCurrentSqlDate();
        return KfsDateUtils.isEarlierDay((java.util.Date)today, (java.util.Date)billingPeriod.getStartDate());
    }

    public boolean validateBillingFrequencyWithGracePeriod(Date today, BillingPeriod billingPeriod, Date lastBilledDate, BillingFrequency billingFrequency, boolean checkBillingPeriodEnd) {
        Date gracePeriodAfterBillingEnd = this.calculateDaysBeyond(billingPeriod.getEndDate(), billingFrequency.getGracePeriodDays());
        Date gracePeriodAfterLastBilled = null;
        if (lastBilledDate != null) {
            gracePeriodAfterLastBilled = this.calculateDaysBeyond(lastBilledDate, billingFrequency.getGracePeriodDays());
        }
        boolean afterBillingPeriodEnd = !checkBillingPeriodEnd || KfsDateUtils.isSameDayOrLater((java.util.Date)today, (java.util.Date)gracePeriodAfterBillingEnd);
        boolean haveNotBilledYet = lastBilledDate == null || KfsDateUtils.isEarlierDay((java.util.Date)gracePeriodAfterLastBilled, (java.util.Date)today);
        return afterBillingPeriodEnd && haveNotBilledYet;
    }

    @Override
    public BillingPeriod getStartDateAndEndDateOfPreviousBillingPeriod(ContractsAndGrantsBillingAward award, AccountingPeriod currPeriod) {
        return BillingPeriod.determineBillingPeriodPriorTo(award.getAwardBeginningDate(), this.dateTimeService.getCurrentSqlDate(), award.getLastBilledDate(), ArConstants.BillingFrequencyValues.fromCode(award.getBillingFrequencyCode()), this.accountingPeriodService);
    }

    protected Date calculateDaysBeyond(Date date, int daysBeyond) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(6, daysBeyond);
        return new Date(cal.getTimeInMillis());
    }

    protected boolean isInvalidPeriodCode(AccountingPeriod period) {
        String periodCode = period.getUniversityFiscalPeriodCode();
        if (StringUtils.isBlank((CharSequence)periodCode)) {
            throw new IllegalArgumentException("invalid (null) universityFiscalPeriodCode (" + periodCode + ")for" + period);
        }
        return invalidPeriodCodes.contains(periodCode);
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    static {
        invalidPeriodCodes.add("13");
        invalidPeriodCodes.add("AB");
        invalidPeriodCodes.add("BB");
        invalidPeriodCodes.add("CB");
    }
}

