/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionActivityInvoiceLookup;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;

public class CollectionActivityInvoiceLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();
    protected ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        ArrayList<CollectionActivityInvoiceLookup> results = new ArrayList<CollectionActivityInvoiceLookup>();
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String proposalNumber = fieldValues.get("proposalNumber");
        Collection<ContractsGrantsInvoiceDocument> cgInvoices = this.getContractsGrantsCollectionActivityDocumentService().retrieveCollectionActivityEligibleContractsGrantsInvoicesByProposalNumber(proposalNumber);
        for (ContractsGrantsInvoiceDocument invoiceDocument : cgInvoices) {
            results.add(this.convert(invoiceDocument));
        }
        return new CollectionIncomplete(results, Long.valueOf(results.size()));
    }

    protected CollectionActivityInvoiceLookup convert(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        CollectionActivityInvoiceLookup cl = new CollectionActivityInvoiceLookup();
        cl.setProposalNumber(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
        cl.setInvoiceNumber(contractsGrantsInvoiceDocument.getDocumentNumber());
        if (CollectionUtils.isNotEmpty(contractsGrantsInvoiceDocument.getAccountDetails())) {
            cl.setAccountNumber(contractsGrantsInvoiceDocument.getAccountDetails().get(0).getAccountNumber());
        }
        cl.setInvoiceDate(contractsGrantsInvoiceDocument.getBillingDate());
        cl.setInvoiceAmount(contractsGrantsInvoiceDocument.getSourceTotal());
        cl.setBillingPeriod(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingPeriod());
        if (ObjectUtils.isNotNull((Object)((Object)contractsGrantsInvoiceDocument.getInvoiceGeneralDetail()))) {
            cl.setBillingFrequency(contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getBillingFrequencyCode());
        }
        cl.setPaymentAmount(this.getContractsGrantsCollectionActivityDocumentService().retrievePaymentAmountByDocumentNumber(contractsGrantsInvoiceDocument.getDocumentNumber()));
        cl.setBalanceDue((KualiDecimal)cl.getInvoiceAmount().subtract((AbstractKualiDecimal)cl.getPaymentAmount()));
        cl.setAge(contractsGrantsInvoiceDocument.getAge());
        return cl;
    }

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        for (String key : lookupForm.getFieldsForLookup().keySet()) {
            LOG.debug("Key : {} Value : {}", new Supplier[]{() -> key, () -> lookupForm.getFieldsForLookup().get(key)});
        }
        List<? extends BusinessObject> displayList = this.getSearchResults(lookupForm.getFieldsForLookup());
        boolean hasReturnableRow = false;
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        List returnKeys = this.getReturnKeys();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject businessObject : displayList) {
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)businessObject, user);
            if (ObjectUtils.isNotNull((Object)this.getColumns())) {
                List columns = this.getColumns();
                for (Object column : columns) {
                    Column col = (Column)column;
                    Formatter formatter = col.getFormatter();
                    Object prop = ObjectUtils.getPropertyValue((Object)businessObject, (String)col.getPropertyName());
                    String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)businessObject, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                    Class propClass = this.getPropertyClass(businessObject, col.getPropertyName());
                    if (ObjectUtils.isNotNull((Object)prop)) {
                        propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                    }
                    col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                    col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                    propValue = super.maskValueIfNecessary(businessObject, col.getPropertyName(), propValue, businessObjectRestrictions);
                    col.setPropertyValue(propValue);
                }
                lookupForm.setLookupObjectId(((CollectionActivityInvoiceLookup)businessObject).getInvoiceNumber());
                HtmlData returnUrl = this.getReturnUrl(businessObject, lookupForm, returnKeys, businessObjectRestrictions);
                ResultRow row = new ResultRow(columns, returnUrl.constructCompleteHtmlTag(), this.getActionUrls(businessObject, pkNames, businessObjectRestrictions));
                row.setObjectId(((CollectionActivityInvoiceLookup)businessObject).getInvoiceNumber());
                row.setRowId(returnUrl.getName());
                row.setReturnUrlHtmlData(returnUrl);
                boolean isRowReturnable = this.isResultReturnable(businessObject);
                row.setRowReturnable(isRowReturnable);
                if (isRowReturnable) {
                    hasReturnableRow = true;
                }
                resultTable.add(row);
            }
            lookupForm.setHasReturnableRow(hasReturnableRow);
        }
        return displayList;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public ContractsGrantsCollectionActivityDocumentService getContractsGrantsCollectionActivityDocumentService() {
        return this.contractsGrantsCollectionActivityDocumentService;
    }

    public void setContractsGrantsCollectionActivityDocumentService(ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService) {
        this.contractsGrantsCollectionActivityDocumentService = contractsGrantsCollectionActivityDocumentService;
    }
}

