/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.web.format.DateFormatter;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.TicklersReport;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsAgingOpenInvoicesReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;

public class ContractsGrantsAgingOpenInvoicesReportLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    protected ContractsGrantsAgingOpenInvoicesReportService contractsGrantsAgingOpenInvoicesReportService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        List results = this.getContractsGrantsAgingOpenInvoicesReportService().getPopulatedReportDetails(this.getParameters());
        return new CollectionIncomplete((Collection)results, Long.valueOf(results.size()));
    }

    protected Map<String, String> getParameters(BusinessObject bo, Map<String, String> fieldConversions, String lookupImpl, List returnKeys) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "refresh");
        parameters.put("docFormKey", this.getDocFormKey());
        parameters.put("refreshCaller", lookupImpl);
        if (this.getReferencesToRefresh() != null) {
            parameters.put("referencesToRefresh", this.getReferencesToRefresh());
        }
        for (Object entry : this.getReturnKeys()) {
            String fieldNm = (String)entry;
            Object fieldVal = ObjectUtils.getPropertyValue((Object)bo, (String)fieldNm);
            if (fieldVal == null) {
                fieldVal = "";
            }
            if (fieldConversions.containsKey(fieldNm)) {
                fieldNm = fieldConversions.get(fieldNm);
            }
            if (fieldVal instanceof Date) {
                DateFormatter dateFormatter = new DateFormatter();
                fieldVal = dateFormatter.format(fieldVal);
            }
            parameters.put(fieldNm, fieldVal.toString());
        }
        return parameters;
    }

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        List displayList = bounded ? this.getSearchResults(lookupForm.getFieldsForLookup()) : this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        HashMap propertyTypes = new HashMap();
        boolean hasReturnableRow = false;
        for (BusinessObject element : displayList) {
            List columns = this.getColumns();
            for (Column col : columns) {
                Formatter formatter = col.getFormatter();
                String propValue = "";
                Object prop = ObjectUtils.getPropertyValue((Object)element, (String)col.getPropertyName());
                if (prop != null) {
                    propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
                }
                Class propClass = (Class)propertyTypes.get(col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                col.setPropertyValue(propValue);
                if (!StringUtils.isNotBlank((CharSequence)propValue)) continue;
                if (StringUtils.equals((CharSequence)"documentNumber", (CharSequence)col.getPropertyName())) {
                    String propertyURL = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                    col.setPropertyURL(propertyURL);
                    continue;
                }
                if (StringUtils.equals((CharSequence)"Actions", (CharSequence)col.getColumnTitle())) {
                    ContractsGrantsAgingOpenInvoicesReport detail = (ContractsGrantsAgingOpenInvoicesReport)element;
                    String proposalNumber = this.getProposalNumber(detail);
                    if (!StringUtils.isNotBlank((CharSequence)proposalNumber)) continue;
                    HtmlData.AnchorHtmlData collectionActivity = new HtmlData.AnchorHtmlData(this.getContractsGrantsReportHelperService().getInitiateCollectionActivityDocumentUrl(proposalNumber, detail.getDocumentNumber()), "", col.getPropertyValue());
                    collectionActivity.setAppendDisplayText("&nbsp;&nbsp;");
                    HtmlData.AnchorHtmlData tickler = new HtmlData.AnchorHtmlData(this.getTicklerUrl(proposalNumber), "", "Tickler Report");
                    List<HtmlData.AnchorHtmlData> anchorLists = List.of(collectionActivity, tickler);
                    col.setColumnAnchor((HtmlData)new HtmlData.MultipleAnchorHtmlData(anchorLists));
                    continue;
                }
                col.setPropertyURL("");
            }
            ResultRow row = new ResultRow(columns, "", "");
            if (element instanceof PersistableBusinessObject) {
                row.setObjectId(((PersistableBusinessObject)element).getObjectId());
            }
            boolean rowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(rowReturnable);
            if (rowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
        return displayList;
    }

    protected String getProposalNumber(ContractsGrantsAgingOpenInvoicesReport detail) {
        ContractsGrantsInvoiceDocument cgInvoice = (ContractsGrantsInvoiceDocument)this.getBusinessObjectService().findBySinglePrimaryKey(ContractsGrantsInvoiceDocument.class, (Object)detail.getDocumentNumber());
        return ObjectUtils.isNotNull((Object)((Object)cgInvoice.getInvoiceGeneralDetail())) && ObjectUtils.isNotNull((Object)cgInvoice.getInvoiceGeneralDetail().getProposalNumber()) ? cgInvoice.getInvoiceGeneralDetail().getProposalNumber() : null;
    }

    protected String getTicklerUrl(String proposalNumber) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "search");
        parameters.put("proposalNumber", proposalNumber);
        parameters.put("businessObjectClassName", TicklersReport.class.getName());
        parameters.put("docFormKey", "88888888");
        parameters.put("hideReturnLink", "true");
        return UrlFactory.parameterizeUrl((String)"arTicklersReport.do", parameters);
    }

    public ContractsGrantsAgingOpenInvoicesReportService getContractsGrantsAgingOpenInvoicesReportService() {
        return this.contractsGrantsAgingOpenInvoicesReportService;
    }

    public void setContractsGrantsAgingOpenInvoicesReportService(ContractsGrantsAgingOpenInvoicesReportService contractsGrantsAgingOpenInvoicesReportService) {
        this.contractsGrantsAgingOpenInvoicesReportService = contractsGrantsAgingOpenInvoicesReportService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

