/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.dataaccess.NonAppliedHoldingDao;
import org.kuali.kfs.module.ar.document.service.NonAppliedHoldingService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class NonAppliedHoldingServiceImpl
implements NonAppliedHoldingService {
    private NonAppliedHoldingDao nonAppliedHoldingDao;

    @Override
    public Collection<NonAppliedHolding> getNonAppliedHoldingsForCustomer(Customer customer) {
        return null == customer ? null : this.getNonAppliedHoldingsForCustomer(customer.getCustomerNumber());
    }

    @Override
    public Collection<NonAppliedHolding> getNonAppliedHoldingsForCustomer(String customerNumber) {
        if (StringUtils.isBlank((CharSequence)customerNumber)) {
            throw new IllegalArgumentException("The parameter [customerNumber] passed in was blank or null.");
        }
        ArrayList<NonAppliedHolding> nonAppliedHoldings = new ArrayList<NonAppliedHolding>();
        Collection<NonAppliedHolding> tempList = this.nonAppliedHoldingDao.getNonAppliedHoldingsForCustomer(customerNumber);
        for (NonAppliedHolding nonAppliedHolding : tempList) {
            if (!nonAppliedHolding.getAvailableUnappliedAmount().isPositive()) continue;
            nonAppliedHoldings.add(nonAppliedHolding);
        }
        return nonAppliedHoldings;
    }

    @Override
    public Collection<NonAppliedHolding> getNonAppliedHoldingsByListOfDocumentNumbers(List<String> docNumbers) {
        if (docNumbers == null) {
            throw new IllegalArgumentException("The parameter [docNumbers] passed in was null.");
        }
        if (docNumbers.isEmpty()) {
            return new ArrayList<NonAppliedHolding>();
        }
        return this.nonAppliedHoldingDao.getNonAppliedHoldingsByListOfDocumentNumbers(docNumbers);
    }

    public void setNonAppliedHoldingDao(NonAppliedHoldingDao nonAppliedHoldingDao) {
        this.nonAppliedHoldingDao = nonAppliedHoldingDao;
    }
}

