/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.sys.context.SpringContext;

public class SystemInformationRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger();
    protected ObjectTypeService objectTypeService;
    protected AccountService accountService;
    protected SystemInformation newSystemInformation;
    protected SystemInformation oldSystemInformation;

    public SystemInformationRule() {
        this.setObjectTypeService((ObjectTypeService)SpringContext.getBean(ObjectTypeService.class));
    }

    public void setupConvenienceObjects() {
        this.oldSystemInformation = (SystemInformation)((Object)super.getOldBo());
        this.newSystemInformation = (SystemInformation)((Object)super.getNewBo());
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering processCustomApproveDocumentBusinessRules()");
        boolean success = this.checkClearingAccountIsActive();
        return success &= this.checkLockboxNumberIsUnique();
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering processCustomRouteDocumentBusinessRules()");
        boolean success = this.checkClearingAccountIsActive();
        return success &= this.checkLockboxNumberIsUnique();
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.debug("Entering processCustomSaveDocumentBusinessRules()");
        this.checkClearingAccountIsActive();
        this.checkLockboxNumberIsUnique();
        return true;
    }

    protected boolean checkClearingAccountIsActive() {
        LOG.debug("Entering checkClearingAccountIsActive()");
        boolean success = true;
        AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
        Account clearingAccount = accountService.getByPrimaryId(this.newSystemInformation.getUniversityClearingChartOfAccountsCode(), this.newSystemInformation.getUniversityClearingAccountNumber());
        if (ObjectUtils.isNull((Object)clearingAccount)) {
            return false;
        }
        if (!clearingAccount.isActive()) {
            success = false;
            this.putGlobalError("error.SystemInformation.clearingAccountInactive");
        }
        return success;
    }

    protected boolean checkLockboxNumberIsUnique() {
        LOG.debug("Entering checkLockboxNumberIsUnique()");
        boolean success = true;
        SystemInformationService systemInformationService = (SystemInformationService)SpringContext.getBean(SystemInformationService.class);
        int recordNumber = systemInformationService.getCountByChartOrgAndLockboxNumber(this.newSystemInformation.getProcessingChartOfAccountCode(), this.newSystemInformation.getProcessingOrganizationCode(), this.newSystemInformation.getLockboxNumber());
        if (recordNumber > 0) {
            success = false;
            this.putFieldError("lockboxNumber", "error.SystemInformation.lockboxNumberNotUnique");
        }
        return success;
    }

    public ObjectTypeService getObjectTypeService() {
        return this.objectTypeService;
    }

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }
}

