/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.report.service.FederalFinancialReportService;

public class FederalFinancialReportServiceImpl
implements FederalFinancialReportService {
    @Override
    public String validate(String federalForm, String proposalNumber, String fiscalYear, String reportingPeriod, String agencyNumber) {
        if (StringUtils.isNotEmpty((CharSequence)federalForm)) {
            if (StringUtils.equals((CharSequence)"425", (CharSequence)federalForm)) {
                if (ObjectUtils.isNull((Object)proposalNumber)) {
                    return "Please enter a proposal Number for SF425.";
                }
                if (StringUtils.isEmpty((CharSequence)fiscalYear) || StringUtils.isEmpty((CharSequence)reportingPeriod)) {
                    return "Enter both period and fiscal year.";
                }
            } else if (StringUtils.equals((CharSequence)"425A", (CharSequence)federalForm)) {
                if (ObjectUtils.isNull((Object)agencyNumber)) {
                    return "Please enter an Agency for SF425A.";
                }
                if (StringUtils.isEmpty((CharSequence)fiscalYear) || StringUtils.isEmpty((CharSequence)reportingPeriod)) {
                    return "Enter both period and fiscal year.";
                }
            }
            return "";
        }
        return "Please select a Financial Form to generate.";
    }

    @Override
    public String getUrlForPrintInvoice(String basePath, String docId, String period, String year, String agencyNumber, String formType, String methodToCall) {
        String baseUrl = basePath + "/arFederalFinancialReport.do";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", methodToCall);
        if (StringUtils.isNotEmpty((CharSequence)formType)) {
            parameters.put("federalForm", formType);
        }
        if (StringUtils.isNotEmpty((CharSequence)agencyNumber)) {
            parameters.put("agencyNumber", agencyNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)period)) {
            parameters.put("reportingPeriod", period);
        }
        if (StringUtils.isNotEmpty((CharSequence)year)) {
            parameters.put("fiscalYear", year);
        }
        if (StringUtils.isNotEmpty((CharSequence)docId)) {
            parameters.put("docId", docId);
            parameters.put("command", "displayDocSearchView");
        }
        return UrlFactory.parameterizeUrl((String)baseUrl, parameters);
    }
}

