/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressCSV;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;

public class CustomerLoadCSVBuilder {
    private static Logger LOG = Logger.getLogger(CustomerLoadCSVBuilder.class);

    public static List<CustomerDigesterVO> buildCustomerDigestVO(List<Map<String, String>> parseDataList) {
        ArrayList<CustomerDigesterVO> customerVOs = new ArrayList<CustomerDigesterVO>();
        CustomerDigesterVO customer = null;
        for (Map<String, String> rowDataMap : parseDataList) {
            CustomerDigesterVO dataCustomer = CustomerLoadCSVBuilder.buildCustomerFromDataMap(rowDataMap);
            CustomerAddressDigesterVO dataAddress = CustomerLoadCSVBuilder.buildAddressFromDataMap(rowDataMap);
            if (!CustomerLoadCSVBuilder.isContinuingCustomer(customer, dataCustomer) || customer == null) {
                if (customer != null) {
                    customerVOs.add(customer);
                }
                customer = dataCustomer;
            }
            customer.addCustomerAddress(dataAddress);
        }
        customerVOs.add(customer);
        return customerVOs;
    }

    private static boolean isContinuingCustomer(CustomerDigesterVO customer, CustomerDigesterVO dataCustomer) {
        return StringUtils.isEmpty((String)dataCustomer.getCustomerName());
    }

    private static CustomerAddressDigesterVO buildAddressFromDataMap(Map<String, String> rowDataMap) {
        CustomerAddressDigesterVO address = new CustomerAddressDigesterVO();
        address.setCustomerAddressName(rowDataMap.get(CustomerAddressCSV.customerAddressName.name()));
        address.setCustomerLine1StreetAddress(rowDataMap.get(CustomerAddressCSV.customerLine1StreetAddress.name()));
        address.setCustomerLine2StreetAddress(rowDataMap.get(CustomerAddressCSV.customerLine2StreetAddress.name()));
        address.setCustomerCityName(rowDataMap.get(CustomerAddressCSV.customerCityName.name()));
        address.setCustomerStateCode(rowDataMap.get(CustomerAddressCSV.customerStateCode.name()));
        address.setCustomerZipCode(rowDataMap.get(CustomerAddressCSV.customerZipCode.name()));
        address.setCustomerCountryCode(rowDataMap.get(CustomerAddressCSV.customerCountryCode.name()));
        address.setCustomerAddressInternationalProvinceName(rowDataMap.get(CustomerAddressCSV.customerAddressInternationalProvinceName.name()));
        address.setCustomerInternationalMailCode(rowDataMap.get(CustomerAddressCSV.customerInternationalMailCode.name()));
        address.setCustomerEmailAddress(rowDataMap.get(CustomerAddressCSV.customerAddressEmail.name()));
        address.setCustomerAddressTypeCode(rowDataMap.get(CustomerAddressCSV.customerAddressTypeCode.name()));
        return address;
    }

    private static CustomerDigesterVO buildCustomerFromDataMap(Map<String, String> rowDataMap) {
        CustomerDigesterVO customer = new CustomerDigesterVO();
        customer.setCustomerNumber(rowDataMap.get(CustomerAddressCSV.customerNumber.name()));
        customer.setCustomerName(rowDataMap.get(CustomerAddressCSV.customerName.name()));
        customer.setCustomerParentCompanyNumber(rowDataMap.get(CustomerAddressCSV.customerParentCompanyNumber.name()));
        customer.setCustomerTypeCode(rowDataMap.get(CustomerAddressCSV.customerTypeCode.name()));
        customer.setCustomerLastActivityDate(rowDataMap.get(CustomerAddressCSV.customerLastActivityDate.name()));
        customer.setCustomerTaxTypeCode(rowDataMap.get(CustomerAddressCSV.customerTaxTypeCode.name()));
        customer.setCustomerTaxNbr(rowDataMap.get(CustomerAddressCSV.customerTaxNbr.name()));
        customer.setCustomerActiveIndicator(rowDataMap.get(CustomerAddressCSV.customerActiveIndicator.name()));
        customer.setCustomerPhoneNumber(rowDataMap.get(CustomerAddressCSV.customerPhoneNumber.name()));
        customer.setCustomer800PhoneNumber(rowDataMap.get(CustomerAddressCSV.customer800PhoneNumber.name()));
        customer.setCustomerContactName(rowDataMap.get(CustomerAddressCSV.customerContactName.name()));
        customer.setCustomerContactPhoneNumber(rowDataMap.get(CustomerAddressCSV.customerContactPhoneNumber.name()));
        customer.setCustomerFaxNumber(rowDataMap.get(CustomerAddressCSV.customerFaxNumber.name()));
        customer.setCustomerBirthDate(rowDataMap.get(CustomerAddressCSV.customerBirthDate.name()));
        customer.setCustomerTaxExemptIndicator(rowDataMap.get(CustomerAddressCSV.customerTaxExemptIndicator.name()));
        customer.setCustomerCreditLimitAmount(rowDataMap.get(CustomerAddressCSV.customerCreditLimitAmount.name()));
        customer.setCustomerCreditApprovedByName(rowDataMap.get(CustomerAddressCSV.customerCreditApprovedByName.name()));
        customer.setCustomerEmailAddress(rowDataMap.get(CustomerAddressCSV.customerEmailAddress.name()));
        return customer;
    }
}

