/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.ContractsGrantsInvoiceBatchCreateDocumentService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class ContractsGrantsInvoiceBatchCreateDocumentServiceImpl
implements ContractsGrantsInvoiceBatchCreateDocumentService {
    protected ContractsGrantsInvoiceCreateDocumentService contractsGrantsInvoiceCreateDocumentService;
    protected ConfigurationService configurationService;

    @Override
    public void createCGInvoiceDocumentsByAwards(Collection<ContractsAndGrantsBillingAward> awards, String errOutputFileName) {
        HashMap invalidGroup = new HashMap();
        List<ErrorMessage> errorMessages = this.getContractsGrantsInvoiceCreateDocumentService().createCGInvoiceDocumentsByAwards(awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        if (!CollectionUtils.isEmpty(errorMessages)) {
            File errOutPutfile = new File(errOutputFileName);
            try (PrintStream outputFileStream = null;){
                outputFileStream = new PrintStream(errOutPutfile);
                for (ErrorMessage errorMessage : errorMessages) {
                    outputFileStream.printf("%s\n", MessageFormat.format(this.getConfigurationService().getPropertyValueAsString(errorMessage.getErrorKey()), errorMessage.getMessageParameters()));
                }
            }
        }
    }

    @Override
    public void processBatchInvoiceDocumentCreation(String validationErrorOutputFileName, String invoiceDocumentErrorOutputFileName) {
        Collection<ContractsAndGrantsBillingAward> awards = this.getContractsGrantsInvoiceCreateDocumentService().retrieveNonLOCAwards();
        Collection<ContractsAndGrantsBillingAward> validAwards = this.getContractsGrantsInvoiceCreateDocumentService().validateAwards(awards, null, validationErrorOutputFileName, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH.getCode());
        this.createCGInvoiceDocumentsByAwards(validAwards, invoiceDocumentErrorOutputFileName);
    }

    public ContractsGrantsInvoiceCreateDocumentService getContractsGrantsInvoiceCreateDocumentService() {
        return this.contractsGrantsInvoiceCreateDocumentService;
    }

    public void setContractsGrantsInvoiceCreateDocumentService(ContractsGrantsInvoiceCreateDocumentService contractsGrantsInvoiceCreateDocumentService) {
        this.contractsGrantsInvoiceCreateDocumentService = contractsGrantsInvoiceCreateDocumentService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

