/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.dataaccess.impl;

import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.dataaccess.CustomerAgingReportDao;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class CustomerAgingReportDaoOjb
extends PlatformAwareDaoBaseOjb
implements CustomerAgingReportDao {
    @Override
    public HashMap<String, KualiDecimal> findInvoiceAmountByProcessingChartAndOrg(String chart, String org, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria criteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)begin)) {
            criteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            criteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        criteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        criteria.addEqualTo("customerInvoiceDocument.accountsReceivableDocumentHeader.processingChartOfAccountCode", (Object)chart);
        criteria.addEqualTo("customerInvoiceDocument.accountsReceivableDocumentHeader.processingOrganizationCode", (Object)org);
        criteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(amount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findAppliedAmountByProcessingChartAndOrg(String chart, String org, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria subCriteria = new Criteria();
        subCriteria.addEqualTo("financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(FinancialSystemDocumentHeader.class, (Criteria)subCriteria);
        subQuery.setAttributes(new String[]{"documentNumber"});
        Criteria criteria = new Criteria();
        criteria.addIn((Object)"documentNumber", (Query)subQuery);
        if (begin != null) {
            criteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            criteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        criteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        criteria.addEqualTo("customerInvoiceDocument.accountsReceivableDocumentHeader.processingChartOfAccountCode", (Object)chart);
        criteria.addEqualTo("customerInvoiceDocument.accountsReceivableDocumentHeader.processingOrganizationCode", (Object)org);
        criteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(InvoicePaidApplied.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(invoiceItemAppliedAmount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findDiscountAmountByProcessingChartAndOrg(String chart, String org, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria subCriteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)begin)) {
            subCriteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            subCriteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        subCriteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        subCriteria.addEqualTo("customerInvoiceDocument.accountsReceivableDocumentHeader.processingChartOfAccountCode", (Object)chart);
        subCriteria.addEqualTo("customerInvoiceDocument.accountsReceivableDocumentHeader.processingOrganizationCode", (Object)org);
        subCriteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        subCriteria.addEqualToField("documentNumber", "parentQuery.documentNumber");
        ReportQueryByCriteria subReportQuery = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"invoiceItemDiscountLineNumber"}, subCriteria);
        Criteria criteria = new Criteria();
        criteria.addIn((Object)"sequenceNumber", (Query)subReportQuery);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(amount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findInvoiceAmountByBillingChartAndOrg(String chart, String org, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria criteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)begin)) {
            criteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            criteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        criteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        criteria.addEqualTo("customerInvoiceDocument.billByChartOfAccountCode", (Object)chart);
        criteria.addEqualTo("customerInvoiceDocument.billedByOrganizationCode", (Object)org);
        criteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(amount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findAppliedAmountByBillingChartAndOrg(String chart, String org, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria subCriteria = new Criteria();
        subCriteria.addEqualTo("financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(FinancialSystemDocumentHeader.class, (Criteria)subCriteria);
        subQuery.setAttributes(new String[]{"documentNumber"});
        Criteria criteria = new Criteria();
        criteria.addIn((Object)"documentNumber", (Query)subQuery);
        if (begin != null) {
            criteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            criteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        criteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        criteria.addEqualTo("customerInvoiceDocument.billByChartOfAccountCode", (Object)chart);
        criteria.addEqualTo("customerInvoiceDocument.billedByOrganizationCode", (Object)org);
        criteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(InvoicePaidApplied.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(invoiceItemAppliedAmount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findDiscountAmountByBillingChartAndOrg(String chart, String org, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria subCriteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)begin)) {
            subCriteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            subCriteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        subCriteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        subCriteria.addEqualTo("customerInvoiceDocument.billByChartOfAccountCode", (Object)chart);
        subCriteria.addEqualTo("customerInvoiceDocument.billedByOrganizationCode", (Object)org);
        subCriteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        subCriteria.addEqualToField("documentNumber", "parentQuery.documentNumber");
        ReportQueryByCriteria subReportQuery = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"invoiceItemDiscountLineNumber"}, subCriteria);
        Criteria criteria = new Criteria();
        criteria.addIn((Object)"sequenceNumber", (Query)subReportQuery);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(amount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findInvoiceAmountByAccount(String chart, String account, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria criteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)begin)) {
            criteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            criteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        criteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        criteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        criteria.addEqualTo("chartOfAccountsCode", (Object)chart);
        criteria.addEqualTo("accountNumber", (Object)account);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(amount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findAppliedAmountByAccount(String chart, String account, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria subCriteria = new Criteria();
        subCriteria.addEqualTo("financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(FinancialSystemDocumentHeader.class, (Criteria)subCriteria);
        subQuery.setAttributes(new String[]{"documentNumber"});
        Criteria criteria = new Criteria();
        criteria.addIn((Object)"documentNumber", (Query)subQuery);
        if (begin != null) {
            criteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            criteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        criteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        criteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        criteria.addEqualTo("invoiceDetail.chartOfAccountsCode", (Object)chart);
        criteria.addEqualTo("invoiceDetail.accountNumber", (Object)account);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(InvoicePaidApplied.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(invoiceItemAppliedAmount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public HashMap<String, KualiDecimal> findDiscountAmountByAccount(String chart, String account, Date begin, Date end) {
        HashMap<String, KualiDecimal> map = new HashMap<String, KualiDecimal>();
        Criteria subCriteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)begin)) {
            subCriteria.addGreaterOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)begin);
        }
        if (ObjectUtils.isNotNull((Object)end)) {
            subCriteria.addLessOrEqualThan((Object)"customerInvoiceDocument.billingDate", (Object)end);
        }
        subCriteria.addEqualTo("customerInvoiceDocument.documentHeader.financialDocumentStatusCode", (Object)"A");
        subCriteria.addEqualTo("customerInvoiceDocument.openInvoiceIndicator", (Object)true);
        subCriteria.addEqualTo("chartOfAccountsCode", (Object)chart);
        subCriteria.addEqualTo("accountNumber", (Object)account);
        subCriteria.addEqualToField("documentNumber", "parentQuery.documentNumber");
        ReportQueryByCriteria subReportQuery = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"invoiceItemDiscountLineNumber"}, subCriteria);
        Criteria criteria = new Criteria();
        criteria.addIn((Object)"sequenceNumber", (Query)subReportQuery);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceDetail.class, new String[]{"customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", "customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName", "sum(amount)"}, criteria);
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber");
        reportByCriteria.addGroupBy("customerInvoiceDocument.accountsReceivableDocumentHeader.customer.customerName");
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            map.put((String)data[0] + "-" + data[1], (KualiDecimal)data[2]);
        }
        return map;
    }

    @Override
    public KualiDecimal findWriteOffAmountByCustomerNumber(String customerNumber) {
        KualiDecimal writeOffAmt = KualiDecimal.ZERO;
        Criteria subCriteria = new Criteria();
        subCriteria.addEqualTo("customerInvoiceWriteoffDocument.customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", (Object)customerNumber);
        ReportQueryByCriteria reportByCriteria = new ReportQueryByCriteria(CustomerInvoiceWriteoffDocument.class, new String[]{"sum(invoiceWriteoffAmount)"}, subCriteria);
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)reportByCriteria);
        while (ObjectUtils.isNotNull((Object)iterator) && iterator.hasNext()) {
            Object[] data = (Object[])iterator.next();
            writeOffAmt = (KualiDecimal)data[0];
        }
        return writeOffAmt;
    }
}

