/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.InvoiceSuspensionCategory;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class ContractsGrantsInvoiceDocument
extends CustomerInvoiceDocument {
    protected static Logger LOG = Logger.getLogger(ContractsGrantsInvoiceDocument.class);
    private KualiDecimal paymentAmount = KualiDecimal.ZERO;
    private KualiDecimal balanceDue = KualiDecimal.ZERO;
    private List<ContractsGrantsInvoiceDetail> invoiceDetails;
    private List<CollectionEvent> collectionEvents;
    private List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes;
    private List<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
    private List<InvoiceAccountDetail> accountDetails;
    private InvoiceGeneralDetail invoiceGeneralDetail;
    private List<InvoiceMilestone> invoiceMilestones;
    private List<InvoiceBill> invoiceBills;
    private List<InvoiceSuspensionCategory> invoiceSuspensionCategories;
    private final String REQUIRES_APPROVAL_SPLIT = "RequiresApprovalSplit";

    public ContractsGrantsInvoiceDocument() {
        this.invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        this.collectionEvents = new ArrayList<CollectionEvent>();
        this.accountDetails = new ArrayList<InvoiceAccountDetail>();
        this.invoiceMilestones = new ArrayList<InvoiceMilestone>();
        this.invoiceBills = new ArrayList<InvoiceBill>();
        this.invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        this.invoiceSuspensionCategories = new ArrayList<InvoiceSuspensionCategory>();
    }

    public boolean isFinalizable() {
        if (this == null) {
            return false;
        }
        return this.getDocumentHeader().getWorkflowDocument().getDateCreated().isAfter(this.getInvoiceGeneralDetail().getAward().getAwardEndingDate().getTime());
    }

    public boolean isCorrectionDocument() {
        return !StringUtils.isEmpty((String)this.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber());
    }

    public List buildListOfDeletionAwareLists() {
        List deletionAwareLists = super.buildListOfDeletionAwareLists();
        if (this.invoiceSuspensionCategories != null) {
            deletionAwareLists.add(this.invoiceSuspensionCategories);
        }
        return deletionAwareLists;
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        if (!ArConstants.BillingFrequencyValues.isMilestone(this.getInvoiceGeneralDetail()) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling(this.getInvoiceGeneralDetail())) {
            ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
            contractsGrantsInvoiceDocumentService.recalculateTotalAmountBilledToDate(this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            contractsGrantsInvoiceDocumentService.updateLastBilledDate(this);
            if (this.isInvoiceReversal()) {
                try {
                    this.getInvoiceGeneralDetail().setFinalBillIndicator(false);
                    invoice = (ContractsGrantsInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(this.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber());
                    if (ObjectUtils.isNotNull((Object)invoice)) {
                        invoice.setInvoiceDueDate(new Date(new java.util.Date().getTime()));
                        invoice.getInvoiceGeneralDetail().setFinalBillIndicator(false);
                        ((DocumentService)SpringContext.getBean(DocumentService.class)).updateDocument((Document)invoice);
                        contractsGrantsInvoiceDocumentService.updateUnfinalizationToAwardAccount(invoice.getAccountDetails(), invoice.getInvoiceGeneralDetail().getProposalNumber());
                        this.getInvoiceGeneralDetail().setLastBilledDate(null);
                        if (ArConstants.BillingFrequencyValues.isMilestone(invoice.getInvoiceGeneralDetail())) {
                            contractsGrantsInvoiceDocumentService.updateMilestonesBilledIndicator(false, invoice.getInvoiceMilestones());
                        }
                        if (!ArConstants.BillingFrequencyValues.isPredeterminedBilling(invoice.getInvoiceGeneralDetail())) ** GOTO lbl30
                        contractsGrantsInvoiceDocumentService.updateBillsBilledIndicator(false, invoice.getInvoiceBills());
                    }
                    GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.correction.noInvoiceFound", new String[]{"error.invoice.not.correct"});
                }
                catch (WorkflowException ex) {
                    ContractsGrantsInvoiceDocument.LOG.error((Object)"problem during ContractsGrantsInvoiceDocument.doRouteStatusChange()", (Throwable)ex);
                    throw new RuntimeException("WorkflowException during ContractsGrantsInvoiceDocument.doRouteStatusChange()", ex);
                }
            } else {
                contractsGrantsInvoiceDocumentService.updateBillsAndMilestones(true, this.invoiceMilestones, this.invoiceBills);
                contractsGrantsInvoiceDocumentService.generateInvoicesForInvoiceAddresses(this);
            }
lbl30:
            // 5 sources

            contractsGrantsInvoiceDocumentService.addToAccountObjectCodeBilledTotal(this.invoiceDetailAccountObjectCodes);
        }
    }

    @Override
    public void toErrorCorrection() throws WorkflowException {
        super.toErrorCorrection();
        this.invoiceSuspensionCategories.clear();
        ((ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class)).correctContractsGrantsInvoiceDocument(this);
    }

    public List<ContractsGrantsInvoiceDetail> getDirectCostInvoiceDetails() {
        ArrayList<ContractsGrantsInvoiceDetail> invDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        for (ContractsGrantsInvoiceDetail invD : this.invoiceDetails) {
            if (invD.isIndirectCostIndicator()) continue;
            invDetails.add(invD);
        }
        return invDetails;
    }

    public List<ContractsGrantsInvoiceDetail> getIndirectCostInvoiceDetails() {
        ArrayList<ContractsGrantsInvoiceDetail> invDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        for (ContractsGrantsInvoiceDetail invD : this.invoiceDetails) {
            if (!invD.isIndirectCostIndicator()) continue;
            invDetails.add(invD);
        }
        return invDetails;
    }

    public List<ContractsGrantsInvoiceDetail> getInvoiceDetails() {
        return this.invoiceDetails;
    }

    public void setInvoiceDetails(List<ContractsGrantsInvoiceDetail> invoiceDetails) {
        this.invoiceDetails = invoiceDetails;
    }

    public List<InvoiceDetailAccountObjectCode> getInvoiceDetailAccountObjectCodes() {
        return this.invoiceDetailAccountObjectCodes;
    }

    public void setInvoiceDetailAccountObjectCodes(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        this.invoiceDetailAccountObjectCodes = invoiceDetailAccountObjectCodes;
    }

    public List<InvoiceAddressDetail> getInvoiceAddressDetails() {
        return this.invoiceAddressDetails;
    }

    public void setInvoiceAddressDetails(List<InvoiceAddressDetail> invoiceAddressDetails) {
        this.invoiceAddressDetails = invoiceAddressDetails;
    }

    public List<InvoiceAccountDetail> getAccountDetails() {
        return this.accountDetails;
    }

    public void setAccountDetails(List<InvoiceAccountDetail> accountDetails) {
        this.accountDetails = accountDetails;
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    @Override
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("documentNumber", this.documentNumber);
        m.put("invoiceGeneralDetail", (Object)this.invoiceGeneralDetail);
        return m;
    }

    public InvoiceGeneralDetail getInvoiceGeneralDetail() {
        return this.invoiceGeneralDetail;
    }

    public void setInvoiceGeneralDetail(InvoiceGeneralDetail invoiceGeneralDetail) {
        this.invoiceGeneralDetail = invoiceGeneralDetail;
    }

    public List<InvoiceMilestone> getInvoiceMilestones() {
        return this.invoiceMilestones;
    }

    public void setInvoiceMilestones(List<InvoiceMilestone> invoiceMilestones) {
        this.invoiceMilestones = invoiceMilestones;
    }

    public List<InvoiceBill> getInvoiceBills() {
        return this.invoiceBills;
    }

    public void setInvoiceBills(List<InvoiceBill> invoiceBills) {
        this.invoiceBills = invoiceBills;
    }

    public ContractsGrantsInvoiceDetail getTotalDirectCostInvoiceDetail() {
        ContractsGrantsInvoiceDetail totalDirectCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        for (ContractsGrantsInvoiceDetail currentInvoiceDetail : this.getDirectCostInvoiceDetails()) {
            totalDirectCostInvoiceDetail.sumInvoiceDetail(currentInvoiceDetail);
        }
        return totalDirectCostInvoiceDetail;
    }

    public List<CollectionEvent> getCollectionEvents() {
        return this.collectionEvents;
    }

    public void setCollectionEvents(List<CollectionEvent> collectionEvents) {
        this.collectionEvents = collectionEvents;
    }

    public String getNextCollectionEventCode() {
        String nextCollectionEventCode = this.documentNumber + "-" + String.format("%03d", this.collectionEvents.size() + 1);
        return nextCollectionEventCode;
    }

    public ContractsGrantsInvoiceDetail getTotalIndirectCostInvoiceDetail() {
        ContractsGrantsInvoiceDetail totalInDirectCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        for (ContractsGrantsInvoiceDetail currentInvoiceDetail : this.getIndirectCostInvoiceDetails()) {
            totalInDirectCostInvoiceDetail.sumInvoiceDetail(currentInvoiceDetail);
        }
        return totalInDirectCostInvoiceDetail;
    }

    public ContractsGrantsInvoiceDetail getTotalCostInvoiceDetail() {
        ContractsGrantsInvoiceDetail totalCostInvoiceDetail = new ContractsGrantsInvoiceDetail();
        totalCostInvoiceDetail.sumInvoiceDetail(this.getTotalDirectCostInvoiceDetail());
        totalCostInvoiceDetail.sumInvoiceDetail(this.getTotalIndirectCostInvoiceDetail());
        return totalCostInvoiceDetail;
    }

    public List<InvoiceSuspensionCategory> getInvoiceSuspensionCategories() {
        return this.invoiceSuspensionCategories;
    }

    public void setInvoiceSuspensionCategories(List<InvoiceSuspensionCategory> invoiceSuspensionCategories) {
        this.invoiceSuspensionCategories = invoiceSuspensionCategories;
    }

    @Override
    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("RequiresApprovalSplit")) {
            return this.isRequiresFundingManagerApproval();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    private boolean isRequiresFundingManagerApproval() {
        ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        boolean result = !CollectionUtils.isEmpty(this.getInvoiceSuspensionCategories()) || !this.getInvoiceGeneralDetail().getAward().getAutoApproveIndicator() || contractsGrantsInvoiceDocumentService.isDocumentBatchCreated(this) && !contractsGrantsInvoiceDocumentService.doesInvoicePassValidation(this);
        return result;
    }

    public KualiDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(KualiDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public KualiDecimal getBalanceDue() {
        return this.balanceDue;
    }

    public void setBalanceDue(KualiDecimal balanceDue) {
        this.balanceDue = balanceDue;
    }

    public String getCustomerNumber() {
        return this.accountsReceivableDocumentHeader.getCustomerNumber();
    }

    public KualiDecimal getTotalBudgetAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (InvoiceAccountDetail accountDetail : this.accountDetails) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDetail.getTotalBudget());
        }
        return total;
    }

    public KualiDecimal getTotalInvoiceAmount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (InvoiceAccountDetail accountDetail : this.accountDetails) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDetail.getInvoiceAmount());
        }
        return total;
    }

    public KualiDecimal getTotalCumulativeExpenditures() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (InvoiceAccountDetail accountDetail : this.accountDetails) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDetail.getCumulativeExpenditures());
        }
        return total;
    }

    public KualiDecimal getTotalBudgetRemaining() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (InvoiceAccountDetail accountDetail : this.accountDetails) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDetail.getBudgetRemaining());
        }
        return total;
    }

    public KualiDecimal getTotalAmountBilledToDate() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (InvoiceAccountDetail accountDetail : this.accountDetails) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)accountDetail.getTotalAmountBilledToDate());
        }
        return total;
    }

    @Override
    protected boolean isInvoiceDetailReceivableDebit(CustomerInvoiceDetail customerInvoiceDetail) {
        return customerInvoiceDetail.getAmount().isZero() || customerInvoiceDetail.getAmount().isPositive();
    }

    @Override
    protected boolean isInvoiceDetailIncomeDebit(CustomerInvoiceDetail customerInvoiceDetail) {
        return customerInvoiceDetail.getAmount().isZero() || customerInvoiceDetail.getAmount().isNegative();
    }
}

